/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.psmlmanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jetspeed.cache.FileCache;
import org.apache.jetspeed.cache.FileCacheEntry;
import org.apache.jetspeed.cache.FileCacheEventListener;
import org.apache.jetspeed.om.profile.BasePSMLDocument;
import org.apache.jetspeed.om.profile.ImportProfile;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.QueryLocator;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedGroupFactory;
import org.apache.jetspeed.om.security.JetspeedRoleFactory;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUserFactory;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.psmlmanager.PsmlManagerService;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.DirectoryUtils;
import org.apache.jetspeed.util.FileCopy;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CastorPsmlManagerService
extends TurbineBaseService
implements FileCacheEventListener,
PsmlManagerService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CastorPsmlManagerService.class.getName());
    protected static final String PATH_GROUP = "group";
    protected static final String PATH_ROLE = "role";
    protected static final String PATH_USER = "user";
    protected static final String CONFIG_ROOT = "root";
    protected static final String CONFIG_EXT = "ext";
    protected static final String CONFIG_SCAN_RATE = "scanRate";
    protected static final String CONFIG_CACHE_SIZE = "cacheSize";
    public static final String DEFAULT_ROOT = "/WEB-INF/psml";
    public static final String DEFAULT_EXT = ".psml";
    public static final String DEFAULT_RESOURCE = "default.psml";
    protected String root;
    protected File rootDir = null;
    protected String ext;
    protected FileCache documents = null;
    protected OutputFormat format = null;
    protected long scanRate = 60000L;
    protected int cacheSize = 100;
    protected PsmlManagerService consumer = null;
    protected boolean importFlag = false;
    public static final String DEFAULT_MAPPING = "${webappRoot}/WEB-INF/conf/psml-mapping.xml";
    protected String mapFile = null;
    protected Mapping mapping = null;
    protected String defaultEncoding = JetspeedResources.getString("content.defaultencoding", "utf-8");
    protected static int STATE_INIT = 0;
    protected static int STATE_BASE = 1;
    protected static int STATE_NAME = 2;
    protected static int STATE_MEDIA = 3;
    protected static int STATE_LANGUAGE = 4;
    protected static int STATE_COUNTRY = 5;
    static int QUERY_BY_USER = 0;
    static int QUERY_BY_ROLE = 1;
    static int QUERY_BY_GROUP = 2;

    public void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        TurbineServices.getInstance().initService("ServletService", (Object)conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
        this.root = serviceConf.getString(CONFIG_ROOT, DEFAULT_ROOT);
        this.rootDir = new File(this.root);
        if (!this.rootDir.exists()) {
            try {
                this.rootDir = new File(conf.getServletContext().getRealPath(this.root));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.rootDir.exists()) {
            try {
                this.rootDir.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ext = serviceConf.getString(CONFIG_EXT, DEFAULT_EXT);
        this.format = new OutputFormat();
        this.format.setIndenting(true);
        this.format.setIndent(4);
        this.format.setLineWidth(0);
        this.mapFile = serviceConf.getString("mapping", DEFAULT_MAPPING);
        this.mapFile = TurbineServlet.getRealPath((String)this.mapFile);
        this.loadMapping();
        this.scanRate = serviceConf.getLong(CONFIG_SCAN_RATE, this.scanRate);
        this.cacheSize = serviceConf.getInt(CONFIG_CACHE_SIZE, this.cacheSize);
        this.documents = new FileCache(this.scanRate, this.cacheSize);
        this.documents.addListener(this);
        this.documents.startFileScanner();
        this.setInit(true);
    }

    public void init() throws InitializationException {
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                logger.error("Exception", ie);
            }
        }
    }

    public void shutdown() {
        this.documents.stopFileScanner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSMLDocument getDocument(String name) {
        if (name == null) {
            String message = "PSMLManager: Must specify a name";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PSMLManager: asked for " + name);
        }
        PSMLDocument doc = null;
        doc = (PSMLDocument)this.documents.getDocument(name);
        if (doc == null) {
            doc = this.loadDocument(name);
            FileCache fileCache = this.documents;
            synchronized (fileCache) {
                try {
                    this.documents.put(name, (Object)doc);
                }
                catch (IOException e) {
                    logger.error("Error putting document", e);
                }
            }
        }
        return doc;
    }

    public PSMLDocument getDocument(ProfileLocator locator) {
        return this.getDocument(locator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PSMLDocument getDocument(ProfileLocator locator, boolean getCached) {
        if (locator == null) {
            String message = "PSMLManager: Must specify a name";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        File base = this.rootDir;
        String path = this.mapLocatorToFile(locator);
        File file = new File(base, path);
        String name = null;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("PSMLManager: unable to resolve file path for " + file);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PSMLManager: calculated resource:" + path + ". Base: " + base + " File: " + name);
        }
        PSMLDocument doc = null;
        Profile profile = null;
        if (getCached) {
            profile = (Profile)this.documents.getDocument(name);
        }
        if (profile == null) {
            doc = this.loadDocument(name);
            if (null == doc) {
                if (logger.isWarnEnabled()) {
                    logger.warn("PSMLManager: " + name + " not found, returning null document");
                }
                return null;
            }
            FileCache fileCache = this.documents;
            synchronized (fileCache) {
                Profile newProfile = this.createProfile(locator);
                newProfile.setDocument(doc);
                try {
                    this.documents.put(name, (Object)newProfile);
                }
                catch (IOException e) {
                    logger.error("Error putting document", e);
                }
            }
        }
        doc = profile.getDocument();
        return doc;
    }

    public PSMLDocument refresh(ProfileLocator locator) {
        if (logger.isDebugEnabled()) {
            logger.debug("CastorPsmlManagerService: psml document refreshed from disk: " + locator.getPath());
        }
        return this.getDocument(locator, false);
    }

    protected PSMLDocument loadDocument(String fileOrUrl) {
        BasePSMLDocument doc = null;
        if (fileOrUrl != null) {
            File f;
            if (!fileOrUrl.endsWith(DEFAULT_EXT)) {
                fileOrUrl = fileOrUrl.concat(DEFAULT_EXT);
            }
            if (null == (f = this.getFile(fileOrUrl))) {
                return null;
            }
            doc = new BasePSMLDocument();
            doc.setName(fileOrUrl);
            Portlets portlets = null;
            try {
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbfactory.newDocumentBuilder();
                Document d = builder.parse(f);
                Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
                portlets = (Portlets)unmarshaller.unmarshal((Node)d);
                doc.setPortlets(portlets);
            }
            catch (IOException e) {
                logger.error("PSMLManager: Could not load the file " + f.getAbsolutePath(), e);
                doc = null;
            }
            catch (MarshalException e) {
                logger.error("PSMLManager: Could not unmarshal the file " + f.getAbsolutePath(), e);
                doc = null;
            }
            catch (MappingException e) {
                logger.error("PSMLManager: Could not unmarshal the file " + f.getAbsolutePath(), e);
                doc = null;
            }
            catch (ValidationException e) {
                logger.error("PSMLManager: document " + f.getAbsolutePath() + " is not valid", e);
                doc = null;
            }
            catch (ParserConfigurationException e) {
                logger.error("PSMLManager: Could not load the file " + f.getAbsolutePath(), e);
                doc = null;
            }
            catch (SAXException e) {
                logger.error("PSMLManager: Could not load the file " + f.getAbsolutePath(), e);
                doc = null;
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(Profile profile) {
        PSMLDocument doc = profile.getDocument();
        File base = this.rootDir;
        String path = this.mapLocatorToFile(profile);
        File file = new File(base, path);
        String fullpath = null;
        try {
            fullpath = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("PSMLManager: unable to resolve file path for " + file);
        }
        boolean ok = this.saveDocument(fullpath, doc);
        FileCache fileCache = this.documents;
        synchronized (fileCache) {
            try {
                this.documents.put(fullpath, (Object)profile);
            }
            catch (IOException e) {
                logger.error("Error storing document", e);
            }
        }
        return ok;
    }

    public boolean saveDocument(PSMLDocument doc) {
        return this.saveDocument(doc.getName(), doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveDocument(String fileOrUrl, PSMLDocument doc) {
        boolean success = false;
        if (doc == null) {
            return false;
        }
        File f = this.getFile(fileOrUrl);
        if (f == null) {
            f = new File(fileOrUrl);
        }
        OutputStreamWriter writer = null;
        FileOutputStream fos = null;
        try {
            String encoding = this.defaultEncoding;
            fos = new FileOutputStream(f);
            writer = new OutputStreamWriter((OutputStream)fos, encoding);
            this.save(writer, doc.getPortlets());
            success = true;
        }
        catch (MarshalException e) {
            logger.error("PSMLManager: Could not marshal the file " + f.getAbsolutePath(), e);
        }
        catch (MappingException e) {
            logger.error("PSMLManager: Could not marshal the file " + f.getAbsolutePath(), e);
        }
        catch (ValidationException e) {
            logger.error("PSMLManager: document " + f.getAbsolutePath() + " is not valid", e);
        }
        catch (IOException e) {
            logger.error("PSMLManager: Could not save the file " + f.getAbsolutePath(), e);
        }
        catch (Exception e) {
            logger.error("PSMLManager: Error while saving  " + f.getAbsolutePath(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
        return success;
    }

    protected Portlets load(Reader reader) throws IOException, MarshalException, ValidationException, MappingException {
        Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
        Portlets portlets = (Portlets)unmarshaller.unmarshal(reader);
        return portlets;
    }

    protected void loadMapping() throws InitializationException {
        if (this.mapFile != null) {
            File map = new File(this.mapFile);
            if (logger.isDebugEnabled()) {
                logger.debug("PSMLManager: Loading psml mapping file " + this.mapFile);
            }
            if (map.exists() && map.isFile() && map.canRead()) {
                try {
                    this.mapping = new Mapping();
                    InputSource is = new InputSource(new FileReader(map));
                    is.setSystemId(this.mapFile);
                    this.mapping.loadMapping(is);
                }
                catch (Exception e) {
                    logger.error("PSMLManager: Error in psml mapping creation", e);
                    throw new InitializationException("Error in mapping", (Throwable)e);
                }
            } else {
                throw new InitializationException("PSML Mapping not found or not a file or unreadable: " + this.mapFile);
            }
        }
    }

    protected void save(Writer writer, Portlets portlets) throws IOException, MarshalException, ValidationException, MappingException {
        String encoding = this.defaultEncoding;
        if (portlets != null) {
            this.format.setEncoding(encoding);
            XMLSerializer serializer = new XMLSerializer(writer, this.format);
            Marshaller marshaller = new Marshaller(serializer.asDocumentHandler());
            marshaller.setMapping(this.mapping);
            marshaller.marshal((Object)portlets);
        }
    }

    protected File getFile(String fileOrUrl) {
        File f = null;
        f = new File(fileOrUrl);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public PSMLDocument createDocument(Profile profile) {
        File base = this.rootDir;
        String path = this.mapLocatorToFile(profile);
        if (logger.isDebugEnabled()) {
            logger.debug("PSMLManager: Create document for profile " + profile + ", calculated path: " + path);
        }
        File file = new File(base, path);
        String name = null;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("PSMLManager: unable to resolve file path for " + file);
        }
        PSMLDocument template = profile.getDocument();
        BasePSMLDocument doc = new BasePSMLDocument(name, template.getPortlets());
        try {
            String parent = file.getParent();
            File filePath = new File(parent);
            filePath.mkdirs();
            if (template.getName() != null) {
                try {
                    File source = new File(template.getName());
                    if (source.exists()) {
                        FileCopy.copy(template.getName(), name);
                    }
                }
                catch (Exception e) {}
            } else {
                doc.setName(name);
            }
            this.saveDocument(doc);
        }
        catch (Exception e) {
            logger.error("PSMLManager: Failed to save document: ", e);
        }
        return doc;
    }

    public PSMLDocument getDocument(List locators) {
        PSMLDocument doc = null;
        Iterator i = locators.iterator();
        while (doc == null && i.hasNext()) {
            doc = this.getDocument((ProfileLocator)i.next());
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(ProfileLocator locator) {
        String fileName = this.mapLocatorToFile(locator);
        File base = this.rootDir;
        File file = new File(base, fileName);
        String name = null;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("PSMLManager: unable to resolve file path for " + file);
        }
        FileCache fileCache = this.documents;
        synchronized (fileCache) {
            this.documents.remove(name);
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserDocuments(JetspeedUser user) {
        ProfileLocator locator = Profiler.createLocator();
        locator.setUser(user);
        StringBuffer buffer = new StringBuffer();
        buffer.append(PATH_USER);
        String name = user.getUserName();
        if (null == name || name.length() <= 0) {
            return;
        }
        buffer.append(File.separator).append(name);
        String path = buffer.toString();
        File base = this.rootDir;
        File file = new File(base, path);
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("PSMLManager: unable to resolve file path for " + file);
        }
        FileCache fileCache = this.documents;
        synchronized (fileCache) {
            DirectoryUtils.rmdir(name);
            Iterator it = this.documents.getIterator();
            while (it.hasNext()) {
                JetspeedUser pUser;
                Profile profile;
                FileCacheEntry entry = (FileCacheEntry)it.next();
                if (null == entry || null == (profile = (Profile)entry.getDocument()) || null == (pUser = profile.getUser()) || !pUser.getUserName().equals(user.getUserName())) continue;
                this.documents.remove(profile.getDocument().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoleDocuments(Role role) {
        ProfileLocator locator = Profiler.createLocator();
        locator.setRole(role);
        StringBuffer buffer = new StringBuffer();
        buffer.append(PATH_ROLE);
        String name = role.getName();
        if (null == name || name.length() <= 0) {
            return;
        }
        buffer.append(File.separator).append(name);
        String path = buffer.toString();
        File base = this.rootDir;
        File file = new File(base, path);
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("PSMLManager: unable to resolve file path for " + file);
        }
        FileCache fileCache = this.documents;
        synchronized (fileCache) {
            DirectoryUtils.rmdir(name);
            Iterator it = this.documents.getIterator();
            while (it.hasNext()) {
                Role pRole;
                Profile profile;
                FileCacheEntry entry = (FileCacheEntry)it.next();
                if (null == entry || null == (profile = (Profile)entry.getDocument()) || null == (pRole = profile.getRole()) || !pRole.getName().equals(role.getName())) continue;
                this.documents.remove(profile.getDocument().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupDocuments(Group group) {
        ProfileLocator locator = Profiler.createLocator();
        locator.setGroup(group);
        StringBuffer buffer = new StringBuffer();
        buffer.append(PATH_GROUP);
        String name = group.getName();
        if (null == name || name.length() <= 0) {
            return;
        }
        buffer.append(File.separator).append(name);
        String path = buffer.toString();
        File base = this.rootDir;
        File file = new File(base, path);
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("PSMLManager: unable to resolve file path for " + file);
        }
        FileCache fileCache = this.documents;
        synchronized (fileCache) {
            DirectoryUtils.rmdir(name);
            Iterator it = this.documents.getIterator();
            while (it.hasNext()) {
                Group pGroup;
                Profile profile;
                FileCacheEntry entry = (FileCacheEntry)it.next();
                if (null == entry || null == (profile = (Profile)entry.getDocument()) || null == (pGroup = profile.getGroup()) || !pGroup.getName().equals(group.getName())) continue;
                this.documents.remove(profile.getDocument().getName());
            }
        }
    }

    protected String mapLocatorToFile(ProfileLocator locator) {
        StringBuffer path = new StringBuffer();
        Role role = locator.getRole();
        Group group = locator.getGroup();
        JetspeedUser user = locator.getUser();
        if (user != null) {
            path.append(PATH_USER);
            String name = user.getUserName();
            if (null != name && name.length() > 0) {
                path.append(File.separator).append(name);
            }
        } else if (group != null) {
            path.append(PATH_GROUP);
            String name = group.getName();
            if (null != name && name.length() > 0) {
                path.append(File.separator).append(name);
            }
        } else if (null != role) {
            path.append(PATH_ROLE);
            String name = role.getName();
            if (null != name && name.length() > 0) {
                path.append(File.separator).append(name);
            }
        }
        if (null != locator.getMediaType()) {
            path.append(File.separator).append(locator.getMediaType());
        }
        if (null != locator.getLanguage() && !locator.getLanguage().equals("-1")) {
            path.append(File.separator).append(locator.getLanguage());
        }
        if (null != locator.getCountry() && !locator.getCountry().equals("-1")) {
            path.append(File.separator).append(locator.getCountry());
        }
        if (null != locator.getName()) {
            if (!locator.getName().endsWith(DEFAULT_EXT)) {
                path.append(File.separator).append(locator.getName()).append(DEFAULT_EXT);
            } else {
                path.append(File.separator).append(locator.getName());
            }
        } else {
            path.append(File.separator).append(DEFAULT_RESOURCE);
        }
        return path.toString();
    }

    public Iterator query(QueryLocator locator) {
        QueryState qs;
        String absPath;
        File file;
        File base;
        int state;
        String name;
        StringBuffer path;
        Profile profile;
        LinkedList list = new LinkedList();
        Role role = locator.getRole();
        Group group = locator.getGroup();
        JetspeedUser user = locator.getUser();
        int qm = locator.getQueryMode();
        if ((qm & 1) == 1) {
            profile = this.createProfile();
            path = new StringBuffer();
            path.append(PATH_USER);
            name = null;
            state = STATE_INIT;
            if (null != user) {
                name = user.getUserName();
                profile.setUser(user);
                if (null != name) {
                    path.append(File.separator).append(name);
                    state = STATE_BASE;
                }
            }
            base = this.rootDir;
            file = new File(base, path.toString());
            absPath = file.getAbsolutePath();
            qs = new QueryState(QUERY_BY_USER, profile, locator, list, name, state);
            this.subQuery(qs, absPath);
        }
        if ((qm & 2) == 2) {
            profile = this.createProfile();
            path = new StringBuffer();
            path.append(PATH_ROLE);
            name = null;
            state = STATE_INIT;
            if (null != role) {
                name = role.getName();
                profile.setRole(role);
                if (null != name) {
                    path.append(File.separator).append(name);
                    state = STATE_BASE;
                }
            }
            base = this.rootDir;
            file = new File(base, path.toString());
            absPath = null;
            try {
                absPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error("PSMLManager: unable to resolve file path for " + file);
            }
            qs = new QueryState(QUERY_BY_ROLE, profile, locator, list, name, state);
            this.subQuery(qs, absPath);
        }
        if ((qm & 4) == 4) {
            profile = this.createProfile();
            path = new StringBuffer();
            path.append(PATH_GROUP);
            name = null;
            state = STATE_INIT;
            if (null != group) {
                name = group.getName();
                profile.setGroup(group);
                if (null != name) {
                    path.append(File.separator).append(name);
                    state = STATE_BASE;
                }
            }
            base = this.rootDir;
            file = new File(base, path.toString());
            absPath = null;
            try {
                absPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error("PSMLManager: unable to resolve file path for " + file);
            }
            qs = new QueryState(QUERY_BY_GROUP, profile, locator, list, name, state);
            this.subQuery(qs, absPath);
        }
        return list.iterator();
    }

    protected Profile createProfile() {
        if (this.importFlag) {
            return new ImportProfile(this, this.consumer);
        }
        return Profiler.createProfile();
    }

    protected Profile createProfile(ProfileLocator locator) {
        if (this.importFlag) {
            return new ImportProfile(this, this.consumer, locator);
        }
        return Profiler.createProfile(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int export(PsmlManagerService consumer, QueryLocator locator) {
        this.importFlag = true;
        Iterator profiles = null;
        int count = 0;
        try {
            this.consumer = consumer;
            profiles = this.query(locator);
            while (profiles.hasNext()) {
                Profile profile = (Profile)profiles.next();
                try {
                    consumer.createDocument(profile);
                    ++count;
                }
                catch (Exception ex) {
                    try {
                        consumer.store(profile);
                        ++count;
                    }
                    catch (Exception e) {
                        logger.error("PSMLManager: Failed to export profiles to DB: " + profile, ex);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("PSMLManager: Failed to export profiles to DB: ", e);
        }
        finally {
            this.importFlag = false;
        }
        return count;
    }

    protected void subQuery(QueryState qs, String path) {
        File file = new File(path);
        if (file.isFile()) {
            try {
                String filename = file.getName();
                if (!filename.endsWith(this.ext)) {
                    return;
                }
                Profile clone = (Profile)qs.profile.clone();
                clone.setName(filename);
                qs.list.add(clone);
            }
            catch (Exception e) {
                logger.error("PSMLManager: Failed to clone profile: " + path + " : " + e, e);
            }
        } else if (file.isDirectory()) {
            String dirName = file.getName();
            ++qs.state;
            if (qs.state == STATE_NAME) {
                if (null != qs.name && !dirName.equals(qs.name)) {
                    return;
                }
                try {
                    Group group;
                    if (QUERY_BY_USER == qs.queryBy) {
                        JetspeedUser user = qs.profile.getUser();
                        if (null == user) {
                            user = JetspeedUserFactory.getInstance();
                            user.setUserName(file.getName());
                            qs.profile.setUser(user);
                            qs.clearName = true;
                        }
                    } else if (QUERY_BY_ROLE == qs.queryBy) {
                        Role role = qs.profile.getRole();
                        if (null == role) {
                            role = JetspeedRoleFactory.getInstance();
                            role.setName(file.getName());
                            qs.profile.setRole(role);
                            qs.clearName = true;
                        }
                    } else if (QUERY_BY_GROUP == qs.queryBy && null == (group = qs.profile.getGroup())) {
                        group = JetspeedGroupFactory.getInstance();
                        group.setName(file.getName());
                        qs.profile.setGroup(group);
                        qs.clearName = true;
                    }
                }
                catch (Exception e) {}
            } else if (qs.state == STATE_MEDIA) {
                String media = qs.locator.getMediaType();
                if (null != media) {
                    if (!dirName.equals(media)) {
                        return;
                    }
                } else {
                    qs.profile.setMediaType(dirName);
                    qs.clearMedia = true;
                }
            } else if (qs.state == STATE_LANGUAGE) {
                String language = qs.locator.getLanguage();
                if (null != language) {
                    if (!dirName.equals(language)) {
                        return;
                    }
                } else {
                    qs.profile.setLanguage(dirName);
                    qs.clearLanguage = true;
                }
            } else if (qs.state == STATE_COUNTRY) {
                String country = qs.locator.getCountry();
                if (null != country) {
                    if (!dirName.equals(country)) {
                        return;
                    }
                } else {
                    qs.profile.setCountry(dirName);
                    qs.clearCountry = true;
                }
            }
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            String[] files = file.list();
            for (int ix = 0; files != null && ix < files.length; ++ix) {
                this.subQuery(qs, path + files[ix]);
            }
            if (qs.state == STATE_NAME && qs.clearName) {
                if (QUERY_BY_USER == qs.queryBy) {
                    qs.profile.setUser(null);
                } else if (QUERY_BY_ROLE == qs.queryBy) {
                    qs.profile.setRole(null);
                } else if (QUERY_BY_GROUP == qs.queryBy) {
                    qs.profile.setGroup(null);
                }
                qs.clearName = false;
            } else if (qs.state == STATE_MEDIA && qs.clearMedia) {
                qs.profile.setMediaType(null);
                qs.clearMedia = false;
            } else if (qs.state == STATE_LANGUAGE && qs.clearLanguage) {
                qs.profile.setLanguage(null);
                qs.clearLanguage = false;
            } else if (qs.state == STATE_COUNTRY && qs.clearCountry) {
                qs.profile.setCountry(null);
                qs.clearCountry = false;
            }
            --qs.state;
        }
    }

    protected void testCases() {
        try {
            QueryLocator locator = new QueryLocator(1);
            Iterator x1 = this.query(locator);
            this.dump(x1);
            QueryLocator locator2 = new QueryLocator(1);
            locator2.setUser(JetspeedSecurity.getUser("turbine"));
            Iterator x2 = this.query(locator2);
            this.dump(x2);
            QueryLocator locator4 = new QueryLocator(4);
            Iterator x4 = this.query(locator4);
            this.dump(x4);
        }
        catch (Exception e) {
            System.out.println("Exception in Debug:" + e);
        }
    }

    protected void dump(Iterator it) {
        System.out.println("===============================================");
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            this.dumpProfile(profile);
        }
        System.out.println("===============================================");
    }

    protected void dumpProfile(Profile profile) {
        JetspeedUser user = profile.getUser();
        Group group = profile.getGroup();
        Role role = profile.getRole();
        if (profile.getAnonymous()) {
            System.out.println("ANON USER");
        }
        System.out.println("RESOURCE = " + profile.getName());
        if (null != user) {
            System.out.println("USER = " + user.getUserName());
        }
        if (null != group) {
            System.out.println("GROUP = " + group.getName());
        }
        if (null != role) {
            System.out.println("ROLE = " + role.getName());
        }
        System.out.println("MEDIA TYPE = " + profile.getMediaType());
        System.out.println("LANGUAGE = " + profile.getLanguage());
        System.out.println("COUNTRY = " + profile.getCountry());
        PSMLDocument doc = profile.getDocument();
        if (null == doc) {
            System.out.println("Document is null");
        } else if (null == profile.getName()) {
            System.out.println("profile name is null");
        } else {
            System.out.println("Doc.name=" + profile.getName());
        }
        System.out.println("----------------------");
    }

    public void refresh(FileCacheEntry entry) {
        if (logger.isInfoEnabled()) {
            logger.info("CastorPsmlManager: Entry is refreshing: " + entry.getFile().getPath());
        }
        Profile profile = (Profile)entry.getDocument();
        String path = null;
        if (profile != null) {
            try {
                path = entry.getFile().getCanonicalPath();
                profile.setDocument(this.loadDocument(path));
            }
            catch (IOException e) {
                logger.error("CastorPsmlManager: Failed to refresh document " + path);
            }
        }
    }

    public void evict(FileCacheEntry entry) {
        System.out.println("entry is evicting: " + entry.getFile().getName());
    }

    protected class QueryState {
        protected int queryBy;
        protected Profile profile;
        protected ProfileLocator locator;
        protected List list;
        protected String name;
        protected int state;
        protected boolean clearName = false;
        protected boolean clearMedia = false;
        protected boolean clearLanguage = false;
        protected boolean clearCountry = false;

        QueryState(int queryBy, Profile profile, ProfileLocator locator, List list, String name, int state) {
            this.queryBy = queryBy;
            this.profile = profile;
            this.locator = locator;
            this.list = list;
            this.name = name;
            this.state = state;
        }
    }
}

