/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.registry;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.services.Registry;

public class RegistryFragment
extends Hashtable
implements Serializable {
    private transient boolean dirty = false;
    private transient boolean changed = false;

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean value) {
        this.dirty = value;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean value) {
        this.changed = value;
    }

    public Vector getEntries(String name) {
        Vector registry;
        if (name != null && (registry = (Vector)this.get(name)) != null) {
            return registry;
        }
        return new Vector();
    }

    public void addEntry(String name, RegistryEntry entry) {
        Vector registry;
        if (name != null && entry != null && (registry = (Vector)this.get(name)) != null) {
            registry.add(entry);
        }
    }

    public void removeEntry(String name, String entryName) {
        Vector registry;
        if (name != null && entryName != null && (registry = (Vector)this.get(name)) != null) {
            Iterator i = registry.iterator();
            while (i.hasNext()) {
                RegistryEntry regEntry = (RegistryEntry)i.next();
                if (!entryName.equals(regEntry.getName())) continue;
                i.remove();
            }
        }
    }

    public void setEntry(String name, RegistryEntry entry) {
        if (entry != null) {
            this.removeEntry(name, entry.getName());
            this.addEntry(name, entry);
        }
    }

    public Vector getPortlets() {
        return (Vector)this.get(Registry.PORTLET);
    }

    public void setPortlets(Vector portlets) {
        if (portlets != null) {
            this.put(Registry.PORTLET, portlets);
        }
    }

    public Vector getControls() {
        return (Vector)this.get(Registry.PORTLET_CONTROL);
    }

    public void setControls(Vector controls) {
        if (controls != null) {
            this.put(Registry.PORTLET_CONTROL, controls);
        }
    }

    public Vector getControllers() {
        return (Vector)this.get(Registry.PORTLET_CONTROLLER);
    }

    public void setControllers(Vector controllers) {
        if (controllers != null) {
            this.put(Registry.PORTLET_CONTROLLER, controllers);
        }
    }

    public Vector getMedias() {
        return (Vector)this.get(Registry.MEDIA_TYPE);
    }

    public void setMedias(Vector medias) {
        if (medias != null) {
            this.put(Registry.MEDIA_TYPE, medias);
        }
    }

    public Vector getSkins() {
        return (Vector)this.get(Registry.SKIN);
    }

    public void setSkins(Vector skins) {
        if (skins != null) {
            this.put(Registry.SKIN, skins);
        }
    }

    public Vector getSecurityEntries() {
        return (Vector)this.get(Registry.SECURITY);
    }

    public void setSecurityEntries(Vector securityEntries) {
        if (securityEntries != null) {
            this.put(Registry.SECURITY, securityEntries);
        }
    }

    public Vector getClients() {
        return (Vector)this.get(Registry.CLIENT);
    }

    public void setClients(Vector clients) {
        if (clients != null) {
            this.put(Registry.CLIENT, clients);
        }
    }
}

