/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.search.handlers;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.jetspeed.om.registry.Category;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.search.ParsedObject;
import org.apache.jetspeed.services.search.handlers.RegistryEntryToDocHandler;

public class PortletEntryToDocHandler
extends RegistryEntryToDocHandler {
    private static final String PARENT = "parent";
    private static final String TYPE = "type";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PortletEntryToDocHandler.class.getName());

    public PortletEntryToDocHandler() {
        this.fields.add(PARENT);
        this.fields.add(TYPE);
    }

    public ParsedObject parseObject(Object o) {
        ParsedObject result = super.parseObject(o);
        if (!(o instanceof PortletEntry)) {
            logger.error("PortletEntryToDocHandler: invalid object type: " + o);
            return null;
        }
        PortletEntry portletEntry = (PortletEntry)o;
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(PARENT, portletEntry.getParent());
        fields.put(TYPE, portletEntry.getType());
        result.setFields(fields);
        StringBuffer content = new StringBuffer();
        String title = portletEntry.getTitle();
        content.append(title == null ? portletEntry.getName() : title);
        content.append(" ");
        content.append(portletEntry.getDescription());
        content.append(" ");
        Iterator it = portletEntry.listCategories();
        while (it.hasNext()) {
            Category cat = (Category)it.next();
            content.append(cat.getName());
            content.append(" ");
        }
        result.setContent(content.toString());
        result.setType("portlet");
        return result;
    }
}

