/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.search.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.search.BaseParsedObject;
import org.apache.jetspeed.services.search.HandlerFactory;
import org.apache.jetspeed.services.search.ObjectHandler;
import org.apache.jetspeed.services.search.ParsedObject;
import org.apache.jetspeed.services.search.SearchResults;
import org.apache.jetspeed.services.search.SearchService;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;

public class LuceneSearchService
extends TurbineBaseService
implements SearchService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(LuceneSearchService.class.getName());
    private static final int KEYWORD = 0;
    private static final int TEXT = 1;
    private static final String CONFIG_DIRECTORY = "directory";
    private File rootDir = null;
    private String indexRoot = null;

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        this.initConfiguration(conf);
        this.setInit(true);
    }

    public void init() throws InitializationException {
        logger.info("Late init for Search called");
        while (!this.getInit()) {
            try {
                Thread.sleep(100L);
                logger.info("Waiting for init of Search...");
            }
            catch (InterruptedException ie) {
                logger.error("Exception", ie);
            }
        }
    }

    public void shutdown() {
    }

    private void initConfiguration(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("Search");
        this.indexRoot = serviceConf.getString(CONFIG_DIRECTORY);
        this.rootDir = new File(this.indexRoot);
        if (!this.rootDir.exists() && this.indexRoot != null) {
            String rootDirPath = TurbineServlet.getRealPath((String)"") + this.indexRoot;
            this.rootDir = new File(rootDirPath);
            if (!this.rootDir.exists()) {
                this.rootDir.mkdir();
                logger.info("Created index directory '" + this.rootDir.getPath() + "'");
            }
        }
        try {
            IndexSearcher searcher = null;
            searcher = new IndexSearcher(this.rootDir.getPath());
            searcher.close();
        }
        catch (Exception e) {
            try {
                IndexWriter indexWriter = new IndexWriter(this.rootDir, (Analyzer)new StandardAnalyzer(), true);
                indexWriter.close();
                indexWriter = null;
                logger.info("Created Lucene Index in " + this.rootDir.getPath());
            }
            catch (Exception e1) {
                logger.error(this.getClass().getName() + ".initConfiguration - Getting or creating IndexSearcher", e);
                throw new InitializationException("Getting or creating Index Searcher");
            }
        }
        this.setInit(true);
    }

    public SearchResults search(String searchString) {
        IndexSearcher searcher = null;
        Hits hits = null;
        try {
            searcher = new IndexSearcher(this.rootDir.getPath());
        }
        catch (IOException e) {
            logger.error("Failed to create index search using path " + this.rootDir.getPath());
            return null;
        }
        StandardAnalyzer analyzer = new StandardAnalyzer();
        String[] searchFields = new String[]{"fieldname.content", "fieldname.description", "fieldname.fields", "fieldname.key", "fieldname.keywords", "fieldname.language", "fieldname.score", "fieldname.title", "fieldname.type", "fieldname.url", "fieldname.className"};
        Query query = null;
        try {
            query = MultiFieldQueryParser.parse((String)searchString, (String[])searchFields, (Analyzer)analyzer);
        }
        catch (ParseException e) {
            logger.info("Failed to parse query " + searchString);
            return null;
        }
        try {
            hits = searcher.search(query);
        }
        catch (IOException e) {
            logger.error("Error while peforming search.", e);
            return null;
        }
        int hitCount = hits.length();
        Document doc = null;
        SearchResults results = new SearchResults(hitCount);
        for (int counter = 0; counter < hitCount; ++counter) {
            BaseParsedObject result = new BaseParsedObject();
            try {
                Field url;
                Field classname;
                doc = hits.doc(counter);
                this.addFieldsToParsedObject(doc, result);
                result.setScore(hits.score(counter));
                result.setType(doc.getField("fieldname.type").stringValue());
                result.setKey(doc.getField("fieldname.key").stringValue());
                result.setDescription(doc.getField("fieldname.description").stringValue());
                result.setTitle(doc.getField("fieldname.title").stringValue());
                result.setContent(doc.getField("fieldname.className").stringValue());
                Field language = doc.getField("fieldname.language");
                if (language != null) {
                    result.setLanguage(language.stringValue());
                }
                if ((classname = doc.getField("fieldname.className")) != null) {
                    result.setClassName(classname.stringValue());
                }
                if ((url = doc.getField("fieldname.url")) != null) {
                    result.setURL(new URL(url.stringValue()));
                }
                results.add(counter, result);
                continue;
            }
            catch (Exception ioe) {
                logger.error("Exception", ioe);
            }
        }
        if (searcher != null) {
            try {
                searcher.close();
            }
            catch (IOException ioe) {
                logger.error("Closing Searcher", ioe);
            }
        }
        return results;
    }

    private void addFieldsToParsedObject(Document doc, ParsedObject o) {
        try {
            MultiHashMap multiKeywords = new MultiHashMap();
            MultiHashMap multiFields = new MultiHashMap();
            HashMap fieldMap = new HashMap();
            Field classNameField = doc.getField("fieldname.className");
            if (classNameField != null) {
                String className = classNameField.stringValue();
                o.setClassName(className);
                ObjectHandler handler = HandlerFactory.getHandler(className);
                Set fields = handler.getFields();
                this.addFieldsToMap(doc, fields, (Map)multiFields);
                this.addFieldsToMap(doc, fields, fieldMap);
                Set keywords = handler.getKeywords();
                this.addFieldsToMap(doc, keywords, (Map)multiKeywords);
            }
            o.setMultiKeywords((MultiMap)multiKeywords);
            o.setMultiFields((MultiMap)multiFields);
            o.setFields(fieldMap);
        }
        catch (Exception e) {
            logger.error("Error trying to add fields to parsed object.", e);
        }
    }

    private void addFieldsToMap(Document doc, Set fieldNames, Map fields) {
        for (String fieldName : fieldNames) {
            Field[] docFields = doc.getFields(fieldName);
            if (fields == null) continue;
            for (int i = 0; i < docFields.length; ++i) {
                Field field = docFields[i];
                if (field == null) continue;
                String value = field.stringValue();
                fields.put(fieldName, value);
            }
        }
    }

    public String[] getSearchSets() {
        return null;
    }

    public boolean add(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Collection c) {
        IndexWriter indexWriter;
        boolean result = false;
        try {
            indexWriter = new IndexWriter(this.rootDir, (Analyzer)new StandardAnalyzer(), false);
        }
        catch (IOException e) {
            logger.error("Error while creating index writer. Skipping add...", e);
            return result;
        }
        for (Object o : c) {
            ObjectHandler handler = null;
            try {
                handler = HandlerFactory.getHandler(o);
            }
            catch (Exception e) {
                logger.error("Failed to create hanlder for object " + o.getClass().getName());
                continue;
            }
            ParsedObject parsedObject = handler.parseObject(o);
            Document doc = new Document();
            if (parsedObject.getKey() != null) {
                doc.add(Field.Keyword((String)"fieldname.key", (String)parsedObject.getKey()));
            }
            if (parsedObject.getType() != null) {
                doc.add(Field.Text((String)"fieldname.type", (String)parsedObject.getType()));
            }
            if (parsedObject.getTitle() != null) {
                doc.add(Field.Text((String)"fieldname.title", (String)parsedObject.getTitle()));
            }
            if (parsedObject.getDescription() != null) {
                doc.add(Field.Text((String)"fieldname.description", (String)parsedObject.getDescription()));
            }
            if (parsedObject.getContent() != null) {
                doc.add(Field.Text((String)"fieldname.content", (String)parsedObject.getContent()));
            }
            if (parsedObject.getLanguage() != null) {
                doc.add(Field.Text((String)"fieldname.language", (String)parsedObject.getLanguage()));
            }
            if (parsedObject.getURL() != null) {
                doc.add(Field.Text((String)"fieldname.url", (String)parsedObject.getURL().toString()));
            }
            if (parsedObject.getClassName() != null) {
                doc.add(Field.Text((String)"fieldname.className", (String)parsedObject.getClassName()));
            }
            MultiMap multiKeywords = parsedObject.getMultiKeywords();
            this.addFieldsToDocument(doc, (Map)multiKeywords, 0);
            MultiMap multiFields = parsedObject.getMultiFields();
            this.addFieldsToDocument(doc, (Map)multiFields, 1);
            Map fields = parsedObject.getFields();
            this.addFieldsToDocument(doc, fields, 1);
            try {
                indexWriter.addDocument(doc);
            }
            catch (IOException e) {
                logger.error("Error adding document to index.", e);
            }
            logger.debug("Index Document Count = " + indexWriter.docCount());
            logger.info("Added '" + parsedObject.getTitle() + "' to index");
            result = true;
        }
        try {
            indexWriter.optimize();
        }
        catch (IOException e) {
            logger.error("Error while trying to optimize index.");
        }
        finally {
            try {
                indexWriter.close();
            }
            catch (IOException e) {
                logger.error("Error while closing index writer.", e);
            }
        }
        return result;
    }

    private void addFieldsToDocument(Document doc, Map fields, int type) {
        if (fields != null) {
            for (Object key : fields.keySet()) {
                Object values;
                if (key == null || (values = fields.get(key)) == null) continue;
                if (values instanceof Collection) {
                    for (Object value : (Collection)values) {
                        if (value == null) continue;
                        if (type == 1) {
                            doc.add(Field.Text((String)key.toString(), (String)value.toString()));
                            continue;
                        }
                        doc.add(Field.Keyword((String)key.toString(), (String)value.toString()));
                    }
                    continue;
                }
                if (type == 1) {
                    doc.add(Field.Text((String)key.toString(), (String)values.toString()));
                    continue;
                }
                doc.add(Field.Keyword((String)key.toString(), (String)values.toString()));
            }
        }
    }

    public boolean remove(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.remove(c);
    }

    public boolean remove(Collection c) {
        boolean result = false;
        try {
            IndexReader indexReader = IndexReader.open((File)this.rootDir);
            for (Object o : c) {
                ObjectHandler handler = HandlerFactory.getHandler(o);
                ParsedObject parsedObject = handler.parseObject(o);
                Term term = null;
                if (parsedObject.getKey() == null) continue;
                term = new Term("fieldname.key", parsedObject.getKey());
                int rc = indexReader.delete(term);
                logger.info("Attempted to delete '" + term.toString() + "' from index, documents deleted = " + rc);
                result = rc > 0;
            }
            indexReader.close();
            IndexWriter indexWriter = new IndexWriter(this.rootDir, (Analyzer)new StandardAnalyzer(), false);
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            result = false;
        }
        return result;
    }

    public boolean update(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.update(c);
    }

    public boolean update(Collection c) {
        boolean result = false;
        try {
            this.remove(c);
            result = true;
        }
        catch (Throwable e) {
            logger.error("Exception", e);
        }
        try {
            this.add(c);
            result = true;
        }
        catch (Throwable e) {
            logger.error("Exception", e);
        }
        return false;
    }
}

