/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.turbine;

import java.util.Iterator;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.Security;
import org.apache.jetspeed.om.security.GroupRole;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.PortalAccessController;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;

public class TurbineAccessController
extends TurbineBaseService
implements PortalAccessController {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(TurbineAccessController.class.getName());
    private static final String CONFIG_DEFAULT_PERMISSION_LOGGEDIN = "services.JetspeedSecurity.permission.default.loggedin";
    private static final String CONFIG_DEFAULT_PERMISSION_ANONYMOUS = "services.JetspeedSecurity.permission.default.anonymous";

    public boolean checkPermission(JetspeedUser user, Portlet portlet, String action) {
        return this.checkPermission(user, portlet, action, null);
    }

    public boolean checkPermission(JetspeedUser user, Portlet portlet, String action, String owner) {
        PortletController pc;
        PortletSet ps;
        String portletName = portlet.getName();
        RegistryEntry regEntry = Registry.getEntry(Registry.PORTLET, portletName);
        if (regEntry == null && (ps = portlet.getPortletConfig().getPortletSet()) != null && (pc = ps.getController()) != null) {
            portletName = pc.getConfig().getName();
            regEntry = Registry.getEntry(Registry.PORTLET_CONTROLLER, portletName);
        }
        if (regEntry == null) {
            return this.checkDefaultPermission(user, action);
        }
        return this.checkPermission(user, regEntry, action);
    }

    public boolean checkPermission(JetspeedUser user, Entry entry, String action) {
        return this.checkPermission(user, entry, action, null);
    }

    public boolean checkPermission(JetspeedUser user, Entry entry, String action, String owner) {
        String portletName = entry.getParent();
        RegistryEntry regEntry = Registry.getEntry(Registry.PORTLET, portletName);
        if (regEntry == null) {
            return this.checkDefaultPermission(user, action);
        }
        return this.checkPermission(user, regEntry, action);
    }

    public boolean checkPermission(JetspeedUser user, PortalResource resource, String action) {
        switch (resource.getResourceType()) {
            case 200: {
                return this.checkPermission(user, resource.getEntry(), action);
            }
            case 300: {
                return this.checkPermission(user, resource.getRegistryEntry(), action);
            }
            case 301: {
                return this.checkPermission(user, resource.getRegistryParameter(), action);
            }
            case 100: {
                return this.checkPermission(user, resource.getPortlet(), action);
            }
            case 201: {
                return this.checkPermission(user, (RegistryEntry)((Object)resource.getEntryParameter()), action);
            }
        }
        return false;
    }

    private boolean checkPermission(JetspeedUser user, RegistryEntry regEntry, String action) {
        Security security = regEntry.getSecurity();
        if (null == security) {
            return this.checkDefaultPermission(user, action);
        }
        String securityRole = security.getRole();
        if (null == securityRole) {
            return this.checkDefaultPermission(user, action);
        }
        try {
            if (!JetspeedSecurity.hasRole(user.getUserName(), securityRole)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return false;
        }
        return this.checkPermission(user, action);
    }

    private boolean checkPermission(JetspeedUser user, String action) {
        if (action == null) {
            return true;
        }
        try {
            Iterator roles = JetspeedSecurity.getRoles(user.getUserName());
            if (roles.hasNext()) {
                GroupRole gr = (GroupRole)roles.next();
                Role role = gr.getRole();
                return JetspeedSecurity.hasPermission(role.getName(), action);
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return false;
        }
        return true;
    }

    private boolean checkDefaultPermission(JetspeedUser user, String action) {
        String[] defaultPermissions = null;
        try {
            defaultPermissions = user == null || !user.hasLoggedIn() ? JetspeedResources.getStringArray((String)CONFIG_DEFAULT_PERMISSION_ANONYMOUS) : JetspeedResources.getStringArray((String)CONFIG_DEFAULT_PERMISSION_LOGGEDIN);
        }
        catch (Exception e) {
            logger.error("Error checking permissions for " + user + " on " + action, e);
        }
        for (int i = 0; i < defaultPermissions.length; ++i) {
            if (defaultPermissions[i].equals("*")) {
                return true;
            }
            if (!defaultPermissions[i].equals(action)) continue;
            return true;
        }
        return false;
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        this.setInit(true);
    }
}

