/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security.turbine;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.security.BaseJetspeedUser;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.om.security.turbine.TurbineUser;
import org.apache.jetspeed.om.security.turbine.TurbineUserPeer;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.CredentialsManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.NotUniqueUserException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.services.security.UserException;
import org.apache.jetspeed.services.security.UserManagement;
import org.apache.torque.om.NumberKey;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.util.RunData;

public class TurbineUserManagement
extends TurbineBaseService
implements UserManagement,
CredentialsManagement {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(TurbineUserManagement.class.getName());
    private static final String CONFIG_SECURE_PASSWORDS_KEY = "secure.passwords";
    private static final String CONFIG_SECURE_PASSWORDS_ALGORITHM = "secure.passwords.algorithm";
    private static final String CONFIG_SYSTEM_USERS = "system.users";
    boolean securePasswords = false;
    String passwordsAlgorithm = "SHA";
    Vector systemUsers = null;
    private static final String CONFIG_NEWUSER_ROLES = "newuser.roles";
    private static final String[] DEFAULT_CONFIG_NEWUSER_ROLES = new String[]{"user"};
    String[] roles = null;
    private JetspeedRunDataService runDataService = null;

    public JetspeedUser getUser(Principal principal) throws JetspeedSecurityException {
        List users;
        Criteria criteria = new Criteria();
        if (principal instanceof UserNamePrincipal) {
            criteria.add(TurbineUserPeer.LOGIN_NAME, (Object)principal.getName());
        } else if (principal instanceof UserIdPrincipal) {
            criteria.add(TurbineUserPeer.USER_ID, (Object)principal.getName());
        } else {
            throw new UserException("Invalid Principal Type in getUser: " + principal.getClass().getName());
        }
        try {
            users = TurbineUserPeer.doSelectUsers(criteria);
        }
        catch (Exception e) {
            String message = "Failed to retrieve user '" + principal.getName() + "'";
            logger.error(message, e);
            throw new UserException(message, e);
        }
        if (users.size() > 1) {
            throw new UserException("Multiple Users with same username '" + principal.getName() + "'");
        }
        if (users.size() == 1) {
            return (JetspeedUser)users.get(0);
        }
        throw new UnknownUserException("Unknown user '" + principal.getName() + "'");
    }

    public JetspeedUser getUser(RunData rundata, Principal principal) throws JetspeedSecurityException {
        return this.getUser(principal);
    }

    public Iterator getUsers() throws JetspeedSecurityException {
        List users;
        Criteria criteria = new Criteria();
        try {
            users = TurbineUserPeer.doSelectUsers(criteria);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve users ", e);
            throw new UserException("Failed to retrieve users ", e);
        }
        return users.iterator();
    }

    public Iterator getUsers(String filter) throws JetspeedSecurityException {
        List users;
        Criteria criteria = new Criteria();
        try {
            users = TurbineUserPeer.doSelectUsers(criteria);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve users ", e);
            throw new UserException("Failed to retrieve users ", e);
        }
        return users.iterator();
    }

    public void saveUser(JetspeedUser user) throws JetspeedSecurityException {
        if (!this.accountExists(user, true)) {
            throw new UnknownUserException("Cannot save user '" + user.getUserName() + "', User doesn't exist");
        }
        Criteria criteria = TurbineUserPeer.buildCriteria(user);
        try {
            TurbineUserPeer.doUpdate(criteria);
        }
        catch (Exception e) {
            logger.error("Failed to save user object ", e);
            throw new UserException("Failed to save user object ", e);
        }
    }

    public void addUser(JetspeedUser user) throws JetspeedSecurityException {
        if (this.accountExists(user)) {
            throw new NotUniqueUserException("The account '" + user.getUserName() + "' already exists");
        }
        String initialPassword = user.getPassword();
        String encrypted = JetspeedSecurity.encryptPassword(initialPassword);
        user.setPassword(encrypted);
        Criteria criteria = TurbineUserPeer.buildCriteria(user);
        try {
            NumberKey key = (NumberKey)TurbineUserPeer.doInsert(criteria);
            ((BaseJetspeedUser)user).setUserId(key.toString());
        }
        catch (Exception e) {
            String message = "Failed to create account '" + user.getUserName() + "'";
            logger.error(message, e);
            throw new UserException(message, e);
        }
        this.addDefaultPSML(user);
    }

    protected void addDefaultPSML(JetspeedUser user) throws JetspeedSecurityException {
        for (int ix = 0; ix < this.roles.length; ++ix) {
            try {
                JetspeedSecurity.grantRole(user.getUserName(), JetspeedSecurity.getRole(this.roles[ix]).getName());
                continue;
            }
            catch (Exception e) {
                logger.error("Could not grant role: " + this.roles[ix] + " to user " + user.getUserName(), e);
            }
        }
        try {
            JetspeedRunData rundata = this.getRunData();
            if (rundata != null && !Profiler.useRoleProfileMerging()) {
                Profile profile = Profiler.createProfile();
                profile.setUser(user);
                profile.setMediaType("html");
                Profiler.createProfile((RunData)this.getRunData(), profile);
            }
        }
        catch (Exception e) {
            logger.error("Failed to create profile for new user ", e);
            this.removeUser(new UserNamePrincipal(user.getUserName()));
            throw new UserException("Failed to create profile for new user ", e);
        }
    }

    public void removeUser(Principal principal) throws JetspeedSecurityException {
        if (this.systemUsers.contains(principal.getName())) {
            throw new UserException("[" + principal.getName() + "] is a system user and cannot be removed");
        }
        JetspeedUser user = this.getUser(principal);
        Criteria criteria = new Criteria();
        if (principal instanceof UserNamePrincipal) {
            criteria.add(TurbineUserPeer.LOGIN_NAME, (Object)principal.getName());
        } else if (principal instanceof UserIdPrincipal) {
            criteria.add(TurbineUserPeer.USER_ID, (Object)principal.getName());
        } else {
            throw new UserException("Invalid Principal Type in removeUser: " + principal.getClass().getName());
        }
        try {
            TurbineUserPeer.doDelete(criteria);
            PsmlManager.removeUserDocuments(user);
        }
        catch (Exception e) {
            String message = "Failed to remove account '" + user.getUserName() + "'";
            logger.error(message, e);
            throw new UserException(message, e);
        }
    }

    public void changePassword(JetspeedUser user, String oldPassword, String newPassword) throws JetspeedSecurityException {
        oldPassword = JetspeedSecurity.convertPassword(oldPassword);
        newPassword = JetspeedSecurity.convertPassword(newPassword);
        String encrypted = JetspeedSecurity.encryptPassword(oldPassword);
        if (!this.accountExists(user)) {
            throw new UnknownUserException(Localization.getString((String)"UPDATEACCOUNT_NOUSER"));
        }
        if (!user.getPassword().equals(encrypted)) {
            throw new UserException(Localization.getString((String)"UPDATEACCOUNT_BADOLDPASSWORD"));
        }
        user.setPassword(JetspeedSecurity.encryptPassword(newPassword));
        user.setPasswordChanged(new Date());
        this.saveUser(user);
    }

    public void forcePassword(JetspeedUser user, String password) throws JetspeedSecurityException {
        if (!this.accountExists(user)) {
            throw new UnknownUserException("The account '" + user.getUserName() + "' does not exist");
        }
        user.setPassword(JetspeedSecurity.encryptPassword(password));
        this.saveUser(user);
    }

    public String encryptPassword(String password) throws JetspeedSecurityException {
        if (!this.securePasswords) {
            return password;
        }
        if (password == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.passwordsAlgorithm);
            byte[] digest = md.digest(password.getBytes("UTF-8"));
            ByteArrayOutputStream bas = new ByteArrayOutputStream(digest.length + digest.length / 3 + 1);
            OutputStream encodedStream = MimeUtility.encode((OutputStream)bas, (String)"base64");
            encodedStream.write(digest);
            encodedStream.flush();
            encodedStream.close();
            return bas.toString();
        }
        catch (Exception e) {
            logger.error("Unable to encrypt password." + e.getMessage(), e);
            return null;
        }
    }

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        super.init(conf);
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("JetspeedSecurity");
        this.securePasswords = serviceConf.getBoolean(CONFIG_SECURE_PASSWORDS_KEY, this.securePasswords);
        this.passwordsAlgorithm = serviceConf.getString(CONFIG_SECURE_PASSWORDS_ALGORITHM, this.passwordsAlgorithm);
        this.systemUsers = serviceConf.getVector(CONFIG_SYSTEM_USERS, new Vector());
        try {
            this.roles = serviceConf.getStringArray(CONFIG_NEWUSER_ROLES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == this.roles || this.roles.length == 0) {
            this.roles = DEFAULT_CONFIG_NEWUSER_ROLES;
        }
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.setInit(true);
    }

    protected boolean accountExists(JetspeedUser user) throws UserException {
        return this.accountExists(user, false);
    }

    protected boolean accountExists(JetspeedUser user, boolean checkUniqueId) throws UserException {
        List users;
        String id = user.getUserId();
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.LOGIN_NAME, (Object)user.getUserName());
        try {
            users = TurbineUserPeer.doSelect(criteria);
        }
        catch (Exception e) {
            logger.error("Failed to check account's presence", e);
            throw new UserException("Failed to check account's presence", e);
        }
        if (users.size() < 1) {
            return false;
        }
        TurbineUser retrieved = (TurbineUser)((Object)users.get(0));
        int key = retrieved.getUserId();
        String keyId = String.valueOf(key);
        if (checkUniqueId && !keyId.equals(id)) {
            throw new UserException("User exists but under a different unique ID");
        }
        return true;
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }
}

