/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.template;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.template.TemplateLocatorService;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.RunData;

public class JetspeedTemplateLocatorService
extends TurbineBaseService
implements TemplateLocatorService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedTemplateLocatorService.class.getName());
    private static final String CONFIG_TEMPLATE_ROOT = ".templateRoot";
    private static final String CONFIG_PORTLET_GLOBAL_SEARCH = ".portlet.global.search";
    private static final String CONFIG_HOT_DEPLOY = ".hot.deploy";
    private static final String DIR_SCREENS = "/screens";
    private static final String DIR_LAYOUTS = "/layouts";
    private static final String DIR_PORTLETS = "/portlets";
    private static final String DIR_CONTROLS = "/controls";
    private static final String DIR_CONTROLLERS = "/controllers";
    private static final String DIR_NAVIGATIONS = "/navigations";
    private static final String DIR_PARAMETERS = "/parameters";
    private static final String DIR_EMAILS = "/emails";
    private static final String PATH_SEPARATOR = "/";
    private static final String MSG_MISSING_PARAMETER = "JetspeedTemplateLocatorService initialization failed. Missing parameter:";
    private static final String TEMPLATE_EXTENSION = "template.extension";
    private static final String DEFAULT_LAYOUT = "default.layout.template";
    private static VelocityService velocityService;
    private static JspService jspService;
    private String[] templateRoots;
    private boolean hotDeploy = false;
    private Map templateMap = null;
    private boolean useGlobalPortletSearch = false;

    public synchronized void init(ServletConfig conf) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        this.initConfiguration();
        this.setInit(true);
    }

    public void init() throws InitializationException {
        logger.info("Late init for JetspeedTemplateLocatorService called");
        while (!this.getInit()) {
            try {
                Thread.sleep(100L);
                logger.info("Waiting for init of JetspeedTemplateLocatorService...");
            }
            catch (InterruptedException ie) {
                logger.error("Exception", ie);
            }
        }
    }

    public void shutdown() {
    }

    public String locateScreenTemplate(RunData data, String template) {
        String path;
        List templatePaths = this.localizeTemplateName(data);
        Iterator i = templatePaths.iterator();
        String located = null;
        while (i.hasNext()) {
            path = (String)i.next();
            located = this.locateTemplate(data, DIR_SCREENS, path, template);
            if (null == located) continue;
            return located;
        }
        if (null == located) {
            i = templatePaths.iterator();
            template = "/default." + this.getTemplateExtension(template);
            while (i.hasNext()) {
                path = (String)i.next();
                located = this.locateTemplate(data, DIR_SCREENS, path, template);
                if (null == located) continue;
                return located;
            }
        }
        return located;
    }

    public String locateLayoutTemplate(RunData data, String template) {
        String path;
        List templatePaths = this.localizeTemplateName(data);
        Iterator i = templatePaths.iterator();
        String located = null;
        while (i.hasNext()) {
            path = (String)i.next();
            located = this.locateTemplate(data, DIR_LAYOUTS, path, template);
            if (null == located) continue;
            return located;
        }
        if (null == located) {
            i = templatePaths.iterator();
            template = this.getTemplateLayout(this.getTemplateExtension(template));
            while (i.hasNext()) {
                path = (String)i.next();
                located = this.locateTemplate(data, DIR_LAYOUTS, path, template);
                if (null == located) continue;
                return located;
            }
        }
        return located;
    }

    public String locateNavigationTemplate(RunData data, String template) {
        List templatePaths = this.localizeTemplateName(data);
        for (String path : templatePaths) {
            String located = this.locateTemplate(data, DIR_NAVIGATIONS, path, template);
            if (null == located) continue;
            return located;
        }
        return null;
    }

    public String locatePortletTemplate(RunData data, String template) {
        String located;
        List templatePaths = this.localizeTemplateName(data);
        for (String path : templatePaths) {
            String located2 = this.locateTemplate(data, DIR_PORTLETS, path, template);
            if (null == located2) continue;
            return DIR_PORTLETS + located2;
        }
        if (this.useGlobalPortletSearch && (located = this.locateScreenTemplate(data, template)) != null) {
            return DIR_SCREENS + located;
        }
        return null;
    }

    public String locateControlTemplate(RunData data, String template) {
        List templatePaths = this.localizeTemplateName(data);
        for (String path : templatePaths) {
            String located = this.locateTemplate(data, DIR_CONTROLS, path, template);
            if (null == located) continue;
            return DIR_CONTROLS + located;
        }
        return null;
    }

    public String locateControllerTemplate(RunData data, String template) {
        List templatePaths = this.localizeTemplateName(data);
        for (String path : templatePaths) {
            String located = this.locateTemplate(data, DIR_CONTROLLERS, path, template);
            if (null == located) continue;
            return DIR_CONTROLLERS + located;
        }
        return null;
    }

    public String locateEmailTemplate(RunData data, String template) {
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName("LocalizationService");
        return this.locateEmailTemplate(data, template, locService.getLocale(data));
    }

    public String locateEmailTemplate(RunData data, String template, Locale locale) {
        List templatePaths = this.localizeTemplateName(data, locale);
        for (String path : templatePaths) {
            String located = this.locateTemplate(data, DIR_EMAILS, path, template);
            if (null == located) continue;
            return DIR_EMAILS + located;
        }
        return null;
    }

    public String locateParameterTemplate(RunData data, String template) {
        List templatePaths = this.localizeTemplateName(data);
        for (String path : templatePaths) {
            String located = this.locateTemplate(data, DIR_PARAMETERS, path, template);
            if (null == located) continue;
            return DIR_PARAMETERS + located;
        }
        return null;
    }

    private String locateTemplate(RunData data, String resourceType, String path, String template) {
        String located = null;
        for (int i = 0; i < this.templateRoots.length && (located = this.locateTemplate(data, resourceType, path, template, this.templateRoots[i])) == null; ++i) {
        }
        return located;
    }

    private String locateTemplate(RunData data, String resourceType, String path, String template, String templateRoot) {
        int pt;
        if (resourceType.endsWith(PATH_SEPARATOR)) {
            resourceType = resourceType.substring(0, resourceType.length() - 1);
        }
        if (!resourceType.startsWith(PATH_SEPARATOR)) {
            resourceType = PATH_SEPARATOR + resourceType;
        }
        if (path.endsWith(PATH_SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.startsWith(PATH_SEPARATOR)) {
            path = PATH_SEPARATOR + path;
        }
        if (!template.startsWith(PATH_SEPARATOR)) {
            template = PATH_SEPARATOR + template;
        }
        StringBuffer fullPath = new StringBuffer(templateRoot);
        if (!templateRoot.endsWith(PATH_SEPARATOR)) {
            fullPath.append(PATH_SEPARATOR);
        }
        fullPath.append(this.getTemplateExtension(template));
        fullPath.append(resourceType);
        String basePath = fullPath.toString();
        String realPath = null;
        String workingPath = null;
        do {
            workingPath = path + template;
            realPath = TurbineServlet.getRealPath((String)(basePath + workingPath));
            if (this.templateExists(realPath, true)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TemplateLocator: template exists in cache: " + realPath + " returning " + workingPath);
                }
                return workingPath;
            }
            if (!this.hotDeploy || !this.templateExists(realPath, false)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("TemplateLocator: template exists on the file system: " + realPath + " returning " + workingPath);
            }
            this.templateMap.put(realPath, null);
            return workingPath;
        } while ((path = (pt = path.lastIndexOf(PATH_SEPARATOR)) > -1 ? path.substring(0, pt) : null) != null);
        return null;
    }

    private List localizeTemplateName(RunData data) {
        return this.localizeTemplateName(data, null);
    }

    private List localizeTemplateName(RunData data, Locale inLocale) {
        ArrayList<String> templates = new ArrayList<String>();
        Locale tmplocale = null;
        if (inLocale != null) {
            tmplocale = inLocale;
        } else {
            CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName("LocalizationService");
            tmplocale = locService.getLocale(data);
        }
        if (tmplocale == null) {
            tmplocale = new Locale(TurbineResources.getString((String)"locale.default.language", (String)"en"), TurbineResources.getString((String)"locale.default.country", (String)"US"));
        }
        if (data.getUser() != null) {
            data.getUser().setTemp("locale", (Object)tmplocale);
        }
        StringBuffer templatePath = new StringBuffer();
        String type2 = data.getParameters().getString("media-type", null);
        ArrayList<String> types = new ArrayList<String>();
        CapabilityMap cm = ((JetspeedRunData)data).getCapability();
        Locale locale = data.getUser() != null ? (Locale)data.getUser().getTemp("locale") : tmplocale;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (null != type2) {
            types.add(type2);
        } else {
            Iterator i = cm.listMediaTypes();
            while (i.hasNext()) {
                types.add((String)i.next());
            }
        }
        for (String type2 : types) {
            if (type2 != null && type2.length() > 0) {
                templatePath.append(PATH_SEPARATOR).append(type2);
            }
            if (language != null && language.length() > 0) {
                templatePath.append(PATH_SEPARATOR).append(language);
            }
            if (country != null && country.length() > 0) {
                templatePath.append(PATH_SEPARATOR).append(country);
            }
            templates.add(templatePath.toString());
            templatePath.setLength(0);
        }
        return templates;
    }

    private String getTemplateExtension(String template) {
        String ext = TurbineTemplate.getDefaultExtension();
        int idx = template.lastIndexOf(".");
        if (idx > 0) {
            ext = template.substring(idx + 1);
        }
        return ext;
    }

    public boolean templateExists(String templateKey, boolean useNameCache) {
        if (null == templateKey) {
            return false;
        }
        if (useNameCache) {
            return this.templateMap.containsKey(templateKey);
        }
        return new File(templateKey).exists();
    }

    private void initConfiguration() throws InitializationException {
        this.templateRoots = JetspeedResources.getStringArray((String)"services.TemplateLocator.templateRoot");
        if (this.templateRoots == null || this.templateRoots.length == 0) {
            throw new InitializationException("JetspeedTemplateLocatorService initialization failed. Missing parameter:.templateRoot");
        }
        this.templateMap = new HashMap();
        for (int i = 0; i < this.templateRoots.length; ++i) {
            String templateRootPath;
            String templateRoot = this.templateRoots[i];
            if (!templateRoot.endsWith(PATH_SEPARATOR)) {
                templateRoot = templateRoot + PATH_SEPARATOR;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("TemplateLocator: Adding templateRoot:" + templateRoot);
            }
            if (null == (templateRootPath = TurbineServlet.getRealPath((String)templateRoot))) continue;
            this.loadNameCache(templateRootPath, "");
        }
        velocityService = (VelocityService)TurbineServices.getInstance().getService("VelocityService");
        jspService = (JspService)TurbineServices.getInstance().getService("JspService");
        this.useGlobalPortletSearch = JetspeedResources.getBoolean("services.TemplateLocator.portlet.global.search", false);
        this.hotDeploy = JetspeedResources.getBoolean("services.TemplateLocator.hot.deploy", true);
    }

    private void loadNameCache(String path, String name) {
        File file = new File(path);
        if (file.isFile()) {
            this.templateMap.put(path, null);
        } else if (file.isDirectory()) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            String[] list = file.list();
            for (int ix = 0; list != null && ix < list.length; ++ix) {
                this.loadNameCache(path + list[ix], list[ix]);
            }
        }
    }

    private String getTemplateLayout(String extension) {
        String dftLayout = "/default." + extension;
        Configuration velocityCfg = null;
        Configuration jspCfg = null;
        if (velocityService != null) {
            velocityCfg = velocityService.getConfiguration();
        }
        if (jspService != null) {
            jspCfg = jspService.getConfiguration();
        }
        if (velocityCfg != null && velocityCfg.getString(TEMPLATE_EXTENSION).indexOf(extension) > -1) {
            return velocityCfg.getString(DEFAULT_LAYOUT, dftLayout);
        }
        if (jspCfg != null && jspCfg.getString(TEMPLATE_EXTENSION).indexOf(extension) > -1) {
            return jspCfg.getString(DEFAULT_LAYOUT, dftLayout);
        }
        return dftLayout;
    }
}

