/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.urlmanager;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jetspeed.cache.disk.DiskCacheEntry;
import org.apache.jetspeed.cache.disk.DiskCacheUtils;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.urlmanager.ContentNotAvailableException;
import org.apache.jetspeed.services.urlmanager.URLManager;
import org.apache.jetspeed.services.urlmanager.URLNotAvailableException;

public class URLFetcher {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(URLFetcher.class.getName());
    private static Hashtable realtime_urls = new Hashtable();
    static final boolean shouldFetchNow = JetspeedResources.getBoolean("cache.require.cached");

    public static final Reader fetch(String url) throws IOException {
        return URLFetcher.fetch(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Reader fetch(String url, boolean force) throws IOException {
        if (!URLManager.isOK(url)) {
            throw new URLNotAvailableException(url);
        }
        if (!force && DiskCacheUtils.isCached(url)) {
            logger.info("The url " + url + " is fetched from the Cache");
            return JetspeedDiskCache.getInstance().getEntry(url).getReader();
        }
        if (shouldFetchNow && !DiskCacheUtils.isCached(url) && !URLFetcher.isRealtimeURL(url) && !force) {
            logger.info("The url " + url + " is not in the cache and will be fetched now because you have configured -> " + "cache.require.cached");
            JetspeedDiskCache.getInstance().refresh(url);
            throw new ContentNotAvailableException(url);
        }
        if (URLFetcher.isRealtimeURL(url)) {
            URLFetcher.addRealtimeURL(url);
            String string = url.intern();
            synchronized (string) {
                try {
                    url.intern().wait();
                }
                catch (InterruptedException e) {
                    logger.info("Wait Interrupted");
                }
                finally {
                    URLFetcher.removeRealtimeURL(url);
                }
            }
            return URLFetcher.fetch(url, force);
        }
        URLFetcher.addRealtimeURL(url);
        try {
            String protocol = url.substring(0, url.indexOf(":/"));
            String proxyHost = URLManager.getProxyHost(protocol);
            URL content = proxyHost != null ? new URL(protocol, proxyHost, URLManager.getProxyPort(protocol), url) : new URL(url);
            URLConnection conn = content.openConnection();
            Reader reader = URLFetcher.getReader(conn);
            return reader;
        }
        catch (Throwable t) {
            String reason = "";
            reason = t instanceof MalformedURLException ? "The URL is Malformed." : t.toString();
            if (!DiskCacheUtils.isCached(url)) {
                URLManager.register(url, 14, reason);
            } else {
                JetspeedDiskCache.getInstance().remove(url);
            }
            throw new URLNotAvailableException(reason, url);
        }
        finally {
            URLFetcher.removeRealtimeURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean refresh(String url) throws IOException {
        if (!URLManager.isOK(url)) {
            if (DiskCacheUtils.isCached(url)) {
                JetspeedDiskCache.getInstance().remove(url);
            }
            throw new URLNotAvailableException(url);
        }
        if (URLFetcher.isRealtimeURL(url)) {
            return false;
        }
        DiskCacheEntry dce = null;
        if (DiskCacheUtils.isCached(url)) {
            try {
                dce = JetspeedDiskCache.getInstance().getEntry(url);
                if (!dce.hasExpired()) {
                    boolean bl = false;
                    return bl;
                }
                URLFetcher.addRealtimeURL(url);
                String protocol = url.substring(0, url.indexOf(":/"));
                String proxyHost = URLManager.getProxyHost(protocol);
                URL sock = proxyHost != null ? new URL(protocol, proxyHost, URLManager.getProxyPort(protocol), url) : new URL(url);
                URLConnection conn = null;
                conn = sock.openConnection();
                File file = dce.getFile();
                long mod = dce.getLastModified();
                long filesize = 0L;
                if (file != null) {
                    filesize = file.length();
                }
                if (mod > 0L || filesize > 0L) {
                    conn.setIfModifiedSince(mod);
                }
                conn.connect();
                long last = conn.getLastModified();
                long expires = conn.getExpiration();
                int clength = conn.getContentLength();
                int respCode = 200;
                if (conn instanceof HttpURLConnection) {
                    respCode = ((HttpURLConnection)conn).getResponseCode();
                }
                if (!(respCode == 304 || clength != -1 && clength <= 0 || last != 0L && last <= dce.getLastModified())) {
                    logger.info("URLFetcher: Found updated URL: " + url + " Modified " + last + " Expires: " + expires + " CLength: " + clength);
                    JetspeedDiskCache.getInstance().getEntry(url, URLFetcher.getReader(conn));
                    conn.getInputStream().close();
                    if (last > 0L) {
                        dce.setLastModified(last);
                    } else {
                        dce.setLastModified(System.currentTimeMillis());
                    }
                    dce.setExpirationTime(expires);
                    boolean bl = true;
                    return bl;
                }
                if (last > 0L) {
                    dce.setLastModified(last);
                } else {
                    dce.setLastModified(System.currentTimeMillis());
                }
                dce.setExpirationTime(expires);
                logger.info("DiskCacheDaemon: URL still valid: " + url + " Modified " + last + " Expires: " + expires + " CLength: " + clength);
                boolean bl = false;
                return bl;
            }
            catch (Throwable e) {
                logger.error("Throwable", e);
                URLManager.register(url, 14, e.toString());
            }
            finally {
                URLFetcher.removeRealtimeURL(url);
            }
        } else {
            logger.info("URLFetcher: Cache miss during validation! Forcing url: " + url);
            URLFetcher.removeRealtimeURL(url);
            JetspeedDiskCache.getInstance().getEntry(url, true);
            return true;
        }
        return false;
    }

    static final Reader getReader(URLConnection conn) throws IOException, UnsupportedEncodingException {
        int off;
        String enc = conn.getContentEncoding();
        if (enc == null) {
            enc = "ISO-8859-1";
        }
        BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
        is.mark(20480);
        BufferedReader asciiReader = new BufferedReader(new InputStreamReader((InputStream)is, "ASCII"));
        String decl = asciiReader.readLine();
        String key = "encoding=\"";
        if (decl != null && (off = decl.indexOf(key)) > 0) {
            enc = decl.substring(off + key.length(), decl.indexOf(34, off + key.length()));
        }
        logger.info("URLFetcher: found URL with encoding -> " + enc);
        is.reset();
        InputStreamReader rdr = new InputStreamReader((InputStream)is, enc);
        return rdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void addRealtimeURL(String url) {
        Hashtable hashtable = realtime_urls;
        synchronized (hashtable) {
            Vector<Thread> threads = (Vector<Thread>)realtime_urls.get(url);
            if (threads != null) {
                if (!threads.contains(Thread.currentThread())) {
                    threads.addElement(Thread.currentThread());
                }
            } else {
                threads = new Vector<Thread>();
                threads.addElement(Thread.currentThread());
                realtime_urls.put(url, threads);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void removeRealtimeURL(String url) {
        Hashtable hashtable = realtime_urls;
        synchronized (hashtable) {
            Vector threads = (Vector)realtime_urls.get(url);
            if (threads != null) {
                Vector vector = threads;
                synchronized (vector) {
                    Thread realLoader = (Thread)threads.firstElement();
                    if (realLoader == Thread.currentThread()) {
                        String string = url.intern();
                        synchronized (string) {
                            realtime_urls.remove(url);
                            url.intern().notifyAll();
                        }
                    } else {
                        threads.removeElement(Thread.currentThread());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isRealtimeURL(String url) {
        Hashtable hashtable = realtime_urls;
        synchronized (hashtable) {
            return realtime_urls.get(url) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Hashtable getRealtimeURLs() {
        Hashtable hashtable = realtime_urls;
        synchronized (hashtable) {
            return realtime_urls;
        }
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
    }
}

