/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.services.webpage.Configuration;
import org.apache.jetspeed.services.webpage.JetspeedSiteSession;
import org.apache.jetspeed.services.webpage.ProxyRunData;
import org.apache.jetspeed.services.webpage.SecuredSite;
import org.apache.jetspeed.services.webpage.SessionMap;
import org.apache.jetspeed.services.webpage.Site;
import org.apache.jetspeed.services.webpage.SiteSession;
import org.apache.jetspeed.services.webpage.WebPageCache;
import org.apache.jetspeed.services.webpage.WebPageHelper;
import org.apache.jetspeed.services.webpage.WebPageService;
import org.apache.log4j.Logger;

public class JetspeedWebPageService
implements WebPageService {
    public static final String SESSION_MAP = "wps.SessionMap";
    public static final String URL_SESSION_MAP = "wps.URLSessionMap";
    public static final String INIT_PROPERTIES_PARAM = "properties";
    private String host = null;
    private HashMap sites = new HashMap();
    private HashMap sessions = new HashMap();
    private boolean init = false;
    static Logger log = Logger.getLogger(JetspeedWebPageService.class);
    private String lastError = "Jetspeed WebPage Service has not been initialized.";

    public void get(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ProxyRunData rundata = new ProxyRunData(servlet, request, response, false);
        this.dispatch(rundata);
    }

    public void post(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ProxyRunData rundata = new ProxyRunData(servlet, request, response, true);
        this.dispatch(rundata);
    }

    private void dispatch(ProxyRunData data) throws ServletException, IOException {
        this.getHost(data.getRequest());
        Configuration config = Configuration.getInstance();
        String sid = data.getRequest().getParameter(config.getSID());
        String url = data.getRequest().getParameter(config.getURL());
        if (null == sid) {
            if (null == url) {
                throw new ServletException("Bad Request. No proxy-parameters passed in request.");
            }
            this.proxyByURL(url, data);
            return;
        }
        Site site = this.getSite(sid);
        if (null == site) {
            throw new ServletException("The Requested Site ID is currently not configured on this system: " + sid);
        }
        if (site.getStatus() != 1) {
            throw new ServletException("The Requested Site (" + site.getURL() + ") is not available. Status = " + WebPageHelper.getAvailabilityStatus(site.getStatus()));
        }
        String resource = this.getResourcePath(site.getURL(), data.getRequest());
        boolean loggedOn = true;
        HttpSession session = data.getRequest().getSession(false);
        if (null == session) {
            session = data.getRequest().getSession(true);
        }
        String sessionID = session.getId();
        SessionMap smap = (SessionMap)this.sessions.get(sessionID);
        JetspeedSiteSession jss = null;
        if (null == smap) {
            String username = "";
            smap = new SessionMap(sessionID, username);
            session.setAttribute(SESSION_MAP, (Object)smap);
            this.sessions.put(sessionID, smap);
            jss = new JetspeedSiteSession(site, this.host, username);
            smap.put(site.getURL(), jss);
            loggedOn = jss.logon(data);
        } else {
            jss = (JetspeedSiteSession)smap.get(site.getURL());
            if (null == jss) {
                String username = "";
                jss = new JetspeedSiteSession(site, this.host, username);
                smap.put(site.getURL(), jss);
                loggedOn = jss.logon(data);
            }
        }
        if (loggedOn) {
            if (data.getRequest().getParameter("logon-test") != null) {
                return;
            }
            if (WebPageCache.isCacheableResource(resource)) {
                if (WebPageCache.getResourceFromCache(resource, site.getID(), site.getURL(), this.host, data)) {
                    smap.incCacheCount();
                    jss.incCacheCount();
                } else {
                    smap.incHitCount();
                    jss.incHitCount();
                }
                return;
            }
            smap.incHitCount();
            jss.incHitCount();
            jss.proxy(resource, data);
        }
    }

    private void getHost(HttpServletRequest request) {
        if (null != this.host) {
            return;
        }
        StringBuffer root = new StringBuffer();
        String scheme = request.getScheme();
        root.append(scheme);
        root.append("://");
        int port = request.getServerPort();
        String hostname = request.getServerName();
        String ip = WebPageHelper.getIP(hostname);
        if (null == ip) {
            root.append(hostname);
        } else {
            root.append(ip);
        }
        if (port > 0 && (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443)) {
            root.append(":");
            root.append(port);
        }
        root.append(request.getServletPath());
        this.host = root.toString();
    }

    public Site getSite(String sid) throws ServletException {
        return (Site)this.sites.get(sid);
    }

    public String getResourcePath(String url, HttpServletRequest request) {
        String path = request.getParameter(Configuration.getInstance().getPath());
        if (path == null) {
            return "";
        }
        String fullPath = WebPageHelper.concatURLs(url, path);
        return fullPath.replace('@', '&');
    }

    private SiteSession proxyByURL(String url, ProxyRunData data) throws ServletException, IOException {
        String newURL = url.replace('@', '&');
        String base = this.getTargetBase(newURL);
        HttpSession session = data.getRequest().getSession(false);
        if (null == session) {
            session = data.getRequest().getSession(true);
        }
        String sessionID = session.getId();
        SessionMap smap = (SessionMap)this.sessions.get(sessionID);
        JetspeedSiteSession pxSession = null;
        if (null == smap) {
            smap = new SessionMap(sessionID, "NA");
            session.setAttribute(URL_SESSION_MAP, (Object)smap);
            this.sessions.put(sessionID, smap);
            SecuredSite site = new SecuredSite(base, base);
            pxSession = new JetspeedSiteSession(site, base, this.host);
            smap.put(base, pxSession);
        } else {
            pxSession = (JetspeedSiteSession)smap.get(base);
            if (null == pxSession) {
                SecuredSite site = new SecuredSite(base, base);
                pxSession = new JetspeedSiteSession(site, base, this.host);
                smap.put(base, pxSession);
            }
        }
        if (WebPageCache.isCacheableResource(newURL)) {
            if (WebPageCache.getResourceFromCache(newURL, -1L, base, this.host, data)) {
                smap.incCacheCount();
                pxSession.incCacheCount();
            } else {
                smap.incHitCount();
                pxSession.incHitCount();
            }
            return pxSession;
        }
        smap.incHitCount();
        pxSession.incHitCount();
        pxSession.proxy(newURL, data);
        return pxSession;
    }

    public String getTargetBase(String url) throws ServletException {
        try {
            String path;
            URL u = new URL(url);
            StringBuffer base = new StringBuffer();
            String protocol = u.getProtocol();
            base.append(protocol);
            base.append("://");
            int port = u.getPort();
            base.append(u.getHost());
            if (port > 0 && (protocol.equals("http") && port != 80 || protocol.equals("https") && port != 443)) {
                base.append(":");
                base.append(port);
            }
            if (null != (path = u.getFile())) {
                int slash;
                int dot = path.lastIndexOf(46);
                if (dot > (slash = path.lastIndexOf(47)) && slash != -1) {
                    path = path.substring(0, slash);
                }
                base.append(path);
                if ('/' != base.charAt(base.length() - 1)) {
                    base.append('/');
                }
            } else {
                base.append("/");
            }
            return base.toString();
        }
        catch (MalformedURLException e) {
            throw new ServletException(e.toString());
        }
    }

    public boolean init(ServletConfig config) throws ServletException, IOException {
        String paramFile = config.getInitParameter(INIT_PROPERTIES_PARAM);
        if (null == paramFile) {
            this.lastError = "Jetspeed HTTP Proxy Init Property Not Found:properties";
            log.error((Object)this.lastError);
            return false;
        }
        String fullPath = config.getServletContext().getRealPath(paramFile);
        Configuration pc = Configuration.getInitialInstance(fullPath);
        if (null == pc) {
            return false;
        }
        this.lastError = "";
        this.init = true;
        return true;
    }

    public boolean isInit() {
        return this.init;
    }

    public void destroy() {
        try {
            for (SessionMap map : this.sessions.values()) {
                for (SiteSession has : map.values()) {
                    try {
                        has.logout(null);
                    }
                    catch (Exception e) {
                        log.error((Object)("Shutdown-Logout of Session: " + e));
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public Collection getSessions() {
        return this.sessions.values();
    }

    public SessionMap getSession(String id) {
        return (SessionMap)this.sessions.get(id);
    }

    public Collection getSites() {
        return this.sites.values();
    }

    public String getErrorString() {
        return this.lastError;
    }
}

