/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.util.HashMap;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.jetspeed.services.webpage.SiteSession;
import org.apache.log4j.Logger;

public class SessionMap
extends HashMap
implements HttpSessionBindingListener {
    private String sessionUser;
    private String sessionID;
    private boolean active = true;
    private int hitCount = 0;
    private int cacheCount = 0;
    static Logger log = Logger.getLogger(SessionMap.class);

    public SessionMap(String sessionID, String sessionUser) {
        this.sessionID = sessionID;
        this.sessionUser = sessionUser;
    }

    public String getUser() {
        return this.sessionUser;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getSessionState() {
        return this.active ? "active" : "inactive";
    }

    public int getSessionCount() {
        return this.size();
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void incHitCount() {
        ++this.hitCount;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void incCacheCount() {
        ++this.cacheCount;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        log.info((Object)("~~~ SessionMap UNBOUND as " + event.getName() + " from " + event.getSession().getId()));
        for (SiteSession hps : this.values()) {
            try {
                hps.logout(null);
            }
            catch (Exception e) {
                log.error((Object)("Unbound-Logout of Session: " + e));
            }
        }
        this.active = false;
        this.clear();
    }
}

