/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.webpage;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.jetspeed.services.webpage.CachedResource;
import org.apache.jetspeed.services.webpage.Configuration;
import org.apache.jetspeed.services.webpage.ProxyRunData;
import org.apache.jetspeed.services.webpage.WebPageHelper;
import org.apache.log4j.Logger;

public class WebPageCache {
    private static HashMap cache = new HashMap();
    static Logger log = Logger.getLogger(WebPageCache.class);
    public static String[] CACHEABLE_RESOURCES = new String[]{".gif", ".jpeg", ".jpg", ".png", ".js", ".css"};

    public static boolean getResourceFromCache(String resource, long sid, String base, String host, ProxyRunData data) {
        try {
            CachedResource cr = (CachedResource)cache.get(resource);
            if (null != cr) {
                byte[] bytes = cr.getContent();
                data.getResponse().getOutputStream().write(bytes, 0, bytes.length);
                return true;
            }
            URL baseURL = new URL(base);
            URL u = new URL(baseURL, resource);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            con.setDoInput(true);
            con.setAllowUserInteraction(false);
            int contentType = WebPageHelper.getContentType(con.getHeaderField("content-type"), resource);
            byte[] content = 6 == contentType ? WebPageCache.rewriteScript(con, sid, host, data, resource, base) : WebPageCache.getContentAndWrite(con, data);
            cr = new CachedResource(contentType, content);
            cache.put(resource, cr);
        }
        catch (MalformedURLException ex) {
            log.error((Object)("CACHE URL EX:" + ex));
            return false;
        }
        catch (IOException ex) {
            log.error((Object)("CACHE IO:" + ex));
            return false;
        }
        return true;
    }

    public static boolean isCacheableResource(String resource) {
        int pos = resource.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        if (resource.endsWith(".html")) {
            return false;
        }
        int length = resource.length();
        if (pos >= length) {
            return false;
        }
        String ext = resource.substring(pos);
        for (int ix = 0; ix < CACHEABLE_RESOURCES.length; ++ix) {
            if (!ext.equalsIgnoreCase(CACHEABLE_RESOURCES[ix])) continue;
            return true;
        }
        return false;
    }

    public static byte[] getContentAndWrite(URLConnection con, ProxyRunData data) throws IOException {
        int CAPACITY = 4096;
        InputStream is = con.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = new byte[CAPACITY];
        int readCount = 0;
        while ((readCount = is.read(bytes)) > 0) {
            buffer.write(bytes, 0, readCount);
            data.getResponse().getOutputStream().write(bytes, 0, readCount);
        }
        is.close();
        return buffer.toByteArray();
    }

    public static byte[] rewriteScript(URLConnection con, long sid, String host, ProxyRunData data, String resource, String base) throws IOException {
        int CAPACITY = 4096;
        Configuration config = Configuration.getInstance();
        InputStream is = con.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = new byte[CAPACITY];
        FileOutputStream fos = null;
        boolean logging = config.getEnableContentLog();
        if (logging) {
            String fileName = data.getServlet().getServletContext().getRealPath(config.getLogLocation());
            fos = new FileOutputStream(fileName, true);
            WebPageHelper.writeHeader(fos, resource);
        }
        int readCount = 0;
        while ((readCount = is.read(bytes)) > 0) {
            buffer.write(bytes, 0, readCount);
            if (!logging) continue;
            fos.write(bytes, 0, readCount);
        }
        if (logging) {
            fos.close();
        }
        is.close();
        String script = buffer.toString();
        if (sid == -1L) {
            // empty if block
        }
        return script.getBytes();
    }
}

