/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.parser;

import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.util.parser.DefaultParameterParser;

public class DefaultJetspeedParameterParser
extends DefaultParameterParser {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DefaultJetspeedParameterParser.class.getName());

    public DefaultJetspeedParameterParser() {
    }

    public DefaultJetspeedParameterParser(String characterEncoding) {
        super(characterEncoding);
    }

    public void setRequest(HttpServletRequest req) {
        MediaTypeEntry media;
        super.setRequest(req);
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(req.getHeader("User-Agent"));
        MimeType mime = cm.getPreferredType();
        String characterSet = JetspeedResources.getString("content.defaultencoding", "utf-8");
        if (mime != null && (media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, cm.getPreferredMediaType())) != null && media.getCharacterSet() != null) {
            characterSet = media.getCharacterSet();
        }
        this.setCharacterEncoding(characterSet);
    }

    public String getString(String name) {
        String str = super.getString(name);
        if (str == null) {
            return null;
        }
        String header = this.getRequest().getHeader("Content-type");
        if (header != null && header.startsWith("multipart/form-data")) {
            return str;
        }
        try {
            if (header != null && header.indexOf("charset=") >= 0) {
                return str;
            }
            return new String(str.getBytes("8859_1"), this.getCharacterEncoding());
        }
        catch (Exception e) {
            logger.warn("DefaultJetspeedParameterParser: Exception: " + e.toString(), e);
            return str;
        }
    }
}

