/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.template;

import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;

public class BaseJetspeedLink
implements ApplicationTool,
JetspeedLink {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseJetspeedLink.class.getName());
    private JetspeedRunData rundata = null;
    private ProfileLocator locator = null;
    private Profile profile = null;
    private boolean initDone = false;
    protected Portlet activePortlet = null;

    public BaseJetspeedLink() {
    }

    public BaseJetspeedLink(RunData data) {
        this.init((Object)data);
    }

    public void init(RunData rundata) {
        this.init((Object)rundata);
    }

    public DynamicURI addQueryData(String name, Object value) {
        try {
            return this.getRoot().addQueryData(name, value);
        }
        catch (ProfileException e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public DynamicURI addPathInfo(String name, Object value) {
        try {
            return this.getRoot().addPathInfo(name, value);
        }
        catch (ProfileException e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public DynamicURI setPortalElement(String peid) {
        if (!this.initDone) {
            this.initLink();
        }
        if (this.profile.getDocument().getEntryById(peid) != null) {
            return this.getPortletById(peid);
        }
        return this.setPaneById(peid);
    }

    public DynamicURI setPortletById(String peid) {
        return this.getPortletById(peid);
    }

    public DynamicURI getHomePage() {
        return this.getLink(102, null, "", 102, null, "", "", "", "", "");
    }

    public DynamicURI getTemplate() {
        String template = this.rundata.getRequestedTemplate();
        return this.getLink(101, null, null, 102, null, null, template, null, null, null);
    }

    public DynamicURI setTemplate(String template) {
        return this.getTemplate(template);
    }

    public DynamicURI setAction(String action) {
        return this.getAction(action);
    }

    public DynamicURI setAction(String action, Portlets portlets) {
        return this.getAction(action, portlets);
    }

    public DynamicURI setAction(String action, Portlet portlet) {
        return this.getAction(action, portlet);
    }

    public DynamicURI setAction(String action, Entry entry) {
        return this.getAction(action, entry);
    }

    public DynamicURI setAction(String action, String peid) {
        return this.getAction(action, peid);
    }

    public DynamicURI setGroup(String group) {
        return this.getGroup(group);
    }

    public DynamicURI setGroup(String group, String page) {
        return this.getGroup(group, page);
    }

    public DynamicURI setPage() {
        return this.getPage();
    }

    public DynamicURI setPage(String page) {
        return this.getPage(page);
    }

    public DynamicURI setPage(String page, String paneName) {
        return this.getPage(page, paneName);
    }

    public DynamicURI setRole(String role) {
        return this.getRole(role);
    }

    public DynamicURI setRole(String role, String page) {
        return this.getRole(role, page);
    }

    public DynamicURI setUser(String user) {
        return this.getUser(user);
    }

    public DynamicURI setUser(String user, String page) {
        return this.getUser(user, page);
    }

    public DynamicURI setPaneById(String paneId) {
        return this.getPaneById(paneId);
    }

    public DynamicURI setPaneByName(String paneName) {
        return this.getPaneByName(paneName);
    }

    public DynamicURI getLink(int rootType, String rootValue, String pageName, int elementType, String elementValue, String actionName, String templateName, String mediaType, String language, String country) {
        String uriPathType = null;
        String uriPathElement = null;
        try {
            DynamicURI uri = this.getRoot();
            switch (rootType) {
                case 101: 
                case 102: {
                    break;
                }
                case 201: {
                    uriPathType = "group";
                    break;
                }
                case 202: {
                    uriPathType = "role";
                    break;
                }
                case 203: {
                    uriPathType = "user";
                }
            }
            if (rootType != 101) {
                uri.removePathInfo("group");
                uri.removePathInfo("role");
                uri.removePathInfo("user");
                if (rootType != 102 && rootValue != null && rootValue.trim().length() > 0) {
                    uri.addPathInfo(uriPathType, rootValue);
                }
            }
            if (pageName != null) {
                uri.removePathInfo("page");
                if (pageName.trim().length() > 0) {
                    uri.addPathInfo("page", pageName);
                }
            }
            switch (elementType) {
                case 101: 
                case 102: {
                    break;
                }
                case 301: {
                    uriPathElement = "js_pane";
                    break;
                }
                case 302: {
                    uriPathElement = "js_panename";
                    break;
                }
                case 303: {
                    uriPathElement = "js_peid";
                    break;
                }
                case 304: {
                    uriPathElement = "portlet";
                    break;
                }
                case 305: {
                    Entry entry;
                    if (logger.isDebugEnabled()) {
                        logger.debug("BaseJetspeedLink: elementValue = " + elementValue);
                    }
                    uriPathElement = "js_peid";
                    ProfileLocator baseLocator = Profiler.createLocator();
                    Profile baseProfile = null;
                    switch (rootType) {
                        case 102: {
                            break;
                        }
                        case 101: {
                            baseProfile = this.rundata.getProfile();
                            break;
                        }
                        case 201: {
                            baseLocator.setGroupByName(rootValue);
                            break;
                        }
                        case 202: {
                            baseLocator.setRoleByName(rootValue);
                            break;
                        }
                        case 203: {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("BaseJetspeedLink: rootValue user = " + rootValue);
                                }
                                baseLocator.setUser(JetspeedSecurity.getUser(rootValue));
                                break;
                            }
                            catch (Exception se) {
                                logger.error("Exception", se);
                                return null;
                            }
                        }
                    }
                    if (rootType != 101 && rootType != 102) {
                        if (mediaType != null && mediaType.length() > 0) {
                            baseLocator.setMediaType(mediaType);
                        }
                        if (language != null && language.length() > 0) {
                            baseLocator.setLanguage(language);
                        }
                        if (country != null && country.length() > 0) {
                            baseLocator.setCountry(country);
                        }
                        if (pageName != null && pageName.length() > 0) {
                            baseLocator.setName(pageName);
                        }
                        baseProfile = Profiler.getProfile(baseLocator);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("BaseJetspeedLink: baseLocator = " + baseLocator.getPath());
                    }
                    if (baseProfile == null || elementValue == null) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("BaseJetspeedLink: baseProfile = " + baseProfile.toString());
                    }
                    if (baseProfile.getDocument() == null) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("BaseJetspeedLink: baseProfile.getDocment() = " + baseProfile.getDocument());
                    }
                    if ((entry = baseProfile.getDocument().getEntry(elementValue)) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("BaseJetspeedLink: entry id = " + entry.getId());
                        }
                        elementValue = entry.getId();
                        break;
                    }
                    elementValue = null;
                }
            }
            if (elementType != 101) {
                uri.removePathInfo("js_pane");
                uri.removePathInfo("js_panename");
                uri.removePathInfo("js_peid");
                uri.removePathInfo("portlet");
                if (elementType != 102 && elementValue != null && elementValue.length() > 0) {
                    uri.addPathInfo(uriPathElement, elementValue);
                }
            }
            if (templateName != null) {
                uri.removePathInfo("template");
                if (templateName.length() > 0) {
                    uri.addPathInfo("template", templateName);
                }
            }
            if (actionName != null) {
                uri.removeQueryData("action");
                if (actionName.length() > 0) {
                    uri.addQueryData("action", actionName);
                }
            }
            if (mediaType != null) {
                uri.removePathInfo("media-type");
                if (mediaType.length() > 0) {
                    uri.addPathInfo("media-type", mediaType);
                }
            }
            if (language != null) {
                uri.removePathInfo("language");
                if (language.length() > 0) {
                    uri.addPathInfo("language", language);
                }
            }
            if (country != null) {
                uri.removePathInfo("country");
                if (country.length() > 0) {
                    uri.addPathInfo("country", country);
                }
            }
            return uri;
        }
        catch (ProfileException e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public DynamicURI getLink(int rootType, String rootValue, String pageName, int elementType, String elementValue, String actionName, String templateName, String mediaType, String language) {
        return this.getLink(rootType, rootValue, pageName, elementType, elementValue, actionName, templateName, mediaType, language, null);
    }

    public DynamicURI getLink(int rootType, String rootValue, String pageName, int elementType, String elementValue, String actionName, String templateName, String mediaType) {
        return this.getLink(rootType, rootValue, pageName, elementType, elementValue, actionName, templateName, mediaType, null, null);
    }

    public DynamicURI getLink(int rootType, String rootValue, String pageName, int elementType, String elementValue, String actionName, String templateName) {
        return this.getLink(rootType, rootValue, pageName, elementType, elementValue, actionName, actionName, null, null, null);
    }

    public DynamicURI getLink(int rootType, String rootValue, String pageName, int elementType, String elementValue, String actionName) {
        return this.getLink(rootType, rootValue, pageName, elementType, elementValue, actionName, null, null, null, null);
    }

    public DynamicURI getLink(int rootType, String rootValue, String pageName, int elementType, String elementValue) {
        return this.getLink(rootType, rootValue, pageName, elementType, elementValue, null, null, null, null, null);
    }

    public DynamicURI getAction(String action) {
        return this.getLink(101, null, null, 101, null, action, null, null, null, null);
    }

    public DynamicURI getAction(String action, Entry entry) {
        if (entry != null) {
            return this.getLink(101, null, null, 303, entry.getId(), null, action, null, null, null);
        }
        return this.getLink(101, null, null, 303, null, null, action, null, null, null);
    }

    public DynamicURI getAction(String action, Portlet portlet) {
        if (portlet != null) {
            return this.getLink(101, null, null, 303, portlet.getID(), action, null, null, null, null);
        }
        return this.getLink(101, null, null, 303, null, action, null, null, null, null);
    }

    public DynamicURI getAction(String action, Portlets portlets) {
        if (portlets != null) {
            return this.getLink(101, null, null, 303, portlets.getId(), action, null, null, null, null);
        }
        return this.getLink(101, null, null, 303, null, action, null, null, null, null);
    }

    public DynamicURI getAction(String action, String peid) {
        return this.getLink(101, null, null, 303, peid, action, null, null, null, null);
    }

    public DynamicURI getGroup(String group) {
        return this.getLink(201, group, "", 102, null, null, null, null, null, null);
    }

    public DynamicURI getGroup(String group, String page) {
        return this.getLink(201, group, page, 102, null, null, null, null, null, null);
    }

    public DynamicURI getPage() {
        return this.getLink(101, null, "", 102, null, null, null, null, null, null);
    }

    public DynamicURI getPage(String page) {
        return this.getLink(101, null, page, 102, null, null, null, null, null, null);
    }

    public DynamicURI getPage(String page, String paneName) {
        return this.getLink(101, null, page, 302, paneName, null, null, null, null, null);
    }

    public DynamicURI getPaneById(String paneId) {
        return this.getLink(101, null, this.getPageName(), 301, paneId, null, null, null, null, null);
    }

    public DynamicURI getPaneByName(String paneName) {
        return this.getLink(101, null, this.getPageName(), 302, paneName, null, null, null, null, null);
    }

    public DynamicURI getPortletById(String peid) {
        return this.getLink(101, null, this.getPageName(), 303, peid, null, null, null, null, null);
    }

    public DynamicURI getPortletByName(String portletName) {
        return this.getLink(101, null, this.getPageName(), 304, portletName, null, null, null, null, null);
    }

    public DynamicURI getRole(String role) {
        return this.getLink(202, role, "", 102, null, null, null, null, null, null);
    }

    public DynamicURI getRole(String role, String page) {
        return this.getLink(202, role, page, 102, null, null, null, null, null, null);
    }

    public DynamicURI getTemplate(String template) {
        return this.getLink(101, null, null, 102, null, null, template, null, null, null);
    }

    public DynamicURI getUser(String user) {
        return this.getLink(203, user, "", 102, null, null, null, null, null, null);
    }

    public DynamicURI getUser(String user, String page) {
        return this.getLink(203, user, page, 102, null, null, null, null, null, null);
    }

    private void initLink() {
        if (this.initDone) {
            return;
        }
        try {
            this.profile = this.rundata.getProfile();
            if (this.profile == null) {
                this.profile = Profiler.getProfile((RunData)this.rundata);
                this.rundata.setProfile(this.profile);
                logger.warn("BaseJetspeedLink: profile in rundata was null");
            }
        }
        catch (ProfileException e) {
            logger.error("Exception", e);
        }
        if (this.profile != null && this.profile instanceof ProfileLocator) {
            this.locator = this.profile;
        }
        this.initDone = true;
    }

    private DynamicURI getRoot() throws ProfileException {
        DynamicURI uri = null;
        this.initLink();
        if (this.locator != null) {
            uri = Profiler.makeDynamicURI((RunData)this.rundata, this.locator);
        }
        if (uri == null) {
            uri = new DynamicURI((RunData)this.rundata);
        }
        if (JetspeedResources.getBoolean("force.ssl", false)) {
            uri.setSecure();
        }
        return uri;
    }

    public String toString() {
        try {
            return this.getRoot().toString();
        }
        catch (ProfileException e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public String getActionKey() {
        return "action";
    }

    public boolean getAnonymous() {
        this.initLink();
        try {
            return this.locator.getAnonymous();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return true;
        }
    }

    public String getCountry() {
        this.initLink();
        try {
            return this.locator.getCountry();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public String getGroupName() {
        this.initLink();
        try {
            return this.locator.getGroupName();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public String getLanguage() {
        this.initLink();
        try {
            return this.locator.getLanguage();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public String getMediaType() {
        this.initLink();
        try {
            return this.locator.getMediaType();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public String getPageName() {
        this.initLink();
        try {
            return this.locator.getName();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public String getRoleName() {
        this.initLink();
        try {
            return this.locator.getRoleName();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public String getUserName() {
        this.initLink();
        try {
            return this.locator.getUserName();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    public static int getCURRENT() {
        return 101;
    }

    public static int getDEFAULT() {
        return 102;
    }

    public static int getGROUP() {
        return 201;
    }

    public static int getPANE_ID() {
        return 301;
    }

    public static int getPANE_NAME() {
        return 302;
    }

    public static int getPORTLET_ID() {
        return 303;
    }

    public static int getPORTLET_NAME() {
        return 304;
    }

    public static int getROLE() {
        return 202;
    }

    public static int getUSER() {
        return 203;
    }

    public static String getDEFAULT_PAGE() {
        return "";
    }

    public void setPortlet(Portlet portlet) {
        this.activePortlet = portlet;
    }

    public DynamicURI setPortletByName(String portletName) {
        DynamicURI uri = null;
        try {
            uri = this.getRoot();
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
        if (portletName != null && portletName.length() > 0) {
            uri.addPathInfo("portlet", portletName);
        }
        return uri;
    }

    public void init(Object data) {
        this.rundata = data instanceof JetspeedRunData ? (JetspeedRunData)data : null;
        this.profile = null;
        this.locator = null;
        this.initDone = false;
    }

    public void refresh() {
    }

    public DynamicURI setMediaType(String mediaType) {
        return this.getLink(101, null, null, 102, null, null, null, mediaType);
    }
}

