/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.webservices.util;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;

public class SoapAccessBean
implements Serializable {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SoapAccessBean.class.getName());
    private transient Call request = new Call();
    private Vector parameters;

    public SoapAccessBean() {
    }

    public SoapAccessBean(String targetURI, String method) {
        this.request.setTargetObjectURI(targetURI);
        this.request.setMethodName(method);
        this.request.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        this.parameters = new Vector();
    }

    public void setParameters(Vector parameters) {
        this.parameters = parameters;
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public void addParameter(String paramName, Class paramClass, Object paramValue, String encoding) {
        this.parameters.addElement(new Parameter(paramName, paramClass, paramValue, encoding));
    }

    public Object processRequest(String url) throws SOAPException {
        Object result;
        block5: {
            Response response = null;
            result = null;
            try {
                this.request.setParams(this.parameters);
                response = this.request.invoke(new URL(url), "");
                if (response.generatedFault()) {
                    logger.warn(response.getFault().getFaultString());
                } else {
                    result = response.getReturnValue().getValue();
                    if (logger.isDebugEnabled()) {
                        logger.debug(response.getReturnValue().toString());
                    }
                }
            }
            catch (MalformedURLException exception) {
                if (!logger.isDebugEnabled()) break block5;
                logger.error(exception.getMessage(), exception);
            }
        }
        return result;
    }
}

