/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipTAclMap;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.schedule.ScheduleAdminAclUserGroupResultData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Enumeration;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleAdminAclFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleAdminAclFormData.class.getName());
    private ScheduleAdminAclUserGroupResultData currentResultData;
    private ALStringField aclData;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        TurbineGroup record;
        String id;
        super.init(action, rundata, context);
        this.currentResultData = new ScheduleAdminAclUserGroupResultData();
        this.currentResultData.initField();
        this.aclData = new ALStringField();
        String entitiyId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        Integer tmpId = null;
        if (entitiyId.startsWith("ug")) {
            id = entitiyId.substring(2);
            tmpId = Integer.valueOf(id);
            record = (TurbineGroup)Database.get(TurbineGroup.class, (Object)tmpId);
            if (record == null) {
                throw new ALPageNotFoundException();
            }
            this.currentResultData.setId(tmpId);
            this.currentResultData.setName(record.getGroupAliasName());
            this.currentResultData.setType(ScheduleAdminAclUserGroupResultData.Type.ug);
        } else if (entitiyId.startsWith("fg")) {
            id = entitiyId.substring(2);
            tmpId = Integer.valueOf(id);
            record = (EipMFacilityGroup)Database.get(EipMFacilityGroup.class, (Object)tmpId);
            if (record == null) {
                throw new ALPageNotFoundException();
            }
            this.currentResultData.setId(tmpId);
            this.currentResultData.setName(record.getGroupName());
            this.currentResultData.setType(ScheduleAdminAclUserGroupResultData.Type.fg);
        } else if (entitiyId.startsWith("u")) {
            id = entitiyId.substring(1);
            tmpId = Integer.valueOf(id);
            ALEipUser user = ALEipUtils.getALEipUser((int)tmpId);
            if (user == null) {
                throw new ALPageNotFoundException();
            }
            this.currentResultData.setId(tmpId);
            this.currentResultData.setName(user.getAliasName().getValue());
            this.currentResultData.setType(ScheduleAdminAclUserGroupResultData.Type.u);
        } else if (entitiyId.startsWith("f")) {
            id = entitiyId.substring(1);
            tmpId = Integer.valueOf(id);
            record = (EipMFacility)Database.get(EipMFacility.class, (Object)tmpId);
            if (record == null) {
                throw new ALPageNotFoundException();
            }
            this.currentResultData.setId(tmpId);
            this.currentResultData.setName(record.getFacilityName());
            this.currentResultData.setType(ScheduleAdminAclUserGroupResultData.Type.f);
        } else {
            throw new ALPageNotFoundException();
        }
        List list = Database.query(EipTAclMap.class).where(Operations.eq((String)"targetId", (Object)tmpId)).where(Operations.eq((String)"targetType", (Object)this.currentResultData.getType().toString())).where(Operations.eq((String)"feature", (Object)"schedule")).fetchList();
        StringBuilder tmpAcl = new StringBuilder();
        boolean isFirst = true;
        for (EipTAclMap map : list) {
            if (!isFirst) {
                tmpAcl.append(",");
            }
            isFirst = false;
            tmpAcl.append(map.getType()).append(map.getId()).append(":").append(map.getLevel());
        }
        this.aclData.setValue(tmpAcl.toString());
    }

    public void initField() {
    }

    protected void setValidator() throws ALPageNotFoundException, ALDBErrorException {
    }

    protected boolean validate(List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return true;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        String sql = "delete from eip_t_acl_map where target_id = #bind($target_id) and target_type = #bind($target_type) and feature = #bind($feature)";
        Database.sql(EipTAclMap.class, (String)sql).param("target_id", (Object)this.currentResultData.getId().getValue()).param("target_type", (Object)this.currentResultData.getType().toString()).param("feature", (Object)"schedule").execute();
        Enumeration parameterNames = rundata.getRequest().getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String next = (String)parameterNames.nextElement();
            if (!next.startsWith("acl")) continue;
            String tmpId = next.substring(3);
            String value = rundata.getRequest().getParameter(next);
            Integer id = null;
            String type = null;
            Integer level = null;
            if (tmpId.startsWith("ug")) {
                id = Integer.valueOf(tmpId.substring(2));
                type = "ug";
            } else if (tmpId.startsWith("u")) {
                id = Integer.valueOf(tmpId.substring(1));
                type = "u";
            }
            try {
                level = Integer.valueOf(value);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (id == null || type == null || level == null) continue;
            EipTAclMap model = (EipTAclMap)Database.create(EipTAclMap.class);
            model.setFeature("schedule");
            model.setId(id);
            model.setType(type);
            model.setTargetId(Integer.valueOf((int)this.currentResultData.getId().getValue()));
            model.setTargetType(this.currentResultData.getType().toString());
            model.setLevel(level);
        }
        Database.commit();
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    public ScheduleAdminAclUserGroupResultData getCurrentData() {
        return this.currentResultData;
    }

    public ALStringField getAclData() {
        return this.aclData;
    }
}

