/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.ScheduleOnedayContainer;
import com.aimluck.eip.schedule.ScheduleOnedayResultData;
import com.aimluck.eip.schedule.ScheduleOnedaySelectData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleOnedayGroupSelectData
extends ScheduleOnedaySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleOnedayGroupSelectData.class.getName());
    private Map<Integer, List<ScheduleOnedayResultData>> termmap;
    private Map<Integer, ScheduleOnedayContainer> map;
    private List<ALEipUser> members;
    private List<ALEipGroup> groups;
    private List<ALEipGroup> facilitiyGroups;
    private int userid;
    private int[] rows;
    private int max;
    private boolean is_hasspan;
    private String myGroupURI;
    private Map<Integer, List<ScheduleToDoResultData>> todomap;
    private String portletId;
    private Map<Integer, ScheduleOnedayContainer> facilitymap;
    private List<FacilityResultData> facilityList;
    private boolean hasAuthoritySelfInsert = false;
    private boolean hasAuthorityFacilityInsert = false;
    private boolean hasAclviewOther = false;
    private TurbineGroup target_group_name;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        if (rundata.getParameters().containsKey((Object)"filter")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter", (String)rundata.getParameters().getString("filter"));
        }
        if (rundata.getParameters().containsKey((Object)"filtertype")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype", (String)rundata.getParameters().getString("filtertype"));
        }
        this.viewtype = "oneday-group";
        try {
            VelocityPortlet portlet;
            String groupName;
            this.termmap = new LinkedHashMap<Integer, List<ScheduleOnedayResultData>>();
            this.map = new LinkedHashMap<Integer, ScheduleOnedayContainer>();
            this.todomap = new LinkedHashMap<Integer, List<ScheduleToDoResultData>>();
            this.facilitymap = new LinkedHashMap<Integer, ScheduleOnedayContainer>();
            this.groups = ALEipUtils.getMyGroups((RunData)rundata);
            this.facilitiyGroups = ALEipUtils.getALEipGroups();
            this.userid = ALEipUtils.getUserId((RunData)rundata);
            this.rows = new int[(this.endHour - this.startHour) * 12 + 1];
            int size = this.rows.length;
            for (int i = 0; i < size; ++i) {
                this.rows[i] = 1;
            }
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter");
            this.target_group_name = this.getGroup(filter);
            if (filter == null && (groupName = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter", (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype", (String)"group");
            }
            this.myGroupURI = ScheduleUtils.getPortletURIinPersonalConfigPane(rundata, "MyGroup");
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            this.hasAclviewOther = aclhandler.hasAuthority(this.userid, "schedule_other", 1);
            this.hasAuthoritySelfInsert = aclhandler.hasAuthority(this.userid, "schedule_self", 4);
            this.hasAuthorityFacilityInsert = aclhandler.hasAuthority(this.userid, "schedule_facility", 4);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleOnedayGroupSelectData]", (Throwable)ex);
        }
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            VEipTScheduleList record;
            int i;
            List<VEipTScheduleList> resultBaseList = this.getScheduleList(rundata, context);
            List<VEipTScheduleList> resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
            ArrayList<VEipTScheduleList> list = new ArrayList<VEipTScheduleList>();
            ArrayList<VEipTScheduleList> delList = new ArrayList<VEipTScheduleList>();
            int delSize = 0;
            int resultSize = resultList.size();
            int size = 0;
            boolean canAdd = true;
            for (i = 0; i < resultSize; ++i) {
                record = resultList.get(i);
                delList.clear();
                canAdd = true;
                size = list.size();
                for (int j = 0; j < size; ++j) {
                    VEipTScheduleList record2 = (VEipTScheduleList)list.get(j);
                    if (!record.getRepeatPattern().equals("N") && "D".equals(record2.getStatus()) && record.getScheduleId().intValue() == record2.getParentId().intValue() && record.getUserId().intValue() == record2.getUserId().intValue()) {
                        canAdd = false;
                        break;
                    }
                    if (record2.getRepeatPattern().equals("N") || !"D".equals(record.getStatus()) || record2.getScheduleId().intValue() != record.getParentId().intValue() || record2.getUserId().intValue() != record.getUserId().intValue()) continue;
                    if (!delList.contains(record2)) {
                        delList.add(record2);
                    }
                    canAdd = true;
                }
                delSize = delList.size();
                for (int k = 0; k < delSize; ++k) {
                    list.remove(delList.get(k));
                }
                if (!canAdd) continue;
                list.add(record);
            }
            delList.clear();
            size = list.size();
            for (i = 0; i < size; ++i) {
                record = (VEipTScheduleList)list.get(i);
                if (!"D".equals(record.getStatus())) continue;
                delList.add(record);
            }
            delSize = delList.size();
            for (i = 0; i < delSize; ++i) {
                list.remove(delList.get(i));
            }
            Collections.sort(list, new Comparator<VEipTScheduleList>(){

                @Override
                public int compare(VEipTScheduleList a, VEipTScheduleList b) {
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    cal.setTime(a.getStartDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(b.getStartDate());
                    cal2.set(0, 0, 0);
                    if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    cal.setTime(a.getEndDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(b.getEndDate());
                    cal2.set(0, 0, 0);
                    return cal.getTime().compareTo(cal2.getTime());
                }
            });
            if (this.viewToDo == 1) {
                this.loadToDo(rundata, context);
            }
            return new ResultList(list);
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleOnedayGroupSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    protected List<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getViewDate().getValue());
        cal.add(5, 1);
        cal.add(14, -1);
        ALDateTimeField field = new ALDateTimeField();
        field.setValue(cal.getTime());
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter");
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype");
        if ("all".equals(filter)) {
            filter_type = null;
            filter = null;
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter");
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype");
        }
        if (filter == null || filter_type == null || filter.equals("") || this.tmpViewDate2 != null) {
            this.members = new ArrayList<ALEipUser>();
            this.members.add(ALEipUtils.getALEipUser((RunData)rundata));
            ScheduleOnedayContainer con = new ScheduleOnedayContainer();
            con.initField();
            con.initHour(this.startHour, this.endHour);
            Integer uid = ALEipUtils.getUserId((RunData)rundata);
            this.termmap.put(uid, new ArrayList());
            this.map.put(uid, con);
            this.todomap.put(uid, new ArrayList());
            return ScheduleUtils.getScheduleList(this.userid, this.getViewDate().getValue(), field.getValue(), Arrays.asList(this.userid), null);
        }
        List ulist = ALEipUtils.getUserIds((String)filter);
        int size = ulist.size();
        if (size == 0) {
            ulist.add(-1);
        } else {
            for (int i = 0; i < size; ++i) {
                Integer id = (Integer)ulist.get(i);
                ScheduleOnedayContainer con = new ScheduleOnedayContainer();
                con.initField();
                con.initHour(this.startHour, this.endHour);
                this.termmap.put(id, new ArrayList());
                this.map.put(id, con);
                this.todomap.put(id, new ArrayList());
            }
        }
        ArrayList<Integer> facilityIds = null;
        String[] filteres = filter.split(";");
        if ("Facility".equals(filter)) {
            facilityIds = this.getFacilityIdAllList();
        } else if ("group".equals(filter_type) && !"f".equals(filteres[0])) {
            facilityIds = FacilitiesUtils.getFacilityIds((String)filteres[0]);
        } else if ("f".equals(filteres[0])) {
            facilityIds = FacilitiesUtils.getFacilityGroupIds((Integer)Integer.valueOf(filteres[1]));
        } else if (ScheduleUtils.isNumberValue(filter)) {
            facilityIds = FacilitiesUtils.getFacilityGroupIds((Integer)Integer.valueOf(filter));
        } else {
            VelocityPortlet portlet;
            String groupName;
            facilityIds = new ArrayList<Integer>();
            String[] split = filter.split(",");
            if (split.length == 2 && (groupName = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filter", (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"com.aimluck.eip.schedule.filtertype", (String)"group");
            }
        }
        int f_size = facilityIds.size();
        if (f_size == 0) {
            facilityIds.add(-1);
        } else {
            for (int i = 0; i < f_size; ++i) {
                Integer id = (Integer)facilityIds.get(i);
                ScheduleOnedayContainer con = new ScheduleOnedayContainer();
                con.initField();
                con.initHour(this.startHour, this.endHour);
                this.facilitymap.put(id, con);
            }
        }
        this.members = ALEipUtils.getUsers((String)filter);
        String flag_changeturn = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"flagchangeturn");
        if ("0".equals(flag_changeturn)) {
            ALEipUser eipUser = null;
            int memberSize = this.members.size();
            for (int i = 0; i < memberSize; ++i) {
                eipUser = this.members.get(i);
                if (eipUser.getUserId().getValue() != (long)this.userid) continue;
                this.members.remove(i);
                this.members.add(0, eipUser);
            }
        }
        if ("Facility".equals(filter)) {
            this.facilityList = FacilitiesUtils.getFacilityList((String)filter);
        } else if ("facilitygroup".equals(filter_type) || "f".equals(filteres[0])) {
            if ("f".equals(filteres[0])) {
                this.facilityList = FacilitiesUtils.getFacilityGroupList((Integer)Integer.valueOf(filteres[1]));
            } else if (ScheduleUtils.isNumberValue(filter)) {
                this.facilityList = FacilitiesUtils.getFacilityGroupList((Integer)Integer.valueOf(filter));
            }
        } else {
            this.facilityList = FacilitiesUtils.getFacilityList((String)filter);
        }
        this.current_filter = !"f".equals(filteres[0]) ? filter : filteres[1];
        this.current_filter_type = filter_type;
        return ScheduleUtils.getScheduleList(this.userid, this.getViewDate().getValue(), field.getValue(), ulist, facilityIds);
    }

    private List<Integer> getFacilityIdAllList() {
        ArrayList<Integer> facilityIdAllList = new ArrayList<Integer>();
        try {
            SelectQuery query = Database.query(EipMFacility.class);
            query.select("FACILITY_ID");
            List aList = query.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMFacility record = (EipMFacility)aList.get(i);
                facilityIdAllList.add(record.getFacilityId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
        }
        return facilityIdAllList;
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleOnedayResultData rd = new ScheduleOnedayResultData();
        rd.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.getViewDate(), record.getRepeatPattern(), record.getStartDate(), record.getEndDate())) {
                return rd;
            }
            boolean is_member = record.isMember();
            if (!"D".equals(record.getStatus()) && "P".equals(record.getPublicFlag()) && this.userid != record.getUserId() && this.userid != record.getOwnerId() && !is_member) {
                return rd;
            }
            if (!this.hasAclviewOther && !is_member) {
                return rd;
            }
            if ("C".equals(record.getPublicFlag()) && this.userid != record.getUserId() && this.userid != record.getOwnerId() && !is_member) {
                rd.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                rd.setTmpreserve(false);
            } else {
                rd.setName(record.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId() == this.userid);
            rd.setOwner(record.getOwnerId() == this.userid);
            rd.setMember(is_member);
            rd.setPattern(record.getRepeatPattern());
            ScheduleOnedayContainer con = null;
            con = "U".equals(record.getType()) ? this.map.get(record.getUserId()) : this.facilitymap.get(record.getUserId());
            if (rd.getPattern().equals("S")) {
                this.is_hasspan = true;
                List<ScheduleOnedayResultData> terms = this.termmap.get(record.getUserId());
                if (terms != null) {
                    terms.add(rd);
                }
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.getViewDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
            con.addResultData(rd, this.startHour, this.endHour, this.getViewDate());
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    @Override
    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doViewList(action, rundata, context);
        this.postDoList();
        return res;
    }

    @Override
    public boolean doSelectList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doSelectList(action, rundata, context);
        this.postDoList();
        return res;
    }

    private int[] getMaxRowsFromContainer(Collection<ScheduleOnedayContainer> list) {
        int[] nowRows = new int[this.rows.length];
        for (ScheduleOnedayContainer container : list) {
            container.last(this.startHour, this.endHour, this.getViewDate());
            if (container.isDuplicate()) {
                this.is_duplicate = true;
            }
            int size = this.rows.length;
            int[] tmpRows = container.getRows();
            for (int i = 0; i < size; ++i) {
                if (tmpRows[i] <= nowRows[i]) continue;
                nowRows[i] = tmpRows[i];
            }
        }
        return nowRows;
    }

    private void postDoList() {
        int[] userRows = this.getMaxRowsFromContainer(this.map.values());
        int[] facilityRows = this.getMaxRowsFromContainer(this.facilitymap.values());
        int size = this.rows.length;
        for (int i = 0; i < size; ++i) {
            this.rows[i] = Math.max(this.rows[i], Math.max(userRows[i], facilityRows[i]));
            this.max += this.rows[i];
        }
    }

    @Override
    public void loadToDo(RunData rundata, Context context) {
        try {
            SelectQuery<EipTTodo> query = this.getSelectQueryForTodo(rundata, context);
            List todos = query.fetchList();
            int todossize = todos.size();
            for (int i = 0; i < todossize; ++i) {
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = "";
                todo_url = this.userid == record.getTurbineUser().getUserId() ? ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId) : ScheduleUtils.getPortletURItoTodoPublicDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                List<ScheduleToDoResultData> usertodos1 = this.todomap.get(record.getTurbineUser().getUserId());
                if (usertodos1 == null) continue;
                usertodos1.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return;
        }
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata, Context context) {
        Integer uid = this.userid;
        SelectQuery query = Database.query(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp01 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)uid);
        Expression exp02 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)uid);
        Expression exp03 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        Expression exp04 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp01.orExp(exp02.andExp(exp03)).andExp(exp04));
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    @Override
    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "userId");
        return map;
    }

    public int getColspan(int hour) {
        return this.rows[(hour - this.startHour) * 12] + this.rows[(hour - this.startHour) * 12 + 1] + this.rows[(hour - this.startHour) * 12 + 2] + this.rows[(hour - this.startHour) * 12 + 3] + this.rows[(hour - this.startHour) * 12 + 4] + this.rows[(hour - this.startHour) * 12 + 5] + this.rows[(hour - this.startHour) * 12 + 6] + this.rows[(hour - this.startHour) * 12 + 7] + this.rows[(hour - this.startHour) * 12 + 8] + this.rows[(hour - this.startHour) * 12 + 9] + this.rows[(hour - this.startHour) * 12 + 10] + this.rows[(hour - this.startHour) * 12 + 11];
    }

    public int getScheduleColspan(ScheduleOnedayResultData rd, int[] rows_) {
        int st = rd.getStartRow();
        int ed = rd.getEndRow();
        int span = 0;
        if (st == ed) {
            span = rows_[st] == rd.getIndex() ? this.rows[st] - rows_[st] + 1 : 1;
        } else {
            for (int i = st; i < ed; ++i) {
                span += this.rows[i];
            }
            span += 1 - rows_[st];
        }
        return span;
    }

    public ScheduleOnedayResultData getSpanSchedule(long id) {
        Integer userid = (int)id;
        return this.map.get(userid).getSpanResultData();
    }

    public List<ScheduleOnedayResultData> getScheduleList(long id) {
        Integer userid = (int)id;
        return this.map.get(userid).getSchedule();
    }

    public int[] getRows(long id) {
        Integer userid = (int)id;
        return this.map.get(userid).getRows();
    }

    public List<ScheduleOnedayResultData> getDuplicateSchedule(long id) {
        Integer userid = (int)id;
        return this.map.get(userid).getDuplicateSchedule();
    }

    public List<ScheduleOnedayResultData> getDuplicateScheduleList(long id) {
        Integer userid = (int)id;
        return this.map.get(userid).getDuplicateSchedule();
    }

    public int getDuplicateScheduleListRowCount(long id) {
        Integer userid = (int)id;
        return this.map.get(userid).getDuplicateScheduleRowCount();
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipUser> getMemberList() {
        return this.members;
    }

    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public List<ALEipGroup> getFacilitiyGroupList() {
        return this.facilitiyGroups;
    }

    public boolean isMatch(long id) {
        return this.userid == (int)id;
    }

    public int getMax() {
        return this.max - 1;
    }

    public boolean isHasspan() {
        return this.is_hasspan;
    }

    public String getMyGroupURI() {
        return this.myGroupURI;
    }

    public List<ScheduleOnedayResultData> getTermResultDataList(long id) {
        return this.termmap.get((int)id);
    }

    public List<ScheduleToDoResultData> getToDoResultDataList(long id) {
        return this.todomap.get((int)id);
    }

    @Override
    public void setPortletId(String id) {
        this.portletId = id;
    }

    public List<FacilityResultData> getFacilityList() {
        return this.facilityList;
    }

    public List<ScheduleOnedayResultData> getFacilityScheduleList(long id) {
        Integer fid = (int)id;
        return this.facilitymap.get(fid).getSchedule();
    }

    @Override
    public String getViewDateText() {
        return ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_DATE_FORMAT_NOSPACE", (Object[])new Object[]{this.getViewDate().getYear(), this.getViewDate().getMonth(), this.getViewDate().getDay()});
    }

    public int[] getFacilityRows(long id) {
        Integer fid = (int)id;
        return this.facilitymap.get(fid).getRows();
    }

    public List<ScheduleOnedayResultData> getFacilityDuplicateScheduleList(long id) {
        Integer fid = (int)id;
        return this.facilitymap.get(fid).getDuplicateSchedule();
    }

    public int getFacilityDuplicateScheduleListRowCount(long id) {
        Integer fid = (int)id;
        return this.facilitymap.get(fid).getDuplicateScheduleRowCount();
    }

    @Override
    public String getAclPortletFeature() {
        return "schedule_self";
    }

    @Override
    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }

    public boolean hasAuthorityFacilityInsert() {
        return this.hasAuthorityFacilityInsert;
    }

    private TurbineGroup getGroup(String filter) {
        Expression exp1 = ExpressionFactory.matchExp((String)"groupName", (Object)filter);
        SelectQuery query = Database.query(TurbineGroup.class);
        query.setQualifier(exp1);
        List list = query.fetchList();
        if (list.isEmpty()) {
            return null;
        }
        return (TurbineGroup)list.get(0);
    }

    public TurbineGroup getTargetGroupName() {
        return this.target_group_name;
    }
}

