/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.ScheduleDetailResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleTooltipSelectData
extends ALAbstractSelectData<EipTSchedule, EipTSchedule> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleTooltipSelectData.class.getName());
    private List<ALEipUser> members;
    private Map<Integer, String> statusList;
    private int userid;
    private String type;
    private int loginuserid;
    private ALDateTimeField view_date;
    private List<FacilityResultData> facilities;
    private boolean hasAuthorityOtherEdit = false;
    private boolean hasAuthorityOtherDelete = false;
    private boolean hasAuthoritySelfEdit = false;
    private boolean hasAuthoritySelfDelete = false;
    private String aclPortletFeature;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.view_date = new ALDateTimeField("yyyy-MM-dd");
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_date")) {
            String tmpViewDate = rundata.getParameters().getString("view_date");
            this.view_date.setValue(tmpViewDate);
            if (!this.view_date.validate(new ArrayList())) {
                logger.debug((Object)"[ScheduleSelectData] Parameter cannot validate");
                ALEipUtils.redirectPageNotFound((RunData)rundata);
                return;
            }
        }
        this.loginuserid = ALEipUtils.getUserId((RunData)rundata);
        this.statusList = new HashMap<Integer, String>();
        if (rundata.getParameters().containsKey((Object)"userid")) {
            String tmpid = rundata.getParameters().getString("userid");
            if (tmpid != null && tmpid.startsWith("f")) {
                this.userid = Integer.parseInt(tmpid.substring("f".length(), tmpid.length()));
                this.type = "F";
            } else {
                this.userid = rundata.getParameters().getInt("userid");
                this.type = "U";
            }
        } else if (rundata.getParameters().containsKey((Object)"facilityid")) {
            this.userid = Integer.parseInt(rundata.getParameters().getString("facilityid"));
            this.type = "F";
        } else {
            this.userid = this.loginuserid;
            this.type = "U";
        }
        int scheduleId = Integer.valueOf(rundata.getParameters().getString("scheduleid"));
        this.aclPortletFeature = !ScheduleUtils.hasRelation(rundata, scheduleId) ? "schedule_other" : "schedule_self";
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthorityOtherEdit = aclhandler.hasAuthority(this.loginuserid, "schedule_other", 8);
        this.hasAuthorityOtherDelete = aclhandler.hasAuthority(this.loginuserid, "schedule_other", 16);
        this.hasAuthoritySelfEdit = aclhandler.hasAuthority(this.loginuserid, "schedule_self", 8);
        this.hasAuthoritySelfDelete = aclhandler.hasAuthority(this.loginuserid, "schedule_self", 16);
    }

    protected ResultList<EipTSchedule> selectList(RunData rundata, Context context) {
        return null;
    }

    protected EipTSchedule selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return ScheduleUtils.getEipTScheduleDetailForTooltip(rundata, context, this.type);
    }

    protected Object getResultData(EipTSchedule obj) {
        return null;
    }

    protected Object getResultDataDetail(EipTSchedule record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleDetailResultData rd = new ScheduleDetailResultData();
        rd.initField();
        try {
            SelectQuery schedulequery = Database.query(EipTSchedule.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)record.getScheduleId());
            Expression exp2 = ExpressionFactory.matchExp((String)"startDate", (Object)this.view_date.getValue());
            schedulequery.setQualifier(exp1);
            schedulequery.andQualifier(exp2);
            ArrayList<Integer> scheduleList = new ArrayList<Integer>();
            List dummyScheduleList = schedulequery.fetchList();
            scheduleList.add(record.getScheduleId());
            for (EipTSchedule dummy : dummyScheduleList) {
                scheduleList.add(dummy.getScheduleId());
            }
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.inExp((String)"scheduleId", scheduleList);
            mapquery.setQualifier(mapexp1);
            mapquery.orderAscending("scheduleId");
            List list = mapquery.fetchList();
            ArrayList<Integer> users = new ArrayList<Integer>();
            ArrayList<Integer> facilityIds = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)list.get(i);
                if ("U".equals(map.getType())) {
                    this.statusList.put(map.getUserId(), map.getStatus());
                    if (map.getUserId() == this.userid) {
                        rd.setTmpreserve("T".equals(map.getStatus()));
                        rd.setConfirm("C".equals(map.getStatus()));
                    }
                    if (!"R".equals(map.getStatus()) && !"D".equals(map.getStatus())) {
                        users.add(map.getUserId());
                    }
                    if (this.userid != map.getUserId()) continue;
                    EipTCommonCategory category = map.getEipTCommonCategory();
                    if (category == null) {
                        rd.setCommonCategoryName(null);
                        continue;
                    }
                    rd.setCommonCategoryName(category.getName());
                    continue;
                }
                facilityIds.add(map.getUserId());
            }
            if (users.isEmpty()) {
                users.add(-1);
            }
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            query.setQualifier(exp);
            this.members = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
            if (facilityIds.size() > 0) {
                SelectQuery fquery = Database.query(EipMFacility.class);
                Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIds);
                fquery.setQualifier(fexp);
                this.facilities = FacilitiesUtils.getFacilitiesFromSelectQuery((SelectQuery)fquery);
            }
            if ("F".equals(this.type)) {
                ALEipUser facilityuser = new ALEipUser();
                facilityuser.initField();
                facilityuser.setUserId(this.userid);
                facilityuser.setName("");
                facilityuser.setAliasName("", this.getFacilityName(this.facilities, this.userid));
                rd.setUser(facilityuser);
            } else {
                rd.setUser(ALEipUtils.getALEipUser((int)this.userid));
            }
            rd.setType(this.type);
            rd.setStartDate(record.getStartDate());
            rd.setOwner(record.getOwnerId() == this.loginuserid);
            rd.setEndDate(record.getEndDate());
            rd.setName(record.getName());
            rd.setScheduleId(record.getScheduleId());
            rd.setPlace(record.getPlace());
            rd.setNote(record.getNote());
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setEditFlag("T".equals(record.getEditFlag()));
            String ptn = record.getRepeatPattern();
            int count = 0;
            boolean is_repeat = true;
            rd.setRepeat(true);
            if (ptn.charAt(0) == 'D') {
                rd.addText(ALLocalizationUtils.getl10n((String)"SCHEDULE_EVERY_DAY"));
                count = 1;
            } else if (ptn.charAt(0) == 'W') {
                rd.addText(new StringBuffer().append(ALLocalizationUtils.getl10n((String)"SCHEDULE_EVERY_WEEK_SPACE")).append(ptn.charAt(1) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_SUNDAY") : "").append(ptn.charAt(2) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_MONDAY") : "").append(ptn.charAt(3) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_TUSEDAY") : "").append(ptn.charAt(4) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_WEDNESDAY") : "").append(ptn.charAt(5) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_THURSDAY") : "").append(ptn.charAt(6) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_FRIDAY") : "").append(ptn.charAt(7) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_SATURDAY") : "").append(ALLocalizationUtils.getl10n((String)"SCHEDULE_A_DAY_OF_THE_WEEK")).toString());
                count = 8;
            } else if (ptn.charAt(0) == 'M') {
                rd.addText(new StringBuffer().append(ALLocalizationUtils.getl10n((String)"SCHEDULE_EVERY_MONTH_SPACE")).append(Integer.parseInt(ptn.substring(1, 3))).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_DAY")).toString());
                count = 3;
            } else if (ptn.charAt(0) == 'S') {
                rd.setSpan(true);
                rd.setRepeat(false);
                is_repeat = false;
            } else {
                rd.setRepeat(false);
                is_repeat = false;
            }
            if (is_repeat) {
                if (ptn.charAt(count) == 'N') {
                    rd.setLimit(false);
                } else {
                    rd.setLimit(true);
                    rd.addText(new StringBuffer().append(" \uff08").append(rd.getStartDate().getYear()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_YEAR")).append(rd.getStartDate().getMonth()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_MONTH")).append(rd.getStartDate().getDay()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_UNTIL_DAY")).append(rd.getEndDate().getYear()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_YEAR")).append(rd.getEndDate().getMonth()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_MONTH")).append(rd.getEndDate().getDay()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_FROM_DAY")).toString());
                }
            }
            rd.setCreateUser(ALEipUtils.getALEipUser((int)record.getCreateUserId()));
            rd.setUpdateUser(ALEipUtils.getALEipUser((int)record.getUpdateUserId()));
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            rd.setLoginuser(this.loginuserid == this.userid);
        }
        catch (RuntimeException e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    private String getFacilityName(List<FacilityResultData> list, int id) {
        FacilityResultData rd = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            rd = list.get(i);
            if (rd.getFacilityId().getValue() != (long)id) continue;
            return rd.getFacilityName().getValue();
        }
        return "";
    }

    public List<ALEipUser> getMemberList() {
        return this.members;
    }

    public String getStatus(long id) {
        return this.statusList.get((int)id);
    }

    public ALDateTimeField getViewDate() {
        return this.view_date;
    }

    public List<FacilityResultData> getFacilityList() {
        return this.facilities;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean hasAuthorityOtherEdit() {
        return this.hasAuthorityOtherEdit;
    }

    public boolean hasAuthorityOtherDelete() {
        return this.hasAuthorityOtherDelete;
    }

    public boolean hasAuthoritySelfEdit() {
        return this.hasAuthoritySelfEdit;
    }

    public boolean hasAuthoritySelfDelete() {
        return this.hasAuthoritySelfDelete;
    }
}

