/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule.daemon;

import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.CellScheduleResultData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.daemonfactory.AipoDaemonFactoryService;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.util.ALServletUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonConfig;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.servlet.TurbineServlet;

public class RemainderScheduleDaemon
implements Daemon {
    private int status = 1;
    private int result = 0;
    private DaemonConfig config = null;
    private DaemonEntry entry = null;
    private boolean enable_run = false;
    private int send_time_hour = 15;
    private int send_time_minutes = 0;
    private ALDateTimeField viewDate;
    private String scheme = null;
    private int port = 80;
    private String realpath = "";
    private String localurl = "";
    private boolean enableAsp = false;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)RemainderScheduleDaemon.class.getName());

    public void run() {
        if (!this.enable_run) {
            this.enable_run = true;
            return;
        }
        try {
            this.setResult(3);
            this.doViewList();
            this.doCheck();
            this.setResult(1);
        }
        catch (Exception e) {
            this.setResult(2);
            logger.error((Object)"RemainderScheduleDaemon", (Throwable)e);
        }
    }

    private boolean doCheck() {
        boolean res = false;
        Calendar cal = Calendar.getInstance();
        Calendar cal_now = Calendar.getInstance();
        long now_millis = cal.getTimeInMillis();
        cal.set(11, this.send_time_hour);
        cal.set(12, this.send_time_minutes);
        if (cal_now.getTimeInMillis() >= cal.getTimeInMillis()) {
            cal.add(5, 1);
        }
        cal.set(13, 0);
        cal.set(14, 0);
        long next_millis = cal.getTimeInMillis();
        long interval = (next_millis - now_millis) / 1000L;
        this.entry = new DaemonEntry(this.entry.getName(), interval, this.entry.getClassname(), this.entry.onStartup());
        return res;
    }

    private void doViewList() throws Exception {
        this.initList();
        Object obj = null;
        List<ScheduleToDoResultData> todolist = null;
        ALEipUserAddr useraddr = null;
        String[] to = null;
        String msg = "";
        List<ALEipUserAddr> useraddrs = this.getAllUserAddrList();
        int useraddrs_size = useraddrs.size();
        for (int j = 0; j < useraddrs_size; ++j) {
            try {
                List<VEipTScheduleList> aList;
                useraddr = useraddrs.get(j);
                to = useraddr.getAddrs();
                if (to == null || (aList = this.selectList(useraddr.getUserId())) == null) continue;
                ArrayList<Object> list = new ArrayList<Object>();
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    obj = this.getResultData(aList.get(i));
                    if (obj == null) continue;
                    list.add(obj);
                }
                todolist = this.getToDoList(useraddr.getUserId());
                msg = this.getSendMessage(useraddr, list, todolist);
                ArrayList<ALEipUserAddr> destMemberList = new ArrayList<ALEipUserAddr>();
                destMemberList.add(useraddr);
                String orgId = Database.getDomainName();
                String subject = "[" + ALOrgUtilsService.getAlias() + "]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr destMember : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    message.setPcSubject(subject);
                    message.setCellularSubject(subject);
                    message.setPcBody(msg);
                    message.setCellularBody(msg);
                    messageList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, 1, messageList, ALMailUtils.getSendDestType((int)24)));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"RemainderScheduleDaemon", (Throwable)e);
            }
        }
    }

    private void initList() {
        this.viewDate = new ALDateTimeField("yyyy-MM-dd");
        this.viewDate.setNotNull(true);
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        this.viewDate.setValue(cal.getTime());
    }

    private List<ALEipUserAddr> getAllUserAddrList() {
        SelectQuery query = Database.query(TurbineUser.class);
        query.select("USER_ID");
        query.select("EMAIL");
        query.select("CELLULAR_MAIL");
        Expression exp1 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        Expression exp2 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
        Expression exp3 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
        Expression exp4 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        query.andQualifier(exp4);
        List userids = query.fetchList();
        if (userids.size() == 0) {
            return null;
        }
        ALEipUserAddr useraddr = null;
        ArrayList<ALEipUserAddr> list = new ArrayList<ALEipUserAddr>();
        int size = userids.size();
        for (int i = 0; i < size; ++i) {
            TurbineUser record = (TurbineUser)userids.get(i);
            useraddr = new ALEipUserAddr();
            useraddr.setUserId(record.getUserId());
            useraddr.setPcMailAddr(record.getEmail());
            useraddr.setCellMailAddr(record.getCellularMail());
            list.add(useraddr);
        }
        return list;
    }

    private List<VEipTScheduleList> selectList(Integer userid) {
        VEipTScheduleList record;
        int i;
        List resultBaseList = this.getSelectQuery(userid).fetchList();
        List<VEipTScheduleList> resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
        ArrayList<VEipTScheduleList> list = new ArrayList<VEipTScheduleList>();
        ArrayList<VEipTScheduleList> delList = new ArrayList<VEipTScheduleList>();
        int delSize = 0;
        int resultSize = resultList.size();
        int size = 0;
        boolean canAdd = true;
        for (i = 0; i < resultSize; ++i) {
            record = resultList.get(i);
            delList.clear();
            canAdd = true;
            size = list.size();
            for (int j = 0; j < size; ++j) {
                VEipTScheduleList record2 = (VEipTScheduleList)list.get(j);
                if (!record.getRepeatPattern().equals("N") && "D".equals(record2.getStatus()) && record.getScheduleId().intValue() == record2.getParentId().intValue()) {
                    canAdd = false;
                    break;
                }
                if (record2.getRepeatPattern().equals("N") || !"D".equals(record.getStatus()) || record2.getScheduleId().intValue() != record.getParentId().intValue()) continue;
                if (!delList.contains(record2)) {
                    delList.add(record2);
                }
                canAdd = true;
            }
            delSize = delList.size();
            for (int k = 0; k < delSize; ++k) {
                list.remove(delList.get(k));
            }
            if (!canAdd) continue;
            list.add(record);
        }
        delList.clear();
        size = list.size();
        for (i = 0; i < size; ++i) {
            record = (VEipTScheduleList)list.get(i);
            if (!"D".equals(record.getStatus())) continue;
            delList.add(record);
        }
        delSize = delList.size();
        for (i = 0; i < delSize; ++i) {
            list.remove(delList.get(i));
        }
        Collections.sort(list, new Comparator<VEipTScheduleList>(){

            @Override
            public int compare(VEipTScheduleList a, VEipTScheduleList b) {
                Calendar cal = Calendar.getInstance();
                Calendar cal2 = Calendar.getInstance();
                if (a.getRepeatPattern().equals("S")) {
                    if (!b.getRepeatPattern().equals("S")) {
                        return -1;
                    }
                } else if (b.getRepeatPattern().equals("S")) {
                    return 1;
                }
                cal.setTime(a.getStartDate());
                cal.set(0, 0, 0);
                cal2.setTime(b.getStartDate());
                cal2.set(0, 0, 0);
                if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                    return cal.getTime().compareTo(cal2.getTime());
                }
                cal.setTime(a.getEndDate());
                cal.set(0, 0, 0);
                cal2.setTime(b.getEndDate());
                cal2.set(0, 0, 0);
                return cal.getTime().compareTo(cal2.getTime());
            }
        });
        return list;
    }

    protected SelectQuery<VEipTScheduleList> getSelectQuery(Integer userid) {
        SelectQuery query = Database.query(VEipTScheduleList.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        query.andQualifier(exp2);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.viewDate.getValue());
        cal.add(5, 1);
        ALCellDateTimeField field = new ALCellDateTimeField();
        field.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessExp((String)"startDate", (Object)field.getValue());
        Expression exp13 = ExpressionFactory.matchExp((String)"repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.matchExp((String)"repeatPattern", (Object)"S");
        Calendar date = Calendar.getInstance();
        date.setTime(this.viewDate.getValue());
        int weekindex = date.get(6);
        String token = null;
        StringBuffer sb = new StringBuffer();
        sb.append("W");
        for (int i = 0; i < 7; ++i) {
            token = i == weekindex ? "1" : "_";
            sb.append(token);
        }
        Expression exp21 = ExpressionFactory.likeExp((String)"repeatPattern", (Object)(sb.toString() + "L"));
        Expression exp22 = ExpressionFactory.likeExp((String)"repeatPattern", (Object)(sb.toString() + "N"));
        Expression exp23 = ExpressionFactory.matchExp((String)"repeatPattern", (Object)"DN");
        Expression exp31 = ExpressionFactory.matchExp((String)"repeatPattern", (Object)"DL");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        sdf.setTimeZone(TimeZone.getDefault());
        String dayStr = sdf.format(date.getTime());
        Expression exp24 = ExpressionFactory.likeExp((String)"repeatPattern", (Object)("M" + dayStr + "L"));
        Expression exp25 = ExpressionFactory.likeExp((String)"repeatPattern", (Object)("M" + dayStr + "N"));
        query.andQualifier(exp11.andExp(exp12).andExp(exp13.orExp(exp14).orExp(exp21).orExp(exp31).orExp(exp24)).orExp(exp22.orExp(exp23).orExp(exp25)));
        ArrayList<Ordering> orders = new ArrayList<Ordering>();
        orders.add(new Ordering("startDate", true));
        orders.add(new Ordering("endDate", true));
        query.getQuery().addOrderings(orders);
        return query;
    }

    protected Object getResultData(Object obj) {
        CellScheduleResultData rd = new CellScheduleResultData();
        CellScheduleResultData rd2 = new CellScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            VEipTScheduleList record = (VEipTScheduleList)obj;
            if ("R".equals(record.getStatus())) {
                return null;
            }
            if (!ScheduleUtils.isView(this.viewDate, record.getRepeatPattern(), record.getStartDate(), record.getEndDate())) {
                return null;
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setName(record.getName());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setPattern(record.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                rd.setSpan(true);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.viewDate, rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    private String getSendMessage(ALEipUserAddr useraddr, List<Object> schelist, List<ScheduleToDoResultData> todolist) {
        int i;
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer();
        body.append("--- ").append(this.viewDate.getYear()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_YEAR")).append(this.viewDate.getMonth()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_MONTH")).append(this.viewDate.getDay()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_DAY")).append(" ---").append(CR).append(CR);
        body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_TITLE_SUB")).append(CR);
        if (schelist != null && schelist.size() > 0) {
            CellScheduleResultData rd = null;
            int size = schelist.size();
            for (i = 0; i < size; ++i) {
                rd = (CellScheduleResultData)schelist.get(i);
                if (rd.isSpan()) {
                    body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_TERM"));
                } else {
                    body.append("\u30fb").append(rd.getDate()).append("  ");
                }
                body.append(rd.getName());
                if (!rd.isPublic()) {
                    body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_CLOSE_PUBLIC"));
                }
                if (rd.isDuplicate()) {
                    body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_DUPLICATE"));
                }
                if (rd.isRepeat()) {
                    body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_REPEAT"));
                }
                if (rd.isTmpreserve()) {
                    body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_TEMP"));
                }
                body.append(CR);
            }
        } else {
            body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_SCHEDULE")).append(CR);
        }
        body.append(CR);
        body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_TODO")).append(CR);
        if (todolist != null && todolist.size() > 0) {
            ScheduleToDoResultData todord = null;
            int todosize = todolist.size();
            for (i = 0; i < todosize; ++i) {
                todord = todolist.get(i);
                body.append("\u30fb").append(todord.getTodoName()).append(CR);
            }
        } else {
            body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_NO_TODO")).append(CR);
        }
        body.append(CR);
        body.append("[").append(ALOrgUtilsService.getAlias()).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_ACCESS_TO")).append(CR);
        String globalurl = this.getCellularUrl(useraddr);
        if (globalurl != null && !globalurl.equals("")) {
            body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_OUTSIDE_OFFICE")).append(CR);
            body.append("\u3000").append(globalurl).append(CR);
        }
        if (this.localurl != null && !"".equals(this.localurl)) {
            body.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_INSIDE_OFFICE")).append(CR);
            body.append("\u3000").append(this.localurl).append(CR).append(CR);
            body.append("---------------------");
        }
        return body.toString();
    }

    private void loadAipoUrls() {
        EipMCompany record = ALEipUtils.getEipMCompany((String)"1");
        try {
            Integer port_internal;
            Enumeration<NetworkInterface> enuIfs;
            String ipaddress = record.getIpaddressInternal();
            if ((null == ipaddress || "".equals(ipaddress)) && null != (enuIfs = NetworkInterface.getNetworkInterfaces())) {
                while (enuIfs.hasMoreElements()) {
                    NetworkInterface ni = enuIfs.nextElement();
                    Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                    while (enuAddrs.hasMoreElements()) {
                        InetAddress in4 = enuAddrs.nextElement();
                        if (in4.isLoopbackAddress()) continue;
                        ipaddress = in4.getHostAddress();
                    }
                }
            }
            if (null == (port_internal = record.getPortInternal())) {
                port_internal = 80;
            }
            this.localurl = ALServletUtils.getAccessUrl((String)ipaddress, (int)port_internal, (boolean)false);
        }
        catch (SocketException e) {
            logger.error((Object)"[RemainderScheduleDaemon]", (Throwable)e);
        }
    }

    private String getCellularUrl(ALEipUserAddr useraddr) {
        ALEipUser eipUser;
        String url = null;
        try {
            eipUser = ALEipUtils.getALEipUser((int)useraddr.getUserId());
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return "";
        }
        String key = eipUser.getName().getValue() + "_" + ALCellularUtils.getCheckValueForCellLogin((String)eipUser.getName().getValue(), (String)eipUser.getUserId().toString());
        EipMCompany record = ALEipUtils.getEipMCompany((String)"1");
        String domain = ALServletUtils.getAccessUrl((String)record.getIpaddress(), (int)record.getPort(), (boolean)true);
        url = domain != null && domain.length() > 0 ? domain + "?key=" + key : "";
        return url;
    }

    private List<ScheduleToDoResultData> getToDoList(Integer userid) {
        ArrayList<ScheduleToDoResultData> todoList = new ArrayList<ScheduleToDoResultData>();
        SelectQuery<EipTTodo> query = this.getSelectQueryForTodo(userid);
        List todos = query.fetchList();
        int todosize = todos.size();
        for (int i = 0; i < todosize; ++i) {
            EipTTodo record = (EipTTodo)todos.get(i);
            ScheduleToDoResultData rd = new ScheduleToDoResultData();
            rd.initField();
            rd.setTodoName(record.getTodoName());
            todoList.add(rd);
        }
        return todoList;
    }

    private SelectQuery<EipTTodo> getSelectQueryForTodo(Integer userid) {
        SelectQuery query = Database.query(EipTTodo.class);
        query.select("TODO_NAME");
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)userid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    private void error(Throwable t, String message) {
        this.setResult(2);
        logger.error((Object)message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DaemonConfig config, DaemonEntry entry) {
        this.enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        if (!this.enableAsp) {
            EipMCompany record = ALEipUtils.getEipMCompany((String)"1");
            Integer port_internal = record.getPortInternal();
            if (null == port_internal) {
                port_internal = 80;
            }
            this.port = port_internal;
            this.loadAipoUrls();
        }
        this.config = config;
        AipoDaemonFactoryService aipoDaemonService = (AipoDaemonFactoryService)TurbineServices.getInstance().getService("DaemonFactory");
        ServletConfig servlet_config = aipoDaemonService.getServletConfig();
        this.scheme = TurbineServlet.getServerScheme();
        this.realpath = servlet_config.getServletContext().getRealPath("/");
        Calendar cal = Calendar.getInstance();
        Calendar cal_now = Calendar.getInstance();
        long now_millis = cal.getTimeInMillis();
        FileInputStream input = null;
        try {
            String timestr = ALMailUtils.getNotifyTime();
            this.send_time_hour = Integer.valueOf(timestr.substring(0, 2));
            this.send_time_minutes = Integer.valueOf(timestr.substring(3, 5));
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iex) {
                    logger.error((Object)"schedule", (Throwable)iex);
                }
            }
        }
        cal.set(11, this.send_time_hour);
        cal.set(12, this.send_time_minutes);
        if (cal_now.getTimeInMillis() >= cal.getTimeInMillis()) {
            cal.add(5, 1);
        }
        cal.set(13, 0);
        cal.set(14, 0);
        long next_millis = cal.getTimeInMillis();
        long interval = (next_millis - now_millis) / 1000L;
        this.entry = new DaemonEntry(entry.getName(), interval, entry.getClassname(), entry.onStartup());
        this.enable_run = false;
    }

    public DaemonConfig getDaemonConfig() {
        return this.config;
    }

    public DaemonEntry getDaemonEntry() {
        return this.entry;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMessage() {
        return null;
    }
}

