/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCompanyMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookCompanyMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            int empty_id = AddressBookUtils.getDummyEipMAddressbookCompany(rundata, context).getCompanyId();
            SelectQuery addrquery = Database.query(EipMAddressbook.class);
            Expression addrexp = ExpressionFactory.inDbExp((String)"eipMAddressbookCompany.COMPANY_ID", values);
            addrquery.setQualifier(addrexp);
            List addresses = addrquery.fetchList();
            if (addresses != null && addresses.size() > 0) {
                EipMAddressbook addressbook = null;
                EipMAddressbookCompany company = (EipMAddressbookCompany)Database.get(EipMAddressbookCompany.class, (Object)empty_id);
                int addrsize = addresses.size();
                for (int i = 0; i < addrsize; ++i) {
                    addressbook = (EipMAddressbook)addresses.get(i);
                    addressbook.setEipMAddressbookCompany(company);
                }
            }
            SelectQuery query = Database.query(EipMAddressbookCompany.class);
            Expression exp = ExpressionFactory.inDbExp((String)"COMPANY_ID", values);
            query.setQualifier(exp);
            List groups = query.fetchList();
            int grouplistsize = groups.size();
            for (int i = 0; i < grouplistsize; ++i) {
                EipMAddressbookCompany group = (EipMAddressbookCompany)groups.get(i);
                Integer entityId = group.getCompanyId();
                String groupName = group.getCompanyName();
                Database.delete((Persistent)group);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 161, groupName);
            }
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookCompanyMultiDelete.action", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "addressbook_company";
    }
}

