/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.addressbook.AbstractAddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCorpFilterdSelectData
extends AbstractAddressBookFilterdSelectData<TurbineUser, ALBaseUser> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookFilterdSelectData.class.getName());
    private List<ALEipGroup> myGroupList = null;
    private List<AddressBookGroupResultData> groupList;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        super.init(action, rundata, context);
    }

    public void loadMygroupList(RunData rundata, Context context) {
        try {
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList<ALEipGroup>();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add((ALEipGroup)myGroups.get(i));
            }
            this.groupList = AddressBookUtils.getMyGroups(rundata);
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpFilterdSelectData.loadMygroupList", (Throwable)ex);
        }
    }

    protected ResultList<TurbineUser> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<TurbineUser> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpFilterdSelectData.selectList", (Throwable)ex);
            return null;
        }
    }

    protected ALBaseUser selectDetail(RunData rundata, Context context) {
        try {
            String userId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (userId == null || Integer.valueOf(userId) == null) {
                return null;
            }
            return ALEipUtils.getBaseUser((Integer)Integer.valueOf(userId));
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpFilterdSelectData.selectDetail", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(TurbineUser record) {
        try {
            return AddressBookUtils.getCorpResultData(record, this.getStrLength());
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpFilterdSelectData.getResultData", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(ALBaseUser record) {
        try {
            AddressBookResultData rd = new AddressBookResultData();
            rd.initField();
            int userId = Integer.valueOf(record.getUserId());
            rd.setAddressId(userId);
            rd.setName(new StringBuffer().append(record.getLastName()).append(' ').append(record.getFirstName()).toString());
            rd.setNameKana(new StringBuffer().append(record.getLastNameKana()).append(' ').append(record.getFirstNameKana()).toString());
            rd.setEmail(record.getEmail());
            rd.setTelephone(record.getOutTelephone());
            rd.setInTelephone(record.getInTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPostList(AddressBookUtils.getPostBeanList(userId));
            if (record.getPositionId() > 0) {
                rd.setPositionName(ALCommonUtils.compressString((String)ALEipUtils.getPositionName((int)record.getPositionId()), (int)this.getStrLength()));
            }
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreated(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getModified(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCorpFilterdSelectData.getResultDataDetail", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("corp_group", "turbineUserGroupRole.turbineGroup.GROUP_NAME");
        map.putValue("name_kana", "lastNameKana");
        return map;
    }

    private SelectQuery<TurbineUser> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(TurbineUser.class);
        Expression exp11 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.setQualifier(exp11);
        Expression exp21 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
        Expression exp22 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
        Expression exp23 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
        query.andQualifier(exp21.andExp(exp22).andExp(exp23));
        return this.getSelectQueryForIndex(query, rundata, context);
    }

    @Override
    protected String getColumnForIndex() {
        return "lastNameKana";
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public String getAclPortletFeature() {
        return "addressbook_address_inside";
    }

    public List<AddressBookGroupResultData> getGroupList() {
        return this.groupList;
    }
}

