/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.AbstractAddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookFilterdSelectData
extends AbstractAddressBookFilterdSelectData<EipMAddressbook, EipMAddressbook> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookFilterdSelectData.class.getName());
    private List<AddressBookGroupResultData> groupList;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        super.init(action, rundata, context);
    }

    protected ResultList<EipMAddressbook> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipMAddressbook> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFilterdSelectData.selectList", (Throwable)ex);
            return null;
        }
    }

    protected EipMAddressbook selectDetail(RunData rundata, Context context) {
        try {
            return AddressBookUtils.getEipMAddressbook(rundata, context);
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFilterdSelectData.selectDetail", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(EipMAddressbook record) {
        try {
            AddressBookResultData rd = new AddressBookResultData();
            rd.initField();
            rd.setAddressId(record.getAddressId());
            rd.setName(ALCommonUtils.compressString((String)new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString(), (int)this.getStrLength()));
            rd.setNameKana(ALCommonUtils.compressString((String)new StringBuffer().append(record.getLastNameKana()).append(' ').append(record.getFirstNameKana()).toString(), (int)this.getStrLength()));
            EipMAddressbookCompany company = record.getEipMAddressbookCompany();
            if (!"".equals(company.getCompanyName())) {
                rd.setCompanyName(ALCommonUtils.compressString((String)company.getCompanyName(), (int)this.getStrLength()));
                rd.setCompanyId(company.getCompanyId().toString());
                rd.setPostName(ALCommonUtils.compressString((String)company.getPostName(), (int)this.getStrLength()));
                rd.setCompanyNameKana(ALCommonUtils.compressString((String)company.getCompanyNameKana(), (int)this.getStrLength()));
                rd.setPostName(ALCommonUtils.compressString((String)company.getPostName(), (int)this.getStrLength()));
                rd.setZipcode(ALCommonUtils.compressString((String)company.getZipcode(), (int)this.getStrLength()));
                rd.setCompanyAddress(ALCommonUtils.compressString((String)company.getAddress(), (int)this.getStrLength()));
                rd.setCompanyTelephone(ALCommonUtils.compressString((String)company.getTelephone(), (int)this.getStrLength()));
                rd.setCompanyFaxNumber(ALCommonUtils.compressString((String)company.getFaxNumber(), (int)this.getStrLength()));
                rd.setCompanyUrl(ALCommonUtils.compressString((String)company.getUrl(), (int)this.getStrLength()));
            }
            rd.setPositionName(ALCommonUtils.compressString((String)record.getPositionName(), (int)this.getStrLength()));
            rd.setEmail(record.getEmail());
            rd.setTelephone(record.getTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPublicFlag(record.getPublicFlag());
            rd.setNote(record.getNote());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFilterdSelectData.getResultData", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipMAddressbook record) {
        try {
            String updatedUserName;
            AddressBookResultData rd = new AddressBookResultData();
            rd.initField();
            ALEipUser createdUser = ALEipUtils.getALEipUser((int)record.getCreateUserId());
            String createdUserName = createdUser.getAliasName().getValue();
            rd.setCreatedUser(createdUserName);
            if (record.getCreateUserId().equals(record.getUpdateUserId())) {
                updatedUserName = createdUserName;
            } else {
                ALEipUser updatedUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
                updatedUserName = updatedUser.getAliasName().getValue();
            }
            rd.setUpdatedUser(updatedUserName);
            int addressId = record.getAddressId();
            rd.setAddressId(addressId);
            rd.setName(new StringBuffer().append(record.getLastName()).append(' ').append(record.getFirstName()).toString());
            rd.setNameKana(new StringBuffer().append(record.getLastNameKana()).append(' ').append(record.getFirstNameKana()).toString());
            rd.setEmail(record.getEmail());
            rd.setTelephone(record.getTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPositionName(record.getPositionName());
            rd.setNote(record.getNote());
            rd.setPublicFlag(record.getPublicFlag());
            EipMAddressbookCompany company = record.getEipMAddressbookCompany();
            if (!"".equals(company.getCompanyName())) {
                rd.setCompanyName(company.getCompanyName());
                rd.setCompanyNameKana(company.getCompanyNameKana());
                rd.setPostName(company.getPostName());
                rd.setZipcode(company.getZipcode());
                rd.setCompanyAddress(company.getAddress());
                rd.setCompanyTelephone(company.getTelephone());
                rd.setCompanyFaxNumber(company.getFaxNumber());
                rd.setCompanyUrl(company.getUrl());
            }
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setCreatedUserId(record.getCreateUserId());
            rd.setUpdatedUserId(record.getUpdateUserId());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFilterdSelectData.getResultDataDetail", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "eipTAddressbookGroupMap.eipTAddressGroup.GROUP_ID");
        map.putValue("name_kana", "lastNameKana");
        map.putValue("company_name_kana", "eipMAddressbookCompany.companyNameKana");
        return map;
    }

    protected SelectQuery<EipMAddressbook> getSelectQuery(RunData rundata, Context context) {
        String word = this.searchWord.toString();
        String transWord = ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.searchWord.toString()));
        transWord = transWord.replace("\u3000", " ");
        String[] transWords = transWord.split(" ");
        SelectQuery query = Database.query(EipMAddressbook.class);
        for (int i = 0; i < transWords.length; ++i) {
            Expression exp01 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp02 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression exp03 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            query.setQualifier(exp01.orExp(exp02.andExp(exp03)));
            Expression exp11 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + word + "%"));
            Expression exp12 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + word + "%"));
            Expression exp13 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + word + "%"));
            Expression exp14 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + word + "%"));
            Expression exp15 = ExpressionFactory.likeExp((String)"email", (Object)("%" + word + "%"));
            Expression exp16 = ExpressionFactory.likeExp((String)"telephone", (Object)("%" + word + "%"));
            Expression exp17 = ExpressionFactory.likeExp((String)"cellularPhone", (Object)("%" + word + "%"));
            Expression exp18 = ExpressionFactory.likeExp((String)"cellularMail", (Object)("%" + word + "%"));
            Expression exp19 = ExpressionFactory.likeExp((String)"note", (Object)("%" + word + "%"));
            Expression exp21 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyName", (Object)("%" + word + "%"));
            Expression exp22 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyNameKana", (Object)("%" + word + "%"));
            Expression exp23 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.telephone", (Object)("%" + word + "%"));
            Expression exp31 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + transWords[i] + "%"));
            Expression exp32 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + transWords[i] + "%"));
            Expression exp33 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + transWords[i] + "%"));
            Expression exp34 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + transWords[i] + "%"));
            Expression exp35 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyName", (Object)("%" + transWords[i] + "%"));
            Expression exp36 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyNameKana", (Object)("%" + transWords[i] + "%"));
            Expression exp37 = ExpressionFactory.likeExp((String)"note", (Object)("%" + transWords[i] + "%"));
            Expression exp41 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp42 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression exp43 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            if (word == null || "".equals(word)) continue;
            query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp17).orExp(exp18).orExp(exp19).orExp(exp21).orExp(exp22).orExp(exp23).orExp(exp31).orExp(exp32).orExp(exp33).orExp(exp34).orExp(exp35).orExp(exp36).orExp(exp37).andExp(exp41.orExp(exp42.andExp(exp43))));
        }
        return this.getSelectQueryForIndex(query, rundata, context);
    }

    @Override
    protected String getColumnForIndex() {
        return "lastNameKana";
    }

    public List<AddressBookGroupResultData> getGroupList() {
        return this.groupList;
    }

    public void loadGroups(RunData rundata, Context context) {
        this.groupList = new ArrayList<AddressBookGroupResultData>();
        try {
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            query.orderAscending("groupName");
            List aList = query.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressGroup record = (EipMAddressGroup)aList.get(i);
                AddressBookGroupResultData rd = new AddressBookGroupResultData();
                rd.initField();
                rd.setGroupId(record.getGroupId().intValue());
                rd.setGroupName(record.getGroupName());
                this.groupList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookFilterdSelectData.loadGroups", (Throwable)ex);
        }
    }

    public String getAclPortletFeature() {
        return "addressbook_address_outside";
    }

    public void setCurrentPage(int page) {
        this.current_page = page;
    }
}

