/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            if (values.size() == 0) {
                return false;
            }
            SelectQuery query = Database.query(EipMAddressbook.class);
            Expression exp = ExpressionFactory.inDbExp((String)"ADDRESS_ID", values);
            query.setQualifier(exp);
            List addresses = query.fetchList();
            for (EipMAddressbook record : addresses) {
                Integer entityId = record.getAddressId();
                StringBuilder name = new StringBuilder();
                name.append(record.getFirstName());
                name.append(" ");
                name.append(record.getLastName());
                Database.delete((Persistent)record);
                SelectQuery query2 = Database.query(EipTAddressbookGroupMap.class);
                Expression exp2 = ExpressionFactory.matchExp((String)"addressId", (Object)entityId);
                query2.setQualifier(exp2);
                List maps = query2.fetchList();
                Database.deleteAll((List)maps);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 161, name.toString());
            }
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookMultiDelete.action", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "addressbook_address_outside";
    }
}

