/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook.util;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.addressbook.AddressBookGroup;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserGroupLiteBean;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookUtils.class.getName());
    public static final String FOLDER_TMP_FOR_ADDRESSBOOK_FILES = JetspeedResources.getString((String)"aipo.tmp.addressbook.directory", (String)"");
    public static final String EMPTY_COMPANY_NAME = "";
    public static final String ADDRESSBOOK_PORTLET_NAME = "AddressBook";

    public static EipMAddressGroup getEipMAddressGroup(RunData rundata, Context context) {
        String groupid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (groupid == null || Integer.valueOf(groupid) == null) {
                logger.debug((Object)"[AddressBook] Group ID...");
                return null;
            }
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(groupid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List groups = query.fetchList();
            if (groups == null || groups.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found Group ID...");
                return null;
            }
            return (EipMAddressGroup)groups.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookUtils.getEipMAddressGroup", (Throwable)ex);
            return null;
        }
    }

    public static EipMAddressbookCompany getEipMAddressbookCompany(RunData rundata, Context context) {
        String companyid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (companyid == null || Integer.valueOf(companyid) == null) {
                logger.debug((Object)"[AddressBook] Company ID...");
                return null;
            }
            SelectQuery query = Database.query(EipMAddressbookCompany.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(companyid));
            query.setQualifier(exp);
            List companys = query.fetchList();
            if (companys == null || companys.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found Company ID...");
                return null;
            }
            return (EipMAddressbookCompany)companys.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookUtils.getEipMAddressbookCompany", (Throwable)ex);
            return null;
        }
    }

    public static List<String> getMyGroupNames(RunData rundata, int addressid, int userid) {
        try {
            SelectQuery query = Database.query(EipTAddressbookGroupMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"addressId", (Object)addressid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTAddressGroup.ownerId", (Object)userid);
            query.andQualifier(exp2);
            List groups = query.fetchList();
            ArrayList<String> aList = new ArrayList<String>();
            int size = groups.size();
            for (int i = 0; i < size; ++i) {
                aList.add(((EipTAddressbookGroupMap)groups.get(i)).getEipTAddressGroup().getGroupName());
            }
            return aList;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookUtils.getMyGroupNames", (Throwable)ex);
            return null;
        }
    }

    public static String getMyGroupNamesAsString(RunData rundata, int addressid, int userid) {
        List<String> aList = AddressBookUtils.getMyGroupNames(rundata, addressid, userid);
        int group_size = aList.size();
        StringBuffer groupNames = new StringBuffer();
        for (int i = 0; i < group_size; ++i) {
            groupNames.append(aList.get(i)).append("\u3001");
        }
        if (groupNames.length() == 0) {
            return EMPTY_COMPANY_NAME;
        }
        return groupNames.substring(0, groupNames.length() - 1);
    }

    public static EipMAddressbook getEipMAddressbook(RunData rundata, Context context) {
        String addressid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (addressid == null || Integer.valueOf(addressid) == null) {
                logger.debug((Object)"[AddressBook] Address ID...");
                return null;
            }
            SelectQuery query = Database.query(EipMAddressbook.class);
            Expression exp11 = ExpressionFactory.matchDbExp((String)"ADDRESS_ID", (Object)Integer.valueOf(addressid));
            query.setQualifier(exp11);
            Expression exp21 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp22 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression exp23 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            query.andQualifier(exp21.orExp(exp22.andExp(exp23)));
            List addresses = query.fetchList();
            if (addresses == null || addresses.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found Address ID...");
                return null;
            }
            return (EipMAddressbook)addresses.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookUtils.getEipMAddressbook", (Throwable)ex);
            return null;
        }
    }

    public static EipMAddressbookCompany getDummyEipMAddressbookCompany(RunData rundata, Context context) {
        return (EipMAddressbookCompany)Database.get(EipMAddressbookCompany.class, (Object)1);
    }

    public static Map<Integer, AddressBookGroup> getGroupMap(RunData rundata, Context context) {
        try {
            LinkedHashMap<Integer, AddressBookGroup> groupMap = new LinkedHashMap<Integer, AddressBookGroup>();
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List list = query.fetchList();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressGroup record = (EipMAddressGroup)list.get(i);
                AddressBookGroup group = new AddressBookGroup();
                group.initField();
                group.setGroupId(record.getGroupId());
                group.setGroupName(record.getGroupName());
                groupMap.put(record.getGroupId(), group);
            }
            return groupMap;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookUtils.getGroupMap", (Throwable)ex);
            return null;
        }
    }

    public static List<EipMAddressGroup> getGroups(int uid) {
        logger.debug((Object)"AddressbookUtils getGroups in");
        try {
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)uid);
            query.setQualifier(exp);
            List groups = query.fetchList();
            if (groups == null || groups.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found group ID...");
                return null;
            }
            logger.debug((Object)"AddressbookUtils getGroups out");
            return groups;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookUtils.getGroups", (Throwable)ex);
            return null;
        }
    }

    public static List<ALStringField> getGroupMember(String gid) {
        ArrayList<ALStringField> resultList = new ArrayList<ALStringField>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT ");
        statement.append(" B.last_name, B.first_name, ");
        statement.append(" C.company_name ");
        statement.append("FROM eip_t_addressbook_group_map as A ");
        statement.append("LEFT JOIN eip_m_addressbook as B ");
        statement.append(" on A.ADDRESS_ID = B.ADDRESS_ID ");
        statement.append("LEFT JOIN eip_m_addressbook_company AS C ");
        statement.append(" on B.COMPANY_ID = C.COMPANY_ID ");
        statement.append("WHERE A.GROUP_ID = #bind($gid) ");
        statement.append("ORDER BY C.company_name_kana, C.company_name, B.last_name_kana");
        String query = statement.toString();
        try {
            List list = Database.sql(EipMAddressbook.class, (String)query).param("gid", (Object)Integer.parseInt(gid)).fetchListAsDataRow();
            int recordNum = list.size();
            for (int i = 0; i < recordNum; ++i) {
                DataRow dataRow = (DataRow)list.get(i);
                StringBuffer strBuf = new StringBuffer();
                strBuf.append(Database.getFromDataRow((DataRow)dataRow, (Object)"LAST_NAME")).append(Database.getFromDataRow((DataRow)dataRow, (Object)"FIRST_NAME"));
                String companyName = (String)Database.getFromDataRow((DataRow)dataRow, (Object)"COMPANY_NAME");
                if (companyName != null && companyName.trim().length() > 0) {
                    strBuf.append(" (").append(companyName).append(")");
                }
                ALStringField st = new ALStringField(strBuf.toString());
                resultList.add(st);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressbookUtils.getGroupMember", (Throwable)ex);
        }
        return resultList;
    }

    public static List<AddressBookUserGroupLiteBean> getPostBeanList(int uid) {
        SelectQuery query = Database.query(TurbineUserGroupRole.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"turbineUser", (Object)uid);
        Expression exp2 = ExpressionFactory.greaterExp((String)"turbineGroup", (Object)3);
        Expression exp3 = ExpressionFactory.matchExp((String)"turbineGroup.ownerId", (Object)1);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        List list = query.fetchList();
        if (list == null || list.size() < 0) {
            return null;
        }
        ArrayList<AddressBookUserGroupLiteBean> resultList = new ArrayList<AddressBookUserGroupLiteBean>();
        TurbineUserGroupRole ugr = null;
        TurbineGroup group = null;
        AddressBookUserGroupLiteBean bean = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ugr = (TurbineUserGroupRole)list.get(i);
            group = ugr.getTurbineGroup();
            EipMPost post = group.getEipMPost();
            bean = new AddressBookUserGroupLiteBean();
            bean.initField();
            bean.setGroupId(post.getPostId().intValue());
            bean.setName(post.getPostName());
            resultList.add(bean);
        }
        return resultList;
    }

    public static boolean isSyagai(RunData rundata, Context context) {
        String tabParam = rundata.getParameters().getString("tab");
        String currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null) {
            return currentTab == null || currentTab.trim().length() == 0 || "syagai".equals(currentTab);
        }
        return "syagai".equals(tabParam);
    }

    public static AddressBookResultData getCorpResultData(TurbineUser record, int strLength) {
        AddressBookResultData rd = new AddressBookResultData();
        rd.initField();
        rd.setAddressId(record.getUserId());
        rd.setName(ALCommonUtils.compressString((String)new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString(), (int)strLength));
        if (record.getCompanyId() > 0) {
            rd.setCompanyName(ALCommonUtils.compressString((String)ALEipUtils.getCompanyName((int)record.getCompanyId()), (int)strLength));
        }
        rd.setPostList(AddressBookUtils.compressString(AddressBookUtils.getPostBeanList(record.getUserId()), strLength));
        if (record.getPositionId() > 0) {
            rd.setPositionName(ALCommonUtils.compressString((String)ALEipUtils.getPositionName((int)record.getPositionId()), (int)strLength));
        }
        rd.setEmail(ALCommonUtils.compressString((String)record.getEmail(), (int)strLength));
        rd.setTelephone(record.getOutTelephone());
        rd.setCellularPhone(record.getCellularPhone());
        rd.setCellularMail(record.getCellularMail());
        rd.setInTelephone(record.getInTelephone());
        return rd;
    }

    public static List<AddressBookUserGroupLiteBean> compressString(List<AddressBookUserGroupLiteBean> list, int length) {
        for (AddressBookUserGroupLiteBean bean : list) {
            bean.setName(ALCommonUtils.compressString((String)bean.getName(), (int)length));
        }
        return list;
    }

    public static Expression excludeDefaultCompanyCriteria() {
        Expression exp = ExpressionFactory.noMatchDbExp((String)"COMPANY_ID", (Object)1);
        return exp;
    }

    public static List<AddressBookGroupResultData> getMyGroups(RunData rundata) {
        ArrayList<AddressBookGroupResultData> res = new ArrayList<AddressBookGroupResultData>();
        try {
            SelectQuery query = Database.query(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.orderAscending("groupName");
            query.setQualifier(exp);
            List aList = query.fetchList();
            for (EipMAddressGroup record : aList) {
                AddressBookGroupResultData rd = new AddressBookGroupResultData();
                rd.initField();
                rd.setGroupId(record.getGroupId().longValue());
                rd.setGroupName(record.getGroupName());
                res.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookUtils.getMyGroups", (Throwable)ex);
        }
        return res;
    }
}

