/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities.util;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.facilities.FacilityGroupResultData;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilitiesUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilitiesUtils.class.getName());
    public static final String FACILITIES_PORTLET_NAME = "Facilities";

    public static EipMFacility getEipMFacility(RunData rundata, Context context) {
        String facilityid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (facilityid == null || Integer.valueOf(facilityid) == null) {
                logger.debug((Object)"[Facility] Empty ID...");
                return null;
            }
            EipMFacility facility = (EipMFacility)Database.get(EipMFacility.class, (Object)facilityid);
            return facility;
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return null;
        }
    }

    public static EipMFacilityGroup getEipMFacilityGroup(RunData rundata, Context context) {
        String faclitygroupid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (faclitygroupid == null || Integer.valueOf(faclitygroupid) == null) {
                logger.debug((Object)"[Facility] Empty ID...");
                return null;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)faclitygroupid);
            List facilities = Database.query(EipMFacilityGroup.class, (Expression)exp).fetchList();
            if (facilities == null || facilities.size() == 0) {
                logger.debug((Object)"[Facilities] Not found ID...");
                return null;
            }
            return (EipMFacilityGroup)facilities.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return null;
        }
    }

    public static List<FacilityResultData> getFacilityAllList() {
        ArrayList<FacilityResultData> facilityAllList = new ArrayList<FacilityResultData>();
        try {
            List aList = Database.query(EipMFacility.class).orderAscending("sort").fetchList();
            for (EipMFacility record : aList) {
                FacilityResultData rd = new FacilityResultData();
                rd.initField();
                rd.setFacilityId(record.getFacilityId().longValue());
                rd.setFacilityName(record.getFacilityName());
                facilityAllList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
        }
        return facilityAllList;
    }

    public static List<FacilityResultData> getFacilityList(String groupname) {
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.FACILITY_ID, B.FACILITY_NAME, B.SORT ");
        statement.append("FROM eip_facility_group as A ");
        statement.append("LEFT JOIN eip_m_facility as B ");
        statement.append("  on A.FACILITY_ID = B.FACILITY_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("WHERE C.GROUP_NAME = #bind($groupname) ");
        statement.append("ORDER BY B.SORT");
        String query = statement.toString();
        try {
            List list2 = Database.sql(EipMFacility.class, (String)query).param("groupname", (Object)groupname).fetchList();
            for (EipMFacility record : list2) {
                FacilityResultData frd = new FacilityResultData();
                frd.initField();
                frd.setFacilityId(record.getFacilityId().intValue());
                frd.setFacilityName(record.getFacilityName());
                list.add(frd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static List<FacilityResultData> getFacilityGroupList(Integer groupid) {
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.FACILITY_ID, B.FACILITY_NAME, B.SORT ");
        statement.append("FROM eip_m_facility_group_map as A ");
        statement.append("LEFT JOIN eip_m_facility as B ");
        statement.append("  on A.FACILITY_ID = B.FACILITY_ID ");
        statement.append("LEFT JOIN eip_m_facility_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("WHERE C.GROUP_ID = #bind($groupid) ");
        statement.append("ORDER BY B.SORT");
        String query = statement.toString();
        try {
            List list2 = Database.sql(EipMFacility.class, (String)query).param("groupid", (Object)groupid).fetchList();
            for (EipMFacility record : list2) {
                FacilityResultData frd = new FacilityResultData();
                frd.initField();
                frd.setFacilityId(record.getFacilityId().intValue());
                frd.setFacilityName(record.getFacilityName());
                list.add(frd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static List<FacilityResultData> getFacilityListByGroupId(String groupId) {
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT B.FACILITY_ID, B.FACILITY_NAME, B.SORT ");
        statement.append("FROM eip_m_facility_group_map as A ");
        statement.append("LEFT JOIN eip_m_facility as B on A.FACILITY_ID = B.FACILITY_ID ");
        statement.append("WHERE A.GROUP_ID = #bind($groupId) ");
        statement.append("ORDER BY B.SORT");
        String query = statement.toString();
        try {
            List list2 = Database.sql(EipMFacility.class, (String)query).param("groupId", (Object)Integer.parseInt(groupId)).fetchList();
            for (EipMFacility record : list2) {
                FacilityResultData frd = new FacilityResultData();
                frd.initField();
                frd.setFacilityId(record.getFacilityId().intValue());
                frd.setFacilityName(record.getFacilityName());
                list.add(frd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static List<Integer> getFacilityIds(String groupname) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.FACILITY_ID ");
        statement.append("FROM eip_facility_group as A ");
        statement.append("LEFT JOIN eip_m_facility as B ");
        statement.append("  on A.FACILITY_ID = B.FACILITY_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("WHERE C.GROUP_NAME = #bind($groupname)");
        String query = statement.toString();
        try {
            List list2 = Database.sql(EipMFacility.class, (String)query).param("groupname", (Object)groupname).fetchList();
            for (EipMFacility record : list2) {
                list.add(record.getFacilityId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static List<Integer> getFacilityGroupIds(Integer groupid) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT A.group_id, C.facility_id, C.facility_name ");
        statement.append("FROM eip_m_facility_group AS A ");
        statement.append("INNER JOIN eip_m_facility_group_map as B ");
        statement.append("  ON A.group_id = B.group_id ");
        statement.append("INNER JOIN eip_m_facility as C ");
        statement.append("  ON C.facility_id = B.facility_id ");
        statement.append("WHERE A.group_id = #bind($groupid) ");
        String query = statement.toString();
        try {
            List list2 = Database.sql(EipMFacility.class, (String)query).param("groupid", (Object)groupid).fetchList();
            for (EipMFacility record : list2) {
                list.add(record.getFacilityId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static List<FacilityResultData> getFacilitiesFromSelectQuery(SelectQuery<EipMFacility> query) {
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        try {
            List aList = query.orderAscending("sort").fetchList();
            for (EipMFacility record : aList) {
                FacilityResultData rd = new FacilityResultData();
                rd.initField();
                rd.setFacilityName(record.getFacilityName());
                rd.setFacilityId(record.getFacilityId().longValue());
                rd.setCreateDate(record.getCreateDate());
                rd.setUpdateDate(record.getUpdateDate());
                list.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[Exception]", (Throwable)ex);
        }
        return list;
    }

    public static boolean isContains(List<FacilityResultData> facilityrList, FacilityResultData rd) {
        int size = facilityrList.size();
        long fid = rd.getFacilityId().getValue();
        FacilityResultData facility = null;
        for (int i = 0; i < size; ++i) {
            facility = facilityrList.get(i);
            if (facility.getFacilityId().getValue() != fid) continue;
            return true;
        }
        return false;
    }

    public static List<EipMFacilityGroup> getFacilityGroupListByFacilityId(String facilityid) {
        try {
            SelectQuery query = Database.query(EipMFacilityGroupMap.class);
            query.where(Operations.eq((String)"FacilityId", (Object)Integer.valueOf(facilityid)));
            List maps = query.fetchList();
            ArrayList<Integer> faclityGroupIdList = new ArrayList<Integer>();
            for (EipMFacilityGroupMap map : maps) {
                faclityGroupIdList.add(map.getGroupId());
            }
            if (faclityGroupIdList.size() > 0) {
                SelectQuery fquery = Database.query(EipMFacilityGroup.class);
                Expression exp = ExpressionFactory.inDbExp((String)"GROUP_ID", faclityGroupIdList);
                fquery.setQualifier(exp);
                return fquery.fetchList();
            }
            return null;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return null;
        }
    }

    public static List<FacilityGroupResultData> getFacilityGroupAllList() {
        ArrayList<FacilityGroupResultData> facilityAllList = new ArrayList<FacilityGroupResultData>();
        try {
            List result = Database.query(EipMFacilityGroup.class).orderAscending("groupName").fetchList();
            for (EipMFacilityGroup group : result) {
                FacilityGroupResultData data = new FacilityGroupResultData();
                data.initField();
                data.setGroupId(group.getGroupId().intValue());
                data.setGroupName(group.getGroupName());
                facilityAllList.add(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
        }
        return facilityAllList;
    }

    public static List<EipMFacility> getFacilityListByGroupId(int groupid) {
        try {
            SelectQuery query = Database.query(EipMFacilityGroupMap.class);
            query.where(Operations.eq((String)"GroupId", (Object)groupid));
            List maps = query.fetchList();
            ArrayList<Integer> faclityIdList = new ArrayList<Integer>();
            for (EipMFacilityGroupMap map : maps) {
                faclityIdList.add(map.getFacilityId());
            }
            if (faclityIdList.size() > 0) {
                SelectQuery fquery = Database.query(EipMFacility.class);
                Expression exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", faclityIdList);
                fquery.setQualifier(exp);
                fquery.orderAscending("sort");
                return fquery.fetchList();
            }
            ArrayList<EipMFacility> list = new ArrayList<EipMFacility>();
            return list;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            ArrayList<EipMFacility> list = new ArrayList<EipMFacility>();
            return list;
        }
    }

    public static List<FacilityResultData> getFacilityResultList(List<EipMFacility> result) {
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        for (EipMFacility model : result) {
            list.add(FacilitiesUtils.getFacilityResultData(model));
        }
        return list;
    }

    public static FacilityResultData getFacilityResultData(EipMFacility model) {
        FacilityResultData data = new FacilityResultData();
        data.initField();
        data.setFacilityId(model.getFacilityId().intValue());
        data.setFacilityName(model.getFacilityName());
        data.setNote(model.getNote());
        data.setUpdateDate(model.getUpdateDate());
        data.setCreateDate(model.getCreateDate());
        data.setUserId(model.getUserId().intValue());
        return data;
    }
}

