/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project.util;

import com.aimluck.eip.cayenne.om.portlet.IProjectFile;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;

public class ProjectFile<T extends IProjectFile, M> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectFile.class.getName());
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    public static final String FOLDER_FILEDIR = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.project.categorykey", (String)"");
    private final Class<T> classT;

    public ProjectFile(Class<T> classT) {
        this.classT = classT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FileuploadBean> getFileuploadList(RunData rundata) {
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadBean> fileNameList = new ArrayList<FileuploadBean>();
        FileuploadBean filebean = null;
        int fileid = 0;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            int length = newfileids.size();
            for (int i = 0; i < length; ++i) {
                if (newfileids.get(i) == null || ((String)newfileids.get(i)).equals("")) continue;
                try {
                    fileid = Integer.parseInt((String)newfileids.get(i));
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName(ALLocalizationUtils.getl10n((String)"PROJECT_PREVIOUS_PICTURE_FILE"));
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getTmpFile((int)ALEipUtils.getUserId((RunData)rundata), (String)folderName, (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFolderName(fileids[i]);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Exception", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (int k = 0; k < hadfileids.size(); ++k) {
                try {
                    fileid = Integer.parseInt((String)hadfileids.get(k));
                    hadfileidsValue.add(fileid);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                SelectQuery reqquery = Database.query(this.classT);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                int requestssize = requests.size();
                for (int i = 0; i < requestssize; ++i) {
                    IProjectFile file = (IProjectFile)requests.get(i);
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getFileName());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[ProjectFile] Exception.", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public boolean insertAttachmentFiles(List<FileuploadBean> fileuploadList, String folderName, int uid, M entry, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            int length = fileuploadList.size();
            ArrayList<FileuploadLiteBean> newfilebeans = new ArrayList<FileuploadLiteBean>();
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < length; ++i) {
                filebean = (FileuploadLiteBean)fileuploadList.get(i);
                if (!filebean.isNewFile()) continue;
                newfilebeans.add(filebean);
            }
            int newfilebeansSize = newfilebeans.size();
            if (newfilebeansSize > 0) {
                FileuploadLiteBean newfilebean = null;
                for (int j = 0; j < length; ++j) {
                    newfilebean = (FileuploadLiteBean)newfilebeans.get(j);
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    FileuploadUtils.ShrinkImageSet shrinkImageSet = FileuploadUtils.getBytesShrinkFilebean((String)Database.getDomainName(), (String)folderName, (int)uid, (FileuploadLiteBean)newfilebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)false);
                    String filename = j + "_" + String.valueOf(System.nanoTime());
                    IProjectFile file = (IProjectFile)Database.create(this.classT);
                    file.setOwnerId(Integer.valueOf(uid));
                    file.setFileName(newfilebean.getFileName());
                    file.setFilePath(ProjectFile.getRelativePath(filename));
                    if (shrinkImageSet != null) {
                        file.setFileThumbnail(shrinkImageSet.getShrinkImage());
                    }
                    file.setEipT(entry);
                    file.setCreateDate(Calendar.getInstance().getTime());
                    file.setUpdateDate(Calendar.getInstance().getTime());
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)FOLDER_FILEDIR, (String)(CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                }
                ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return true;
    }

    public SelectQuery<T> getSelectQueryForFiles(String keyName, int id) {
        SelectQuery query = Database.query(this.classT);
        query.setQualifier(ExpressionFactory.matchDbExp((String)keyName, (Object)id));
        return query;
    }

    public List<FileuploadBean> getFileList(List<T> list) {
        ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
        if (list != null && list.size() > 0) {
            FileuploadBean filebean = null;
            for (IProjectFile file : list) {
                String realname = file.getFileName();
                DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                filebean = new FileuploadBean();
                filebean.setFileId(file.getFileId().intValue());
                filebean.setFileName(realname);
                if (hData != null) {
                    filebean.setContentType(hData.getContentType());
                }
                filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                attachmentFileList.add(filebean);
            }
        }
        return attachmentFileList;
    }

    public T getEipTFile(RunData rundata, String key) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[ProjectFile] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(this.classT);
            Expression exp = ExpressionFactory.matchDbExp((String)key, (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[ProjectFile] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (T)((IProjectFile)files.get(0));
        }
        catch (Exception ex) {
            logger.error((Object)"[ProjectFile]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public boolean removeFile(RunData rundata, String keyName, Integer id) {
        try {
            SelectQuery query = Database.query(this.classT);
            query.setQualifier(ExpressionFactory.matchExp((String)keyName, (Object)id));
            List fileList = query.fetchList();
            if (fileList == null || fileList.isEmpty()) {
                return true;
            }
            Database.deleteAll((List)fileList);
            ArrayList<String> fpaths = new ArrayList<String>();
            for (IProjectFile file : fileList) {
                fpaths.add(file.getFilePath());
            }
            if (!fpaths.isEmpty()) {
                for (String path : fpaths) {
                    ALStorageService.deleteFile((String)(ProjectFile.getSaveDirPath(ALEipUtils.getUserId((RunData)rundata)) + path));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public List<Integer> getRequestedHasFileIdList(List<FileuploadBean> attachmentFileNameList) {
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        FileuploadBean filebean = null;
        if (attachmentFileNameList != null) {
            int size = attachmentFileNameList.size();
            for (int i = 0; i < size; ++i) {
                filebean = attachmentFileNameList.get(i);
                if (filebean.isNewFile()) continue;
                int index = filebean.getFileId();
                idlist.add(index);
            }
        }
        return idlist;
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static String getSaveDirPath(int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }
}

