/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.msgboard.MsgboardTopicSelectData;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardCategoryFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardCategoryFormData.class.getName());
    private ALStringField category_name;
    private ALStringField note;
    private ALNumberField access_flag;
    private ALEipUser login_user;
    private boolean is_member;
    private List<ALEipUser> memberList;
    private List<ALEipGroup> groups;
    private boolean authority_edit;
    private boolean authority_delete;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.is_member = rundata.getParameters().getBoolean("is_member");
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.groups = ALEipUtils.getMyGroups((RunData)rundata);
        this.authority_edit = MsgboardUtils.checkPermission(rundata, context, 8, "msgboard_category_other");
        this.authority_delete = MsgboardUtils.checkPermission(rundata, context, 16, "msgboard_category_other");
        super.init(action, rundata, context);
    }

    public void initField() {
        this.category_name = new ALStringField();
        this.category_name.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_CATEGORY_NAME"));
        this.category_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_MEMO"));
        this.note.setTrim(true);
        this.access_flag = new ALNumberField();
        this.access_flag.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_CHANGE_VIEWS"));
        this.access_flag.setValue(0L);
        this.memberList = new ArrayList<ALEipUser>();
    }

    protected void setValidator() {
        this.category_name.setNotNull(true);
        this.category_name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
        this.access_flag.limitValue(0L, 3L);
    }

    protected boolean validate(List<String> msgList) {
        this.category_name.validate(msgList);
        this.note.validate(msgList);
        this.access_flag.validate(msgList);
        int tmp_access_flag = (int)this.access_flag.getValue();
        if ((tmp_access_flag == 1 || tmp_access_flag == 2) && this.memberList.size() == 0) {
            msgList.add("\u6240\u5c5e\u30e1\u30f3\u30d0\u30fc\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            String loginUserStatus = null;
            int uid = (int)this.login_user.getUserId().getValue();
            EipTMsgboardCategory category = MsgboardUtils.getEipTMsgboardCategory(rundata, context, true);
            if (category == null) {
                return false;
            }
            this.category_name.setValue(category.getCategoryName());
            this.note.setValue(category.getNote());
            boolean public_flag = "T".equals(category.getPublicFlag());
            SelectQuery mapquery = Database.query(EipTMsgboardCategoryMap.class);
            Expression mapexp = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)category.getCategoryId());
            mapquery.setQualifier(mapexp);
            List list = mapquery.fetchList();
            ArrayList<Integer> users = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)list.get(i);
                users.add(map.getUserId());
                if (uid != map.getUserId()) continue;
                loginUserStatus = map.getStatus();
            }
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            Expression nonDisabledexp = ExpressionFactory.noMatchExp((String)"disabled", (Object)"T");
            query.setQualifier(exp.andExp(nonDisabledexp));
            this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
            if (public_flag) {
                if ("A".equals(loginUserStatus)) {
                    this.access_flag.setValue(0L);
                    this.is_member = false;
                } else {
                    this.access_flag.setValue(1L);
                    this.is_member = true;
                }
            } else if ("A".equals(loginUserStatus)) {
                this.access_flag.setValue(3L);
                this.is_member = false;
            } else {
                this.access_flag.setValue(2L);
                this.is_member = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)ALEipUtils.getUserId((RunData)rundata));
            EipTMsgboardCategory category = (EipTMsgboardCategory)Database.create(EipTMsgboardCategory.class);
            category.setCategoryName(this.category_name.getValue());
            category.setNote(this.note.getValue());
            int accessFlag = (int)this.access_flag.getValue();
            if (accessFlag == 0 || accessFlag == 1) {
                category.setPublicFlag("T");
            } else {
                category.setPublicFlag("F");
            }
            category.setTurbineUser(tuser);
            category.setCreateDate(Calendar.getInstance().getTime());
            category.setUpdateDate(Calendar.getInstance().getTime());
            int size = this.memberList.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)Database.create(EipTMsgboardCategoryMap.class);
                ALEipUser user = this.memberList.get(i);
                int userid = (int)user.getUserId().getValue();
                map.setEipTMsgboardCategory(category);
                map.setUserId(Integer.valueOf(userid));
                if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                    if (accessFlag == 0 || accessFlag == 3) {
                        map.setStatus("A");
                        continue;
                    }
                    map.setStatus("O");
                    continue;
                }
                map.setStatus("S");
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 181, category.getCategoryName());
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[MsgboardFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMsgboardCategory category = MsgboardUtils.getEipTMsgboardCategory(rundata, context, true);
            if (category == null) {
                return false;
            }
            category.setCategoryName(this.category_name.getValue());
            category.setNote(this.note.getValue());
            int accessFlag = (int)this.access_flag.getValue();
            if (accessFlag == 0 || accessFlag == 1) {
                category.setPublicFlag("T");
            } else {
                category.setPublicFlag("F");
            }
            category.setUpdateDate(Calendar.getInstance().getTime());
            SelectQuery mapquery = Database.query(EipTMsgboardCategoryMap.class);
            Expression mapexp = ExpressionFactory.matchExp((String)"categoryId", (Object)category.getCategoryId());
            mapquery.setQualifier(mapexp);
            List maplist = mapquery.fetchList();
            Database.deleteAll((List)maplist);
            int size = this.memberList.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)Database.create(EipTMsgboardCategoryMap.class);
                ALEipUser user = this.memberList.get(i);
                int userid = (int)user.getUserId().getValue();
                map.setEipTMsgboardCategory(category);
                map.setUserId(Integer.valueOf(userid));
                if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                    if (accessFlag == 0 || accessFlag == 3) {
                        map.setStatus("A");
                        continue;
                    }
                    map.setStatus("O");
                    continue;
                }
                map.setStatus("S");
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 181, category.getCategoryName());
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[MsgboardFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMsgboardCategory category = MsgboardUtils.getEipTMsgboardCategory(rundata, context, true);
            if (category == null) {
                return false;
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 181, category.getCategoryName());
            List topics = category.getEipTMsgboardTopics();
            for (EipTMsgboardTopic topic : topics) {
                MsgboardUtils.deleteAttachmentFiles(topic);
            }
            Database.delete((Persistent)category);
            Database.commit();
            String filtername = MsgboardTopicSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[MsgboardFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            int tmp_access_flag = (int)this.access_flag.getValue();
            if (tmp_access_flag == 0 || tmp_access_flag == 3) {
                this.memberList.add(this.login_user);
            } else {
                Object[] str = rundata.getParameters().getStrings("member_to");
                if (str == null || str.length == 0) {
                    return res;
                }
                boolean containsLoginUser = false;
                String str_loginuserid = this.login_user.getName().getValue();
                int strsize = str.length;
                for (int i = 0; i < strsize; ++i) {
                    if (!str_loginuserid.equals(str[i])) continue;
                    containsLoginUser = true;
                    break;
                }
                if (!containsLoginUser) {
                    this.memberList.add(this.login_user);
                }
                SelectQuery query = Database.query(TurbineUser.class);
                Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])str);
                query.setQualifier(exp);
                this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
            }
        }
        return res;
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALNumberField getAccessFlag() {
        return this.access_flag;
    }

    public boolean isMember() {
        return this.is_member || this.memberList.size() > 1;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public List<ALEipUser> getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public List<ALEipGroup> getGroupList() {
        return this.groups;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public boolean getAuthorityEdit() {
        return this.authority_edit;
    }

    public boolean getAuthorityDelete() {
        return this.authority_delete;
    }

    public String getAclPortletFeature() {
        return "msgboard_category";
    }
}

