/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            int ownerid_int = ALEipUtils.getUserId((RunData)rundata);
            Integer ownerid = ownerid_int;
            SelectQuery query = Database.query(EipTMsgboardTopic.class);
            for (int i = 0; i < values.size(); ++i) {
                String id = values.get(i);
                Expression exp01 = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)ownerid);
                Expression exp02 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(id));
                Expression exp03 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(id));
                query.orQualifier(exp01.andExp(exp02).orExp(exp03));
            }
            List list = query.fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"[MsgboardMultiDelete] Empty TopicIDs...");
                return false;
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardTopic topic = (EipTMsgboardTopic)list.get(i);
                Database.delete((Persistent)topic);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            }
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"msgboard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "msgboard_topic";
    }
}

