/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipHolidaysManager;
import com.aimluck.eip.exttimecard.ExtTimecardResultData;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ExtTimecardListResultData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardListResultData.class.getName());
    private ALDateField date = null;
    private ExtTimecardResultData rd;
    private List<ExtTimecardResultData> list = null;
    private EipTExtTimecardSystem timecard_system;
    private float calculated_work_hour = -1.0f;
    private float calculated_total_work_hour = -1.0f;
    private float calculated_overtime_hour = -1.0f;
    public static final float NO_DATA = -1.0f;
    private int beforeafter;

    public void initField() {
        this.date = new ALDateField();
        this.date.setValue(new Date());
        this.list = new ArrayList<ExtTimecardResultData>();
        this.beforeafter = 0;
    }

    public void setDate(Date date) {
        this.date.setValue(date);
    }

    public String getDate() {
        return this.date.getValue().toString();
    }

    public void setRd(ExtTimecardResultData resultdata) {
        this.rd = resultdata;
    }

    public ExtTimecardResultData getRd() {
        return this.rd;
    }

    public boolean getIsResultData() {
        return this.rd != null;
    }

    public int getIsBeforeOrAfterToday() {
        try {
            Date today = new Date();
            Date now = this.date.getValue().getDate();
            if (ExtTimecardUtils.sameDay(now, today)) {
                return 0;
            }
            return now.compareTo(today);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIsBeforeOrafterTodayAlter() {
        try {
            int change_time = this.timecard_system.getChangeHour();
            Date today = new Date();
            long time = today.getTime() - Long.valueOf(Integer.toString(change_time * 60 * 60 * 1000));
            today.setTime(time);
            Date now = this.date.getValue().getDate();
            logger.debug((Object)today.toString());
            logger.error((Object)now.toString());
            if (ExtTimecardUtils.sameDay(now, today)) {
                return 0;
            }
            return now.compareTo(today);
        }
        catch (RuntimeException e) {
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIsSaturdayOrSundayOrHoliday() {
        try {
            Date now = this.date.getValue().getDate();
            ALEipHolidaysManager holidaysManager = ALEipHolidaysManager.getInstance();
            if (holidaysManager.isHoliday(now) != null) {
                return 3;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(now);
            if (cal.get(7) == 7) {
                return 1;
            }
            if (cal.get(7) == 1) {
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean getIsNotNullClockInTime() {
        if (this.rd == null) {
            return false;
        }
        return !this.rd.getIsNullClockInTime();
    }

    public boolean getIsNotNullClockOutTime() {
        if (this.rd == null) {
            return false;
        }
        return !this.rd.getIsNullClockOutTime();
    }

    public int getOutgoingComebackTimes() {
        if (this.rd == null) {
            return 1;
        }
        return Math.max(Math.max(this.rd.getAllOutgoingTime().size(), this.rd.getAllComebackTime().size()), 1);
    }

    public boolean getIsClockOverTime() {
        if (this.getIsNotNullClockInTime()) {
            int end_hour = this.timecard_system.getEndHour();
            int end_minute = this.timecard_system.getEndMinute();
            Calendar cal = Calendar.getInstance();
            int now_hour = cal.get(11);
            int now_minute = cal.get(12);
            if (now_hour < end_hour) {
                return false;
            }
            if (now_hour == end_hour) {
                return now_minute >= end_minute;
            }
            return true;
        }
        return false;
    }

    public List<Map<String, String>> getOutgoingComeback() {
        ArrayList<Map<String, String>> result_list = new ArrayList<Map<String, String>>();
        HashMap<String, String> dummymap = new HashMap<String, String>();
        dummymap.put("outgoing", "");
        dummymap.put("comeback", "");
        if (this.rd == null) {
            result_list.add(dummymap);
        } else {
            List<ALDateTimeField> out = this.rd.getAllOutgoingTime();
            List<ALDateTimeField> come = this.rd.getAllComebackTime();
            for (int i = 0; i < 5; ++i) {
                boolean isnullout = out.get(i).isNullHour();
                boolean isnullcome = come.get(i).isNullHour();
                if (isnullout && isnullcome) break;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("outgoing", isnullout ? "" : out.get(i).getTime());
                map.put("comeback", isnullcome ? "" : come.get(i).getTime());
                result_list.add(map);
            }
            if (result_list.size() == 0) {
                result_list.add(dummymap);
            }
        }
        return result_list;
    }

    public List<Map<String, String>> getOutgoingComeback_xls() {
        ArrayList<Map<String, String>> result_list = new ArrayList<Map<String, String>>();
        HashMap<String, String> dummymap = new HashMap<String, String>();
        dummymap.put("outgoing", "");
        dummymap.put("comeback", "");
        if (this.rd == null) {
            result_list.add(dummymap);
        } else {
            List<ALDateTimeField> out = this.rd.getAllOutgoingTime();
            List<ALDateTimeField> come = this.rd.getAllComebackTime();
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            for (int i = 0; i < 5; ++i) {
                boolean isnullout = out.get(i).isNullHour();
                boolean isnullcome = come.get(i).isNullHour();
                if (!isnullout || isnullcome) {
                    // empty if block
                }
                String out_str = "";
                String come_str = "";
                try {
                    if (!isnullout) {
                        out_str = sdf.format(out.get(i).getValue());
                    }
                    if (!isnullcome) {
                        come_str = sdf.format(come.get(i).getValue());
                    }
                }
                catch (Exception e) {
                    out_str = "";
                    come_str = "";
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("outgoing", out_str);
                map.put("comeback", come_str);
                result_list.add(map);
            }
            if (result_list.size() == 0) {
                result_list.add(dummymap);
            }
        }
        return result_list;
    }

    private String changeMinute(String minute) {
        if (Integer.parseInt(minute) >= 0 && Integer.parseInt(minute) <= 9) {
            minute = "0" + minute;
            return minute;
        }
        return minute;
    }

    public float getWorkHour() {
        if (!this.getIsNotNullClockInTime() || !this.getIsNotNullClockOutTime()) {
            return -1.0f;
        }
        if (this.calculated_work_hour != -1.0f) {
            return this.calculated_work_hour;
        }
        float time = 0.0f;
        float in = this.getInworkHour();
        if (this.getIsSaturdayOrSundayOrHoliday() == 0 && in != -1.0f) {
            time += in;
        }
        this.calculated_work_hour = time;
        return time;
    }

    public float getTotalWorkHour() {
        if (!this.getIsNotNullClockInTime() || !this.getIsNotNullClockOutTime()) {
            return -1.0f;
        }
        if (this.calculated_total_work_hour != -1.0f) {
            return this.calculated_total_work_hour;
        }
        float time = 0.0f;
        float in = this.getInworkHour();
        float over = this.getOvertimeHour();
        if (in != -1.0f) {
            time += in;
        }
        if (over != -1.0f) {
            time += over;
        }
        this.calculated_total_work_hour = time;
        return time;
    }

    public float getInworkHour() {
        if (!this.getIsNotNullClockInTime() || !this.getIsNotNullClockOutTime()) {
            return -1.0f;
        }
        if (this.getIsSaturdayOrSundayOrHoliday() != 0) {
            return 0.0f;
        }
        float time = 0.0f;
        time = (float)((double)time + (double)(this.rd.getClockOutTime().getValue().getTime() - this.rd.getClockInTime().getValue().getTime()) / 3600000.0);
        float ovetTime = 0.0f;
        Date start_date = this.getStartDate();
        Date end_date = this.getEndDate();
        long start_time = start_date.getTime();
        long end_time = end_date.getTime();
        if (this.rd.getClockInTime().getValue().getTime() < start_time) {
            ovetTime += (float)(start_time - this.rd.getClockInTime().getValue().getTime());
            if (this.rd.getClockOutTime().getValue().getTime() < start_time) {
                ovetTime -= (float)(start_time - this.rd.getClockOutTime().getValue().getTime());
            }
        }
        if (end_time < this.rd.getClockOutTime().getValue().getTime()) {
            ovetTime += (float)(this.rd.getClockOutTime().getValue().getTime() - end_time);
            if (end_time < this.rd.getClockInTime().getValue().getTime()) {
                ovetTime -= (float)(this.rd.getClockInTime().getValue().getTime() - end_time);
            }
        }
        ovetTime = (float)((double)ovetTime / 3600000.0);
        time -= ovetTime;
        if (this.timecard_system.getOutgoingAddFlag().equals("F")) {
            float outgoing_time = this.getOutgoingTime(this.getStartDate(), this.getEndDate());
            if (outgoing_time != -1.0f) {
                time -= outgoing_time;
            } else {
                return -1.0f;
            }
        }
        float worktimein = (float)this.timecard_system.getWorktimeIn().intValue() / 60.0f;
        float resttimein = (float)this.timecard_system.getResttimeIn().intValue() / 60.0f;
        if (worktimein == 0.0f) {
            return time;
        }
        int resttimes = (int)(time / worktimein);
        return time - (float)resttimes * resttimein;
    }

    public float getOutworkHour() {
        if (!this.getIsNotNullClockInTime() || !this.getIsNotNullClockOutTime()) {
            return -1.0f;
        }
        float time = 0.0f;
        if (this.getIsSaturdayOrSundayOrHoliday() == 0) {
            int start_hour = this.timecard_system.getStartHour();
            int start_minute = this.timecard_system.getStartMinute();
            int end_hour = this.timecard_system.getEndHour();
            int end_minute = this.timecard_system.getEndMinute();
            Calendar cal = Calendar.getInstance();
            try {
                cal.setTime(this.date.getValue().getDate());
            }
            catch (Exception e) {
                // empty catch block
            }
            cal.set(11, start_hour);
            cal.set(12, start_minute);
            long start_time = cal.getTime().getTime();
            cal.set(11, end_hour);
            cal.set(12, end_minute);
            long end_time = cal.getTime().getTime();
            if (start_hour >= 0 && start_hour < this.timecard_system.getChangeHour()) {
                start_time += 86400000L;
                end_time += 86400000L;
            } else if (end_hour >= 0 && end_hour < this.timecard_system.getChangeHour()) {
                end_time += 86400000L;
            }
            if (this.rd.getClockInTime().getValue().getTime() < start_time) {
                time += (float)(start_time - this.rd.getClockInTime().getValue().getTime());
            }
            if (end_time < this.rd.getClockOutTime().getValue().getTime()) {
                time += (float)(this.rd.getClockOutTime().getValue().getTime() - end_time);
            }
            time = (float)((double)time / 3600000.0);
        }
        return time;
    }

    public float getOffWorkHour() {
        if (this.getIsSaturdayOrSundayOrHoliday() != 0) {
            return this.getTotalWorkHour();
        }
        return -1.0f;
    }

    public float getWorkHourWithoutRestHour() {
        return this.getWorkHourWithoutRestHour(false);
    }

    public float getWorkHourWithoutRestHour(boolean round) {
        float time = -1.0f;
        time = this.calculated_work_hour != -1.0f ? this.calculated_work_hour : this.getWorkHour();
        if (round) {
            time = ExtTimecardUtils.roundHour(time);
        }
        return time;
    }

    public float getOvertimeHour() {
        if (!this.getIsNotNullClockInTime() || !this.getIsNotNullClockOutTime()) {
            return -1.0f;
        }
        if (this.calculated_overtime_hour != -1.0f) {
            return this.calculated_overtime_hour;
        }
        float time = 0.0f;
        Date start_date = this.getStartDate();
        Date end_date = this.getEndDate();
        Date change_date = this.getChangeDate();
        Date nextchange_date = this.getNextChangeDate();
        if (this.getIsSaturdayOrSundayOrHoliday() == 0) {
            long start_time = start_date.getTime();
            long end_time = end_date.getTime();
            if (this.rd.getClockInTime().getValue().getTime() < start_time) {
                time += (float)(start_time - this.rd.getClockInTime().getValue().getTime());
                if (this.rd.getClockOutTime().getValue().getTime() < start_time) {
                    time -= (float)(start_time - this.rd.getClockOutTime().getValue().getTime());
                }
            }
            if (end_time < this.rd.getClockOutTime().getValue().getTime()) {
                time += (float)(this.rd.getClockOutTime().getValue().getTime() - end_time);
                if (end_time < this.rd.getClockInTime().getValue().getTime()) {
                    time -= (float)(this.rd.getClockInTime().getValue().getTime() - end_time);
                }
            }
            time = (float)((double)time / 3600000.0);
            if (this.timecard_system.getOutgoingAddFlag().equals("F")) {
                float outgoing_time = this.getOutgoingTime(change_date, start_date);
                if (outgoing_time != -1.0f) {
                    time -= outgoing_time;
                }
                if ((outgoing_time = this.getOutgoingTime(end_date, nextchange_date)) != -1.0f) {
                    time -= outgoing_time;
                }
            }
        } else {
            time = (float)((double)time + (double)(this.rd.getClockOutTime().getValue().getTime() - this.rd.getClockInTime().getValue().getTime()) / 3600000.0);
            float outgoing_time = this.getOutgoingTime(change_date, nextchange_date);
            if (outgoing_time != -1.0f) {
                time -= outgoing_time;
            }
        }
        float worktimeout = (float)this.timecard_system.getWorktimeOut().intValue() / 60.0f;
        float resttimeout = (float)this.timecard_system.getResttimeOut().intValue() / 60.0f;
        if (worktimeout == 0.0f) {
            return time;
        }
        int resttimes = (int)(time / worktimeout);
        this.calculated_overtime_hour = time - (float)resttimes * resttimeout;
        return time - (float)resttimes * resttimeout;
    }

    public float getOvertimeHourWithoutRestHour() {
        return this.getOvertimeHourWithoutRestHour(false);
    }

    public float getOvertimeHourWithoutRestHour(boolean round) {
        float time = -1.0f;
        time = this.calculated_overtime_hour > -1.0f ? this.calculated_overtime_hour : this.getOvertimeHour();
        if (round) {
            time = ExtTimecardUtils.roundHour(time);
        }
        if (this.getIsSaturdayOrSundayOrHoliday() != 0 && time != -1.0f) {
            time = 0.0f;
        }
        return time;
    }

    public float getOffHour() {
        return this.getOffHour(false);
    }

    public float getOffHour(boolean round) {
        if (this.getIsSaturdayOrSundayOrHoliday() != 0) {
            float time = -1.0f;
            time = this.calculated_total_work_hour != -1.0f ? this.calculated_total_work_hour : this.getTotalWorkHour();
            if (round) {
                time = ExtTimecardUtils.roundHour(time);
            }
            return time;
        }
        return -1.0f;
    }

    public float getRestHour() {
        float time = 0.0f;
        if (this.getWorkHour() != -1.0f && this.getOvertimeHour() != -1.0f) {
            float work = this.getWorkHour() - this.getOvertimeHour();
            float overtime = this.getOvertimeHour();
            int rest_work_num = 0;
            int rest_overtime_num = 0;
            int rest_work_extra = 0;
            int rest_overtime_extra = 0;
            if (work > 0.0f && (rest_work_extra = (int)(work * 60.0f - (float)((rest_work_num = (int)(work * 60.0f / (float)(this.timecard_system.getWorktimeIn() + this.timecard_system.getResttimeIn()))) * (this.timecard_system.getWorktimeIn() + this.timecard_system.getResttimeIn())) - (float)this.timecard_system.getWorktimeIn().intValue())) < 0) {
                rest_work_extra = 0;
            }
            if (overtime > 0.0f && (rest_overtime_extra = (int)(overtime * 60.0f - (float)((rest_overtime_num = (int)(overtime * 60.0f / (float)(this.timecard_system.getWorktimeOut() + this.timecard_system.getResttimeOut()))) * (this.timecard_system.getWorktimeOut() + this.timecard_system.getResttimeOut())) - (float)this.timecard_system.getWorktimeOut().intValue())) < 0) {
                rest_overtime_extra = 0;
            }
            time = rest_work_num * this.timecard_system.getResttimeIn() + rest_overtime_num * this.timecard_system.getResttimeOut() + rest_work_extra + rest_overtime_extra;
            return time /= 60.0f;
        }
        return -1.0f;
    }

    public boolean isLateComing() {
        if (!this.getIsNotNullClockInTime() || !this.getIsNotNullClockOutTime()) {
            return false;
        }
        Date start_date = this.getStartDate();
        return this.rd.getClockInTime().getValue().after(start_date);
    }

    public boolean isEarlyLeaving() {
        if (!this.getIsNotNullClockInTime() || !this.getIsNotNullClockOutTime()) {
            return false;
        }
        Date end_date = this.getEndDate();
        return this.rd.getClockOutTime().getValue().before(end_date);
    }

    public boolean isAbsent() {
        return false;
    }

    public String getHourToString(float time) {
        if (time == -1.0f) {
            return "";
        }
        return time + "h";
    }

    public String getDateStr() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("M\u6708d\u65e5(EE)");
            return sdf.format(this.date.getValue().getDate());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDateStr(String str) {
        try {
            if (str == null || "".equals(str)) {
                str = "yyyy\u5e74MM\u6708dd\u65e5(EE)";
            }
            SimpleDateFormat sdf = new SimpleDateFormat(str);
            return sdf.format(this.date.getValue().getDate());
        }
        catch (RuntimeException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public EipTExtTimecardSystem getTimecardSystem() {
        return this.timecard_system;
    }

    public void setTimecardSystem(EipTExtTimecardSystem system) {
        this.timecard_system = system;
    }

    public Date getClockInDate() {
        return this.rd.getClockInTime().getValue();
    }

    public List<ExtTimecardResultData> getList() {
        return this.list;
    }

    public List<ExtTimecardResultData> getViewList() {
        ArrayList<ExtTimecardResultData> viewlist = new ArrayList<ExtTimecardResultData>();
        return viewlist;
    }

    public void addExtTimecardResultData(ExtTimecardResultData rd) {
        this.list.add(rd);
    }

    public String getSummayTimes() {
        int size = this.list.size();
        if (size < 1) {
            return "0";
        }
        return "0";
    }

    private Date getStartDate() {
        int start_hour = this.timecard_system.getStartHour();
        int start_minute = this.timecard_system.getStartMinute();
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(this.rd.getPunchDate().getValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        cal.set(11, start_hour);
        cal.set(12, start_minute);
        cal.set(13, 0);
        cal.set(14, 0);
        if (start_hour >= 0 && start_hour < this.timecard_system.getChangeHour()) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }

    private Date getEndDate() {
        int end_hour = this.timecard_system.getEndHour();
        int end_minute = this.timecard_system.getEndMinute();
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(this.rd.getPunchDate().getValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        cal.set(11, end_hour);
        cal.set(12, end_minute);
        cal.set(13, 0);
        cal.set(14, 0);
        if (end_hour >= 0 && end_hour < this.timecard_system.getChangeHour()) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }

    private Date getChangeDate() {
        int change_hour = this.timecard_system.getChangeHour();
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(this.rd.getPunchDate().getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        cal.set(11, change_hour);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getNextChangeDate() {
        int change_hour = this.timecard_system.getChangeHour();
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(this.rd.getPunchDate().getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        cal.add(5, 1);
        cal.set(11, change_hour);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private float getOutgoingTime(Date from_date, Date to_date) {
        long outgoing_time = 0L;
        int comeback_num = 0;
        int outgoing_num = 0;
        int from_num = -1;
        int to_num = -1;
        if (from_date.getTime() > to_date.getTime()) {
            return 0.0f;
        }
        for (ALDateTimeField field : this.rd.getAllComebackTime()) {
            if (field.isNullHour()) break;
            ++comeback_num;
            if (field.getValue().getTime() < from_date.getTime()) continue;
            if (from_num == -1) {
                from_num = comeback_num;
            }
            if (field.getValue().getTime() > to_date.getTime()) {
                to_num = comeback_num;
                outgoing_time += to_date.getTime();
                continue;
            }
            outgoing_time += field.getValue().getTime();
        }
        if (from_num != -1) {
            for (ALDateTimeField field : this.rd.getAllOutgoingTime()) {
                if (field.isNullHour()) break;
                if (++outgoing_num < from_num) continue;
                if (outgoing_num == from_num && field.getValue().getTime() < from_date.getTime()) {
                    outgoing_time -= from_date.getTime();
                    continue;
                }
                if (field.getValue().getTime() > to_date.getTime()) {
                    outgoing_time -= to_date.getTime();
                    continue;
                }
                outgoing_time -= field.getValue().getTime();
                if (outgoing_num != to_num) continue;
                break;
            }
            if (comeback_num == outgoing_num) {
                return (float)outgoing_time / 3600000.0f;
            }
            return -1.0f;
        }
        return 0.0f;
    }

    public void setBeforeAfter() {
        try {
            if (this.timecard_system != null) {
                int change_time = this.timecard_system.getChangeHour();
                Date today = new Date();
                long time = today.getTime() - Long.valueOf(Integer.toString(change_time * 60 * 60 * 1000));
                today.setTime(time);
                Date now = this.date.getValue().getDate();
                if (ExtTimecardUtils.sameDay(now, today)) {
                    this.beforeafter = 0;
                    return;
                }
                this.beforeafter = now.compareTo(today);
            } else {
                this.beforeafter = 0;
            }
        }
        catch (Exception e) {
            this.beforeafter = 0;
            logger.error((Object)"error", (Throwable)e);
        }
    }

    public int getBeforeAfter() {
        return this.beforeafter;
    }
}

