/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.common.ALData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ExtTimecardResultData
implements ALData {
    private ALStringField now_time;
    private EipTExtTimecardSystem timecard_system;
    private ALStringField work_flag;
    private ALDateTimeField work_date;
    private ALStringField refix_flag;
    private ALStringField list_date;
    private ALStringField reason;
    public boolean reason_flg;
    private ALStringField remarks;
    public boolean remarks_flg;
    private ALStringField timecard_id;
    private ALNumberField sum_work_date;
    private ALDateTimeField punch_date;
    private ALDateTimeField clock_in_time;
    private ALDateTimeField clock_out_time;
    private List<ALDateTimeField> outgoing_time;
    private List<ALDateTimeField> comeback_time;
    private ALStringField type;
    private boolean isTypeP;
    private boolean isTypeA;
    private boolean isTypeH;
    private boolean isTypeC;
    private boolean isTypeE;

    public void initField() {
        this.work_flag = new ALStringField();
        this.now_time = new ALStringField();
        this.work_date = new ALDateTimeField();
        this.refix_flag = new ALStringField();
        this.list_date = new ALStringField();
        this.timecard_id = new ALStringField();
        this.reason = new ALStringField();
        this.sum_work_date = new ALNumberField();
        this.remarks = new ALStringField();
        this.punch_date = new ALDateTimeField();
        this.clock_in_time = new ALDateTimeField();
        this.clock_out_time = new ALDateTimeField();
        this.reason_flg = false;
        this.remarks_flg = false;
        this.isTypeP = false;
        this.isTypeA = false;
        this.isTypeH = false;
        this.isTypeC = false;
        this.isTypeE = false;
        this.outgoing_time = new ArrayList<ALDateTimeField>();
        this.comeback_time = new ArrayList<ALDateTimeField>();
        this.type = new ALStringField();
    }

    public boolean getIsNullClockInTime() {
        return this.clock_in_time.isNullHour();
    }

    public boolean getIsNullClockOutTime() {
        return this.clock_out_time.isNullHour();
    }

    public boolean getIsOutgoing() {
        int length = this.outgoing_time.size();
        for (int i = 0; i < length; ++i) {
            if (this.outgoing_time.get(i).isNullHour() || !this.comeback_time.get(i).isNullHour()) continue;
            return true;
        }
        return false;
    }

    public boolean getIsOverTime() {
        if (!this.getIsNullClockInTime()) {
            int end_hour = this.timecard_system.getEndHour();
            int end_minute = this.timecard_system.getEndMinute();
            Calendar cal = Calendar.getInstance();
            int now_hour = cal.get(11);
            int now_minute = cal.get(12);
            if (now_hour < end_hour) {
                return false;
            }
            if (now_hour == end_hour) {
                return now_minute >= end_minute;
            }
            return true;
        }
        return false;
    }

    public void setClockInTime(Date date) {
        this.clock_in_time.setValue(date);
    }

    public void setClockOutTime(Date date) {
        this.clock_out_time.setValue(date);
    }

    public void setOutgoingTime(Date date, int n) {
        ALDateTimeField datetime = new ALDateTimeField();
        datetime.setValue(date);
        this.outgoing_time.add(datetime);
    }

    public void setComebackTime(Date date, int n) {
        ALDateTimeField datetime = new ALDateTimeField();
        datetime.setValue(date);
        this.comeback_time.add(datetime);
    }

    public void setPunchDate(Date date) {
        this.punch_date.setValue(date);
    }

    public void setNowTime(String time) {
        this.now_time.setValue(time);
    }

    public void setType(String str) {
        this.type.setValue(str);
    }

    public void setRefixFlag(Date create_date, Date update_date) {
        if (this.equalsToDate(create_date, update_date, true)) {
            this.refix_flag.setValue("0");
        } else {
            this.refix_flag.setValue("1");
        }
    }

    public void setTimecardId(long i) {
        this.timecard_id.setValue(Long.valueOf(i).toString());
    }

    public void setReason(String str_reason) {
        this.reason.setValue(str_reason);
    }

    public void setRemarks(String str_remarks) {
        this.remarks.setValue(str_remarks);
    }

    public void addSumWorkDate() {
        long count = this.sum_work_date.getValue();
        this.sum_work_date.setValue(count + 1L);
    }

    public ALNumberField getSumWorkDate() {
        return this.sum_work_date;
    }

    public ALDateTimeField getClockInTime() {
        return this.clock_in_time;
    }

    public String getClockInTime(String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(this.clock_in_time.getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getClockInTimeHourMinuteText() {
        return this.clock_in_time.getTime().toString();
    }

    public ALDateTimeField getPunchDate() {
        return this.punch_date;
    }

    public ALDateTimeField getClockOutTime() {
        return this.clock_out_time;
    }

    public String getClockOutTime(String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(this.clock_out_time.getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getClockOutTimeHourMinuteText() {
        return this.clock_out_time.getTime().toString();
    }

    public ALStringField getType() {
        return this.type;
    }

    public ALDateTimeField getOutgoingTime() {
        for (int i = 0; i < 5; ++i) {
            if (!this.outgoing_time.get(i).isNullHour()) continue;
            if (i == 0) {
                return null;
            }
            return this.outgoing_time.get(i - 1);
        }
        return this.outgoing_time.get(4);
    }

    public ALDateTimeField getComebackTime() {
        for (int i = 0; i < 5; ++i) {
            if (this.comeback_time.get(i).isNullHour()) continue;
            if (i == 0) {
                return null;
            }
            return this.comeback_time.get(i - 1);
        }
        return this.comeback_time.get(4);
    }

    public List<ALDateTimeField> getAllOutgoingTime() {
        return this.outgoing_time;
    }

    public List<ALDateTimeField> getAllComebackTime() {
        return this.comeback_time;
    }

    public ALStringField getNowTime() {
        return this.now_time;
    }

    public ALStringField getRefixFlag() {
        return this.refix_flag;
    }

    public ALStringField getListDate() {
        return this.list_date;
    }

    public ALStringField getTimecardId() {
        return this.timecard_id;
    }

    public ALStringField getReason() {
        return this.reason;
    }

    public ALStringField getRemarks() {
        return this.remarks;
    }

    private boolean equalsToDate(Date date1, Date date2, boolean checkTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Year = cal.get(1);
        int date1Month = cal.get(2) + 1;
        int date1Day = cal.get(5);
        int date1Hour = cal.get(10);
        int date1Minute = cal.get(12);
        int date1Second = cal.get(13);
        cal.setTime(date2);
        int date2Year = cal.get(1);
        int date2Month = cal.get(2) + 1;
        int date2Day = cal.get(5);
        int date2Hour = cal.get(10);
        int date2Minute = cal.get(12);
        int date2Second = cal.get(13);
        return checkTime ? date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute && date1Second == date2Second : date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    public ALDateTimeField getWorkDate() {
        return this.work_date;
    }

    public String getWorkDateStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH\u6642mm\u5206");
        return sdf.format(this.work_date.getValue());
    }

    public ALStringField getWorkFlag() {
        return this.work_flag;
    }

    public void setWorkFlag(String flag) {
        this.work_flag.setValue(flag);
    }

    public void setWorkDate(Date date) {
        this.work_date.setValue(date);
        this.list_date.setValue(ALDateUtil.format((Date)date, (String)"MM\u6708dd\u65e5"));
    }

    public boolean getRemarksFlg() {
        return this.remarks_flg;
    }

    public boolean getReasonFlg() {
        return this.reason_flg;
    }

    public boolean getIsTypeP() {
        return this.isTypeP;
    }

    public boolean getIsTypeA() {
        return this.isTypeA;
    }

    public boolean getIsTypeH() {
        return this.isTypeH;
    }

    public boolean getIsTypeC() {
        return this.isTypeC;
    }

    public boolean getIsTypeE() {
        return this.isTypeE;
    }

    public void setRemarksFlg(boolean b) {
        this.remarks_flg = b;
    }

    public void setReasonFlg(boolean b) {
        this.reason_flg = b;
    }

    public void setIsTypeP(boolean b) {
        this.isTypeP = b;
    }

    public void setIsTypeA(boolean b) {
        this.isTypeA = b;
    }

    public void setIsTypeH(boolean b) {
        this.isTypeH = b;
    }

    public void setIsTypeC(boolean b) {
        this.isTypeC = b;
    }

    public void setIsTypeE(boolean b) {
        this.isTypeE = b;
    }

    public EipTExtTimecardSystem getTimecardSystem() {
        return this.timecard_system;
    }

    public void setTimecardSystem(EipTExtTimecardSystem system) {
        this.timecard_system = system;
    }
}

