/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardSystemFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardSystemFormData.class.getName());
    private ALNumberField system_id;
    private ALNumberField user_id;
    private ALStringField system_name;
    private ALNumberField start_hour;
    private ALNumberField start_minute;
    private ALNumberField start_day;
    private ALNumberField end_hour;
    private ALNumberField end_minute;
    private ALNumberField worktime_in;
    private ALNumberField resttime_in;
    private ALNumberField worktime_out;
    private ALNumberField resttime_out;
    private ALNumberField change_hour;
    private ALStringField outgoing_add_flag;
    private int entity_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.system_id = new ALNumberField();
        this.system_id.setNotNull(true);
        this.user_id = new ALNumberField();
        this.user_id.setNotNull(true);
        this.system_name = new ALStringField();
        this.system_name.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_WORKING_ARRANGEMENTS"));
        this.system_name.setNotNull(true);
        this.start_hour = new ALNumberField();
        this.start_minute = new ALNumberField();
        this.end_hour = new ALNumberField();
        this.end_minute = new ALNumberField();
        this.start_day = new ALNumberField();
        this.start_day.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_START_DAY"));
        this.worktime_in = new ALNumberField();
        this.worktime_in.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_WORKTIME_IN_WORKTIME"));
        this.worktime_in.setNotNull(true);
        this.worktime_in.limitMinValue(0L);
        this.resttime_in = new ALNumberField();
        this.resttime_in.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_WORKTIME_IN_RESTTIME"));
        this.resttime_in.setNotNull(true);
        this.resttime_in.limitValue(0L, 360L);
        this.worktime_out = new ALNumberField();
        this.worktime_out.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_WORKTIME_OUT_WORKTIME"));
        this.worktime_out.setNotNull(true);
        this.worktime_out.limitMinValue(0L);
        this.resttime_out = new ALNumberField();
        this.resttime_out.setFieldName(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_SETFIELDNAME_WORKTIME_OUT_RESTTIME"));
        this.resttime_out.setNotNull(true);
        this.resttime_out.limitValue(0L, 360L);
        this.change_hour = new ALNumberField();
        this.change_hour.setNotNull(true);
        this.outgoing_add_flag = new ALStringField();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTExtTimecardSystem record = ExtTimecardUtils.getEipTExtTimecardSystem(rundata, context);
            if (record == null) {
                return false;
            }
            this.system_id.setValue(String.valueOf(record.getSystemId()));
            this.user_id.setValue(String.valueOf(record.getUserId()));
            this.system_name.setValue(record.getSystemName());
            this.start_hour.setValue(String.valueOf(record.getStartHour()));
            this.start_minute.setValue(String.valueOf(record.getStartMinute()));
            this.end_hour.setValue(String.valueOf(record.getEndHour()));
            this.end_minute.setValue(String.valueOf(record.getEndMinute()));
            this.start_day.setValue(String.valueOf(record.getStartDay()));
            this.worktime_in.setValue((long)record.getWorktimeIn().intValue());
            this.resttime_in.setValue((long)record.getResttimeIn().intValue());
            this.worktime_out.setValue((long)record.getWorktimeOut().intValue());
            this.resttime_out.setValue((long)record.getResttimeOut().intValue());
            this.change_hour.setValue(String.valueOf(record.getChangeHour()));
            this.outgoing_add_flag.setValue(record.getOutgoingAddFlag());
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTExtTimecardSystem record = ExtTimecardUtils.getEipTExtTimecardSystem(rundata, context);
            if (record == null) {
                return false;
            }
            record.setSystemName(this.system_name.getValue());
            record.setUserId(Integer.valueOf((int)this.user_id.getValue()));
            record.setStartHour(Integer.valueOf((int)this.start_hour.getValue()));
            record.setStartMinute(Integer.valueOf((int)this.start_minute.getValue()));
            record.setEndHour(Integer.valueOf((int)this.end_hour.getValue()));
            record.setEndMinute(Integer.valueOf((int)this.end_minute.getValue()));
            record.setStartDay(Integer.valueOf((int)this.start_day.getValue()));
            record.setWorktimeIn(Integer.valueOf((int)this.worktime_in.getValue()));
            record.setResttimeIn(Integer.valueOf((int)this.resttime_in.getValue()));
            record.setWorktimeOut(Integer.valueOf((int)this.worktime_out.getValue()));
            record.setResttimeOut(Integer.valueOf((int)this.resttime_out.getValue()));
            record.setChangeHour(Integer.valueOf((int)this.change_hour.getValue()));
            String tmp = "T".equals(this.outgoing_add_flag.getValue()) ? "T" : "F";
            record.setOutgoingAddFlag(tmp);
            record.setUpdateDate(Calendar.getInstance().getTime());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getSystemId().intValue(), 311, record.getSystemName());
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTExtTimecardSystem record = ExtTimecardUtils.getEipTExtTimecardSystem(rundata, context);
            if (record == null) {
                return false;
            }
            if (record.getSystemId() == 1) {
                msgList.add(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_ALERT_DELETE_WORKING_ARRANGEMENTS"));
                return false;
            }
            Database.delete((Persistent)record);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getSystemId().intValue(), 311, record.getSystemName());
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTExtTimecardSystem record = (EipTExtTimecardSystem)Database.create(EipTExtTimecardSystem.class);
            record.setSystemName(this.system_name.getValue());
            record.setUserId(Integer.valueOf((int)this.user_id.getValue()));
            record.setStartHour(Integer.valueOf((int)this.start_hour.getValue()));
            record.setStartMinute(Integer.valueOf((int)this.start_minute.getValue()));
            record.setEndHour(Integer.valueOf((int)this.end_hour.getValue()));
            record.setEndMinute(Integer.valueOf((int)this.end_minute.getValue()));
            record.setStartDay(Integer.valueOf((int)this.start_day.getValue()));
            record.setWorktimeIn(Integer.valueOf((int)this.worktime_in.getValue()));
            record.setResttimeIn(Integer.valueOf((int)this.resttime_in.getValue()));
            record.setWorktimeOut(Integer.valueOf((int)this.worktime_out.getValue()));
            record.setResttimeOut(Integer.valueOf((int)this.resttime_out.getValue()));
            record.setChangeHour(Integer.valueOf((int)this.change_hour.getValue()));
            String tmp = "T".equals(this.outgoing_add_flag.getValue()) ? "T" : "F";
            record.setOutgoingAddFlag(tmp);
            record.setCreateDate(Calendar.getInstance().getTime());
            record.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getSystemId().intValue(), 311, record.getSystemName());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            if ("new_form".equals(this.getMode())) {
                try {
                    SelectQuery query = Database.query(EipTExtTimecardSystem.class);
                    Expression exp1 = ExpressionFactory.matchDbExp((String)"SYSTEM_ID", (Object)1);
                    query.setQualifier(exp1);
                    List list = query.fetchList();
                    EipTExtTimecardSystem record = (EipTExtTimecardSystem)list.get(0);
                    this.user_id.setValue(String.valueOf(record.getUserId()));
                    this.system_name.setValue("");
                    this.start_hour.setValue(String.valueOf(record.getStartHour()));
                    this.start_minute.setValue(String.valueOf(record.getStartMinute()));
                    this.end_hour.setValue(String.valueOf(record.getEndHour()));
                    this.end_minute.setValue(String.valueOf(record.getEndMinute()));
                    this.start_day.setValue(String.valueOf(record.getStartDay()));
                    this.worktime_in.setValue((long)record.getWorktimeIn().intValue());
                    this.resttime_in.setValue((long)record.getResttimeIn().intValue());
                    this.worktime_out.setValue((long)record.getWorktimeOut().intValue());
                    this.resttime_out.setValue((long)record.getResttimeOut().intValue());
                    this.change_hour.setValue(String.valueOf(record.getChangeHour()));
                    this.outgoing_add_flag.setValue(record.getOutgoingAddFlag());
                }
                catch (Exception ex) {
                    logger.error((Object)"[ExtTimecardSystemFormData]", (Throwable)ex);
                }
            }
            if ("update".equals(this.getMode()) && this.entity_id <= 0) {
                this.entity_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
                this.system_id.setValue((long)this.entity_id);
            }
        }
        return res;
    }

    protected void setValidator() throws ALPageNotFoundException, ALDBErrorException {
        this.start_hour.limitValue(0L, 23L);
        this.start_minute.limitValue(0L, 59L);
        this.end_hour.limitValue(0L, 23L);
        this.end_minute.limitValue(0L, 59L);
        this.start_day.limitValue(0L, 28L);
        this.worktime_in.limitValue(0L, 480L);
        this.worktime_out.limitValue(0L, 480L);
        this.resttime_in.limitValue(0L, 480L);
        this.resttime_out.limitValue(0L, 480L);
    }

    protected boolean validate(List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            long change_time;
            long end_time;
            long start_time;
            SelectQuery query = Database.query(EipTExtTimecardSystem.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"systemName", (Object)this.system_name.getValue());
            query.setQualifier(exp1);
            if ("update".equals(this.getMode())) {
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"SYSTEM_ID", (Object)this.system_id.getValue());
                query.andQualifier(exp2);
            }
            if (query.fetchList().size() != 0) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_ALERT_ALREADY_ADDED_WORKING_ARRANGEMENTS", (Object[])new Object[]{this.system_name.toString()}));
            }
            if (!this.isValidChangeTime(start_time = this.start_hour.getValue() * 60L + this.start_minute.getValue(), end_time = this.end_hour.getValue() * 60L + this.end_minute.getValue(), change_time = this.change_hour.getValue() * 60L)) {
                msgList.add(ALLocalizationUtils.getl10n((String)"EXTTIMECARD_ALERT_SELECT_CHANGE_HOUR"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        this.system_name.validate(msgList);
        this.worktime_in.validate(msgList);
        this.resttime_in.validate(msgList);
        this.worktime_out.validate(msgList);
        this.resttime_out.validate(msgList);
        return msgList.size() == 0;
    }

    private boolean isValidChangeTime(long start_time, long end_time, long change_time) {
        if (end_time <= start_time) {
            end_time += 1440L;
        }
        if (start_time <= change_time && change_time <= end_time) {
            return false;
        }
        return end_time < (change_time += 1440L);
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    public ALNumberField getStartTimeHour() {
        return this.start_hour;
    }

    public ALNumberField getStartTimeMinute() {
        return this.start_minute;
    }

    public ALNumberField getEndTimeHour() {
        return this.end_hour;
    }

    public ALNumberField getEndTimeMinute() {
        return this.end_minute;
    }

    public ALNumberField getWorktimeIn() {
        return this.worktime_in;
    }

    public ALNumberField getWorktimeOut() {
        return this.worktime_out;
    }

    public ALNumberField getResttimeIn() {
        return this.resttime_in;
    }

    public ALNumberField getResttimeOut() {
        return this.resttime_out;
    }

    public String getWorkTimeInRestTimeInText() {
        return ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_INPUT_RESTTIME_FOR_WORKTIMEIN", (Object[])new Object[]{this.worktime_in.toString(), this.resttime_in.toString()});
    }

    public String getWorkTimeOutRestTimeOutText() {
        return ALLocalizationUtils.getl10nFormat((String)"EXTTIMECARD_INPUT_RESTTIME_FOR_WORKTIMEOUT", (Object[])new Object[]{this.worktime_out.toString(), this.resttime_out.toString()});
    }

    public ALNumberField getChangeHour() {
        return this.change_hour;
    }

    public ALStringField getSystemName() {
        return this.system_name;
    }

    public ALStringField getOutgoingAddFlag() {
        return this.outgoing_add_flag;
    }

    public ALNumberField getStartDay() {
        return this.start_day;
    }

    public ALNumberField getSystemId() {
        return this.system_id;
    }
}

