/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cellular;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cellular.util.CellularUtils;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALEipUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellularFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellularFormData.class.getName());
    private ALStringField cellular_url;
    private boolean enableEasyLogin;
    private ALBaseUser baseUser;
    private String url;
    private String orgId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.enableEasyLogin = false;
        this.orgId = Database.getDomainName();
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        try {
            this.baseUser = (ALBaseUser)JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(jdata.getJetspeedUser().getUserName()));
        }
        catch (JetspeedSecurityException e) {
            this.baseUser = (ALBaseUser)rundata.getUser();
        }
        this.url = CellularUtils.getCellularUrl(rundata, context);
    }

    public void initField() {
        this.cellular_url = new ALStringField();
        this.cellular_url.setFieldName(ALOrgUtilsService.getAlias() + "\u30b5\u30a4\u30c8\u306e\u30a2\u30c9\u30ec\u30b9");
        this.cellular_url.setTrim(true);
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        String uid = this.baseUser.getCelluarUId();
        this.enableEasyLogin = uid != null && uid.length() > 0;
        this.cellular_url.setValue(this.url);
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        this.cellular_url.setValue(this.url);
        try {
            if (this.url == null || this.url.length() == 0) {
                msgList.add(ALOrgUtilsService.getAlias() + "\u30b5\u30a4\u30c8\u306e\u30a2\u30c9\u30ec\u30b9\u304c\u672a\u8a2d\u5b9a\u306e\u305f\u3081\u3001\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + ALOrgUtilsService.getAlias() + "\u306e\u7ba1\u7406\u62c5\u5f53\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002" + ALOrgUtilsService.getAlias() + "\u30b5\u30a4\u30c8\u306e\u30a2\u30c9\u30ec\u30b9\u306f\u3001\u7ba1\u7406\u753b\u9762\u3067\u8a2d\u5b9a\u3067\u304d\u307e\u3059\u3002");
                return false;
            }
            ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
            ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
            memberList.add(ALEipUtils.getALEipUser((RunData)rundata));
            List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)true);
            ALEipUserAddr addr = null;
            addr = (ALEipUserAddr)destMemberList.get(0);
            if (addr.getCellMailAddr() == null || addr.getCellMailAddr().equals("")) {
                msgList.add("\u30e6\u30fc\u30b6\u30fc\u306e\u643a\u5e2f\u96fb\u8a71\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u643a\u5e2f\u96fb\u8a71\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306f\u3001\u500b\u4eba\u8a2d\u5b9a\u306e\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u304b\u3089\u5909\u66f4\u3067\u304d\u307e\u3059\u3002");
                return false;
            }
            String subject = "[" + ALOrgUtilsService.getAlias() + "] \u643a\u5e2f\u96fb\u8a71\u7528\u30ed\u30b0\u30a4\u30f3URL";
            String body = this.createMsgForCellPhone(this.url);
            ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
            for (ALEipUserAddr destMember : destMemberList) {
                ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                message.setPcSubject(null);
                message.setCellularSubject(subject);
                message.setPcBody(null);
                message.setCellularBody(body);
                messageList.add(message);
            }
            List errors = ALMailService.sendAdminMail((ALAdminMailContext)new ALAdminMailContext(this.orgId, (int)user.getUserId().getValue(), messageList, 2));
            msgList.addAll(errors);
            if (errors.size() > 0) {
                msgList.add("\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u304c\u6b63\u3057\u304f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + ALOrgUtilsService.getAlias() + "\u306e\u7ba1\u7406\u62c5\u5f53\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u306f\u3001\u7ba1\u7406\u753b\u9762\u3067\u8a2d\u5b9a\u3067\u304d\u307e\u3059\u3002");
                res = false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"cellular", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    private String createMsgForCellPhone(String url) {
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer(JetspeedResources.getString((String)"aipo.alias"));
        body.append("\u304b\u3089\u306e\u304a\u77e5\u3089\u305b\u3067\u3059\u3002\u4ee5\u4e0b\u306b\u8a18\u8f09\u3055\u308c\u305fURL\u304b\u3089");
        body.append(ALOrgUtilsService.getAlias());
        body.append("\u306b\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        body.append("\u30ed\u30b0\u30a4\u30f3\u3059\u308b\u3068\u304d\u306b\u306f\u901a\u5e38\u4f7f\u7528\u3057\u3066\u3044\u308b\u30ed\u30b0\u30a4\u30f3\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR);
        body.append(url).append(CR);
        return body.toString();
    }

    public ALStringField getCellularUrl() {
        return this.cellular_url;
    }

    public boolean enableEasyLogin() {
        return this.enableEasyLogin;
    }
}

