/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.WriterWrapper;
import java.util.Map;
import org.apache.shindig.protocol.conversion.xstream.NamespaceSet;
import org.apache.shindig.protocol.conversion.xstream.WriterStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackWriterWrapper
extends WriterWrapper {
    private WriterStack writerStack;
    private Map<String, NamespaceSet> namespaces;

    public StackWriterWrapper(HierarchicalStreamWriter wrapped, WriterStack writerStack, Map<String, NamespaceSet> namespaces) {
        super(wrapped);
        this.writerStack = writerStack;
        this.namespaces = namespaces;
    }

    public void addAttribute(String name, String value) {
        if (!"class".equals(name)) {
            super.addAttribute(name, value);
        }
    }

    public void startNode(String name) {
        super.startNode(this.translateName(name));
        this.addNamespace(name);
    }

    public void startNode(String name, Class clazz) {
        super.startNode(this.translateName(name), clazz);
        this.addNamespace(name);
    }

    private String translateName(String name) {
        NamespaceSet namespaceSet = this.namespaces.get(name);
        NamespaceSet currentNamespace = this.writerStack.peekNamespace();
        if (namespaceSet != null && namespaceSet != currentNamespace) {
            return namespaceSet.getElementName(name);
        }
        if (currentNamespace != null) {
            return currentNamespace.getElementName(name);
        }
        return name;
    }

    private void addNamespace(String name) {
        NamespaceSet namespaceSet = this.namespaces.get(name);
        NamespaceSet currentNamespace = this.writerStack.peekNamespace();
        if (namespaceSet != null && namespaceSet != currentNamespace) {
            for (Map.Entry<String, String> e : namespaceSet.nameSpaceEntrySet()) {
                super.addAttribute(e.getKey(), e.getValue());
            }
            currentNamespace = namespaceSet;
        }
        this.writerStack.push(name, currentNamespace);
    }

    public void endNode() {
        this.writerStack.pop();
        super.endNode();
    }
}

