/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp;

import com.sk_jp.Debug;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Log {
    public static final int level;
    private static final String DEFAULT = "system";
    private static final String directory;
    private static final Map logs;
    private String name;
    private PrintWriter out;

    public static Log get() {
        return Log.get(DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log get(String string) {
        String string2 = string.intern();
        synchronized (string2) {
            Log log = (Log)logs.get(string);
            if (log == null) {
                log = new Log(string);
            }
            return log;
        }
    }

    public static synchronized void close() {
        Iterator iterator = logs.values().iterator();
        while (iterator.hasNext()) {
            ((Log)iterator.next()).out.close();
        }
    }

    public static void log(Object object) {
        Log.log(object, 1, DEFAULT);
    }

    public static void log(Object object, String string) {
        Log.log(object, 1, string);
    }

    public static void log(Object object, int n) {
        Log.log(object, n, DEFAULT);
    }

    public static void log(Object object, int n, String string) {
        if (level < n) {
            return;
        }
        Log.get(string).printLog(object);
    }

    public static void log(Throwable throwable) {
        if (level < 1) {
            return;
        }
        Log.get(DEFAULT).printLog(throwable, 0);
    }

    public static void log(Throwable throwable, String string) {
        if (level < 1) {
            return;
        }
        Log.get(string).printLog(throwable, 0);
    }

    public static void log(Throwable throwable, int n) {
        if (level < n) {
            return;
        }
        Log.get(DEFAULT).printLog(throwable, n);
    }

    public static void log(Throwable throwable, int n, String string) {
        if (level < n) {
            return;
        }
        Log.get(string).printLog(throwable, n);
    }

    public static void log(Object[] objectArray) {
        Log.log(objectArray, 1, DEFAULT);
    }

    public static void log(Object[] objectArray, String string) {
        Log.log(objectArray, 1, string);
    }

    public static void log(Object[] objectArray, int n) {
        Log.log(objectArray, n, DEFAULT);
    }

    public static void log(Object[] objectArray, int n, String string) {
        if (level < n) {
            return;
        }
        Log.get(string).printLog(objectArray);
    }

    public static void dump(byte[] byArray) {
        Log.dump(byArray, 1, DEFAULT);
    }

    public static void dump(byte[] byArray, String string) {
        Log.dump(byArray, 1, string);
    }

    public static void dump(byte[] byArray, int n) {
        Log.dump(byArray, n, DEFAULT);
    }

    public static void dump(byte[] byArray, int n, String string) {
        if (level < n) {
            return;
        }
        Log.get(string).dumpLog(byArray);
    }

    public static void dump(InputStream inputStream) {
        Log.dump(inputStream, 1, DEFAULT);
    }

    public static void dump(InputStream inputStream, String string) {
        Log.dump(inputStream, 1, string);
    }

    public static void dump(InputStream inputStream, int n) {
        Log.dump(inputStream, n, DEFAULT);
    }

    public static void dump(InputStream inputStream, int n, String string) {
        if (level < n) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            Log.get(string).printLog("dump miss!!:" + iOException);
        }
        Log.get(string).dumpLog(byteArrayOutputStream.toByteArray());
    }

    private Log(String string) {
        if (string == null) {
            this.name = DEFAULT;
            this.out = new PrintWriter(System.out){

                public void close() {
                }
            };
        } else {
            this.name = string.intern();
            try {
                this.out = new PrintWriter(new FileWriter(directory + string + ".log", true));
            }
            catch (IOException iOException) {
                Log log = (Log)logs.get(DEFAULT);
                if (log == null) {
                    throw new InternalError("Cannot open\n" + iOException);
                }
                this.out = log.out;
                logs.put(this.name, logs.get(DEFAULT));
                this.printLog(iOException);
                return;
            }
        }
        logs.put(this.name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLog(Object object) {
        String string = this.name;
        synchronized (string) {
            this.printDate();
            this.out.println(object);
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLog(Throwable throwable, int n) {
        String string = this.name;
        synchronized (string) {
            this.printDate();
            if (level < 10) {
                this.out.println(throwable);
            } else {
                throwable.printStackTrace(this.out);
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLog(Object[] objectArray) {
        String string = this.name;
        synchronized (string) {
            this.printDate();
            this.out.println(Debug.arrayToString(objectArray));
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLog(byte[] byArray) {
        String string = this.name;
        synchronized (string) {
            this.printDate();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                String string2;
                if (i > 0) {
                    if (i % 16 == 0) {
                        this.out.println(new String(stringBuffer));
                        stringBuffer.setLength(0);
                    } else {
                        stringBuffer.append(' ');
                    }
                }
                if ((string2 = Integer.toString(byArray[i] & 0xFF, 16)).length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            }
            this.out.println(new String(stringBuffer));
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDate() {
        String string = this.name;
        synchronized (string) {
            this.out.print(DateFormat.getInstance().format(new Date()) + "] ");
        }
    }

    public static String arrayToString(Object[] objectArray) {
        if (objectArray == null) {
            return "array is null";
        }
        return objectArray.length + " elements " + Arrays.asList(objectArray).toString();
    }

    static {
        int n;
        logs = new HashMap();
        try {
            n = Integer.parseInt(System.getProperty("log.level"));
        }
        catch (Exception exception) {
            n = 1;
        }
        level = n;
        String string = System.getProperty("log.directory");
        if (string == null) {
            string = "/tmp/";
        }
        directory = string;
        if (Boolean.getBoolean("log.tofile")) {
            new Log(DEFAULT);
        } else {
            new Log(null);
        }
    }
}

