/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.db.impl;

import com.sk_jp.db.DataBase;
import com.sk_jp.db.Record;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class SimpleFileDataBase
implements DataBase {
    private ArrayList recordList = new ArrayList();
    private String fileName;
    private String[] columnNames;
    private String encoding = System.getProperty("file.encoding");

    public void setIdentifier(String string) {
        this.fileName = string;
        this.load();
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void add(Record record) throws IOException {
        record.setColumnNames(this.columnNames);
        this.recordList.add(record);
    }

    public boolean exist(String string, Object object) throws IOException {
        return this.get(string, object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record get(String string, Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ArrayList arrayList = this.recordList;
        synchronized (arrayList) {
            Iterator iterator = this.recordList.iterator();
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                if (!object.equals(record.get(string))) continue;
                return record;
            }
        }
        return null;
    }

    public Set select(String string) {
        throw new UnsupportedOperationException();
    }

    public void commit() throws IOException {
        this.save();
    }

    public void rollback() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        this.recordList.clear();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.encoding));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    Record record = new Record();
                    record.parse(string);
                    record.setColumnNames(this.columnNames);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void save() throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), this.encoding));
        Iterator iterator = this.recordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            printWriter.println(record.toSerializedString());
        }
        printWriter.close();
    }
}

