/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml.extractor;

import com.sk_jp.xml.extractor.Extractor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.w3c.dom.Node;

public class FilterIterator
implements Iterator {
    private final Iterator target_;
    private Object current_;
    private final String extractElementName_;
    private ArrayList extractors_;

    public FilterIterator(Iterator iterator) {
        this(iterator, null);
    }

    public FilterIterator(Iterator iterator, String string) {
        this.target_ = iterator;
        this.extractElementName_ = string;
    }

    public FilterIterator addExtractor(Extractor extractor) {
        if (this.extractors_ == null) {
            this.extractors_ = new ArrayList();
        }
        this.extractors_.add(extractor);
        return this;
    }

    public Set getResult() {
        HashSet<Object> hashSet = new HashSet<Object>();
        while (this.hasNext()) {
            hashSet.add(this.next());
        }
        return hashSet;
    }

    public List getList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        return arrayList;
    }

    public boolean hasNext() {
        if (this.current_ != null) {
            return true;
        }
        this.current_ = this.getNext();
        return this.current_ != null;
    }

    public Object next() {
        if (this.current_ == null && (this.current_ = this.getNext()) == null) {
            throw new NoSuchElementException();
        }
        Object object = this.current_;
        this.current_ = null;
        return object;
    }

    private Object getNext() {
        while (this.target_.hasNext()) {
            Node node = (Node)this.target_.next();
            if (this.extractElementName_ != null && !this.extractElementName_.equals(node.getNodeName()) || !this.canExtract(node)) continue;
            return node;
        }
        return null;
    }

    private boolean canExtract(Node node) {
        if (this.extractors_ == null) {
            return true;
        }
        Iterator iterator = this.extractors_.iterator();
        while (iterator.hasNext()) {
            if (((Extractor)iterator.next()).canExtract(node)) continue;
            return false;
        }
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "FilterIterator:hasNext = " + this.target_.hasNext();
    }
}

