/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecord;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.gpdb.GpdbRecordSelectData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbRecordMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbRecordMultiDelete.class.getName());
    private static final String LIST_FILTER_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("filter").toString();

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            String gpdbId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)LIST_FILTER_STR);
            EipTGpdb gpdb = GpdbUtils.getEipTGpdb(gpdbId);
            SelectQuery query = Database.query(EipTGpdbRecord.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"gpdb", (Object)gpdbId));
            query.andQualifier(ExpressionFactory.inExp((String)"recordNo", values));
            query.orderAscending("recordNo");
            List gpdbRecordList = query.fetchList();
            if (gpdbRecordList == null || gpdbRecordList.isEmpty()) {
                return false;
            }
            int recordNo = Integer.MIN_VALUE;
            for (EipTGpdbRecord record : gpdbRecordList) {
                Database.delete((Persistent)record);
                GpdbUtils.removeGpdbRecordFile(rundata, gpdbRecordList);
                Database.commit();
                if (recordNo == record.getRecordNo()) continue;
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getGpdbItemId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + gpdb.getGpdbName() + "\u300d \u30c7\u30fc\u30bf\u524a\u9664");
                recordNo = record.getRecordNo();
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }
}

