/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecord;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbItemResultData;
import com.aimluck.eip.gpdb.GpdbKubunValueResultData;
import com.aimluck.eip.gpdb.GpdbRecordResultData;
import com.aimluck.eip.gpdb.GpdbResultData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbRecordSelectData
extends ALAbstractSelectData<EipTGpdbRecord, EipTGpdbRecord>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbRecordSelectData.class.getName());
    private List<GpdbItemResultData> gpdbItemList;
    private String gpdbId;
    private GpdbResultData gpdb;
    private List<GpdbResultData> gpdbAllList;
    private Map<String, GpdbRecordResultData> mapGpdbRecord;
    private Map<String, List<GpdbKubunValueResultData>> mapGpdbKubunValue;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || "".equals(sort.trim())) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"sort");
        }
        super.init(action, rundata, context);
    }

    protected ResultList<EipTGpdbRecord> selectList(RunData rundata, Context context) {
        try {
            String sortValue;
            String sortWhere;
            Integer sort;
            this.gpdbAllList = GpdbUtils.getGpdbAllList();
            this.setCurrentFilterAndSort(rundata, context);
            if (this.gpdbAllList == null || this.gpdbAllList.size() == 0) {
                return null;
            }
            this.gpdbItemList = GpdbUtils.getGpdbItemResultList(this.gpdbId);
            EipTGpdb etgpdb = GpdbUtils.getEipTGpdb(this.gpdbId);
            if (etgpdb != null) {
                this.gpdb = GpdbUtils.getGpdbResultData(etgpdb);
            }
            try {
                sort = Integer.valueOf(this.current_sort);
            }
            catch (Exception e) {
                sort = null;
            }
            if (sort == null) {
                for (GpdbItemResultData item : this.gpdbItemList) {
                    if (!"t".equals(item.getDefaultSortFlg().getValue())) continue;
                    sort = (int)item.getGpdbItemId().getValue();
                    this.current_sort_type = item.getAscDesc().getValue();
                }
            }
            String nullSort = "";
            if (sort == null) {
                sortWhere = " AND r2.gpdb_item_id = (       SELECT r3.gpdb_item_id         FROM eip_t_gpdb_record r3        WHERE r3.record_no = r2.record_no        ORDER BY update_date DESC        LIMIT 1     )";
                sortValue = "r2.update_date";
            } else {
                sortWhere = " AND r2.gpdb_item_id = #bind($sort) ";
                EipTGpdbItem item = GpdbUtils.getEipTGpdbItem("" + sort);
                if (item != null && "08".equals(item.getType())) {
                    sortValue = Database.castToIntRawColumn((String)"r2.value");
                    nullSort = " IS NULL ";
                } else {
                    sortValue = "r2.value";
                    nullSort = " = '' ";
                }
            }
            String ascDesc = this.current_sort_type == null ? "DESC" : this.current_sort_type;
            StringBuilder sql = new StringBuilder().append("SELECT r.* FROM eip_t_gpdb_record r").append(" INNER JOIN eip_t_gpdb_item i").append("    ON i.gpdb_item_id = r.gpdb_item_id").append(" INNER JOIN eip_t_gpdb g").append("    ON g.gpdb_id = r.gpdb_id").append(" WHERE r.gpdb_id = #bind($gpdb_id)").append("   AND i.list_flg = #bind($list_flg)").append(" ORDER BY (SELECT " + sortValue).append("             FROM eip_t_gpdb_record r2").append("            WHERE r2.record_no = r.record_no").append(sortWhere).append("          ) " + nullSort + ascDesc).append("        , (SELECT " + sortValue).append("             FROM eip_t_gpdb_record r2").append("            WHERE r2.record_no = r.record_no").append(sortWhere).append("          ) " + ascDesc).append("        , r.record_no").append("        , i.order_no");
            SQLTemplate sqltemp = Database.sql(EipTGpdbRecord.class, (String)String.valueOf(sql));
            sqltemp.param("gpdb_id", (Object)Integer.valueOf(this.gpdbId));
            sqltemp.param("list_flg", (Object)"t");
            if (sort != null) {
                sqltemp.param("sort", (Object)sort);
                sqltemp.param("sort", (Object)sort);
            }
            ResultList list = new ResultList(sqltemp.fetchList());
            return new ResultList(this.buildPaginatedList((List<EipTGpdbRecord>)list));
        }
        catch (RuntimeException ex) {
            logger.error((Object)"RuntimeException", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private void setCurrentFilterAndSort(RunData rundata, Context context) {
        this.current_filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        this.current_filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        this.current_sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        this.current_sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
    }

    protected List<EipTGpdbRecord> buildPaginatedList(List<EipTGpdbRecord> records) {
        ArrayList<EipTGpdbRecord> list = new ArrayList<EipTGpdbRecord>();
        int countDisp = 0;
        for (GpdbItemResultData item : this.gpdbItemList) {
            if (!"t".equals(item.getListFlg().getValue())) continue;
            ++countDisp;
        }
        int size = records.size();
        this.setPageParam(size / countDisp);
        int start = this.getStart() * countDisp;
        int rowNum = this.getRowsNum() * countDisp;
        int end = start + rowNum <= size ? start + rowNum : size;
        for (int i = start; i < end; ++i) {
            list.add(records.get(i));
        }
        return list;
    }

    protected EipTGpdbRecord selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        this.setCurrentFilterAndSort(rundata, context);
        this.mapGpdbKubunValue = GpdbUtils.getKubunMap();
        this.mapGpdbRecord = GpdbUtils.getGpdbRecordMap(this.gpdbId, ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
        return new EipTGpdbRecord();
    }

    protected Object getResultData(EipTGpdbRecord record) {
        return GpdbUtils.getGpdbRecordResultData(record);
    }

    protected List<GpdbItemResultData> getResultDataDetail(EipTGpdbRecord record) {
        List<GpdbItemResultData> list = GpdbUtils.getGpdbItemResultList(this.gpdbId);
        for (GpdbItemResultData item : list) {
            String type = item.getType().getValue();
            if (!"06".equals(type) && !"07".equals(type)) continue;
            GpdbRecordResultData data = this.mapGpdbRecord.get("" + item.getGpdbItemId().getValue());
            data.setAttachmentFiles(GpdbUtils.getAttachmentFiles((int)data.getGpdbRecordId().getValue()));
        }
        return list;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("gpdb_id", "GPDB_ID");
        return map;
    }

    public String getGpdbId() {
        return this.gpdbId;
    }

    public void setGpdbId(Context context, RunData rundata) {
        String gpdbId = rundata.getParameters().getString("filter", "");
        String sesGpdbId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        if ("".equals(gpdbId)) {
            gpdbId = null == sesGpdbId ? "" : sesGpdbId;
        }
        String filterType = rundata.getParameters().getString("filtertype", "");
        List<GpdbResultData> gpdbAllList = GpdbUtils.getGpdbAllList();
        if (!"".equals(gpdbId) && ("gpdb_id".equals(filterType) || filterType == null || "".equals(filterType)) && this.validateGpdbId(gpdbAllList, gpdbId)) {
            this.gpdbId = gpdbId;
        }
        if (this.gpdbId == null) {
            VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
            String database = portlet.getPortletConfig().getInitParameter("p1d-database", "");
            if (!database.isEmpty() && StringUtils.isNumeric((String)database) && this.validateGpdbId(gpdbAllList, database)) {
                this.gpdbId = database;
            }
            if (this.gpdbId == null && gpdbAllList.size() > 0) {
                this.gpdbId = gpdbAllList.get((int)0).gpdb_id.toString();
            }
        }
        GpdbUtils.passPSML(rundata, context, "p1d-database", this.gpdbId);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)this.gpdbId);
    }

    public List<GpdbResultData> getGpdbAllList() {
        return this.gpdbAllList;
    }

    public List<GpdbItemResultData> getGpdbItemList() {
        return this.gpdbItemList;
    }

    public GpdbResultData getGpdb() {
        return this.gpdb;
    }

    public GpdbRecordResultData getRecordResult(String gpdbItemId) {
        return this.mapGpdbRecord.get(gpdbItemId);
    }

    public List<GpdbKubunValueResultData> getKubunValueList(String kubunId) {
        return this.mapGpdbKubunValue.get(kubunId);
    }

    private boolean validateGpdbId(List<GpdbResultData> allList, String gpdbId) {
        for (GpdbResultData gpdb : allList) {
            if (!gpdb.getGpdbId().toString().equals(gpdbId)) continue;
            return true;
        }
        return false;
    }
}

