/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.user.util;

import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.user.beans.UserEmailLiteBean;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class UserUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)UserUtils.class.getName());

    public static synchronized List<UserLiteBean> getUserLiteBeansFromGroup(RunData rundata, String groupname, boolean includeLoginuser) {
        UserLiteBean user;
        int login_user_id = null != rundata ? ALEipUtils.getUserId((RunData)rundata) : 0;
        ArrayList<UserLiteBean> list = new ArrayList<UserLiteBean>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        List list2 = Database.sql(TurbineUser.class, (String)query).param("groupname", (Object)groupname).fetchList();
        for (TurbineUser tuser : list2) {
            user = new UserLiteBean();
            user.initField();
            user.setUserId(tuser.getUserId());
            user.setName(tuser.getLoginName());
            user.setAliasName(tuser.getFirstName(), tuser.getLastName());
            list.add(user);
        }
        if (!includeLoginuser && login_user_id > 3) {
            for (int i = 0; i < list.size(); ++i) {
                user = list.get(i);
                if (Integer.valueOf(user.getUserId()) != login_user_id) continue;
                list.remove(i);
                break;
            }
        }
        return list;
    }

    public static synchronized List<UserEmailLiteBean> getUserEmailLiteBeansFromGroup(RunData rundata, String groupname, boolean includeLoginuser) {
        UserEmailLiteBean user;
        int login_user_id = null != rundata ? ALEipUtils.getUserId((RunData)rundata) : 0;
        ArrayList<UserEmailLiteBean> list = new ArrayList<UserEmailLiteBean>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, B.EMAIL, D.POSITION ");
        statement.append("FROM turbine_user_group_role as A ");
        statement.append("LEFT JOIN turbine_user as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN turbine_group as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN eip_m_user_position as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        List list2 = Database.sql(TurbineUser.class, (String)query).param("groupname", (Object)groupname).fetchList();
        for (TurbineUser tuser : list2) {
            user = new UserEmailLiteBean();
            user.initField();
            user.setUserId(tuser.getUserId());
            user.setName(tuser.getLoginName());
            user.setAliasName(tuser.getFirstName(), tuser.getLastName());
            user.setEmail(tuser.getEmail());
            list.add(user);
        }
        if (!includeLoginuser && login_user_id > 3) {
            for (int i = 0; i < list.size(); ++i) {
                user = list.get(i);
                if (Integer.valueOf(user.getUserId()) != login_user_id) continue;
                list.remove(i);
                break;
            }
        }
        return list;
    }

    public static List<UserGroupLiteBean> getUserGroupLiteBeans(RunData rundata, boolean isMygroup, boolean isPost, boolean isFacilityGroup) {
        ArrayList<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
        try {
            UserGroupLiteBean bean;
            ALEipGroup group;
            int i;
            int size1;
            if (isMygroup) {
                List mygroup = ALEipUtils.getMyGroups((RunData)rundata);
                size1 = mygroup.size();
                for (i = 0; i < size1; ++i) {
                    group = (ALEipGroup)mygroup.get(i);
                    bean = new UserGroupLiteBean();
                    bean.initField();
                    bean.setGroupId(group.getName().getValue());
                    bean.setName(group.getAliasName().getValue());
                    list.add(bean);
                }
            }
            if (isPost) {
                Map postmap = ALEipManager.getInstance().getPostMap();
                for (ALEipPost post : postmap.values()) {
                    bean = new UserGroupLiteBean();
                    bean.initField();
                    bean.setGroupId(post.getGroupName().getValue());
                    bean.setName(post.getPostName().getValue());
                    list.add(bean);
                }
            }
            if (isFacilityGroup) {
                List facilitygroup = ALEipUtils.getFacilityGroups();
                size1 = facilitygroup.size();
                for (i = 0; i < size1; ++i) {
                    group = (ALEipGroup)facilitygroup.get(i);
                    bean = new UserGroupLiteBean();
                    bean.initField();
                    bean.setGroupId("f;" + group.getName().getValue());
                    bean.setName(group.getAliasName().getValue());
                    list.add(bean);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"UserUtils.getUserGroupLiteBeans", (Throwable)e);
        }
        return list;
    }
}

