/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecardSettings;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.timecard.TimecardResultData;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class TimecardSummaryResultData
implements ALData {
    private ALDateField date = null;
    private List<TimecardResultData> list = null;
    private ALNumberField shugyo = null;
    private ALNumberField jikannai = null;
    private ALNumberField jikannai1 = null;
    private ALNumberField jikannai2 = null;
    private ALNumberField zangyo = null;
    private ALNumberField zangyo1 = null;
    private ALNumberField zangyo2 = null;
    private ALNumberField kyushutsu = null;
    private ALStringField chikoku = null;
    private ALStringField sotai = null;

    public void initField() {
        this.date = new ALDateField();
        this.date.setValue(new Date());
        this.list = new ArrayList<TimecardResultData>();
        this.shugyo = new ALNumberField(0L);
        this.jikannai = new ALNumberField(0L);
        this.jikannai1 = new ALNumberField(0L);
        this.jikannai2 = new ALNumberField(0L);
        this.zangyo = new ALNumberField(0L);
        this.zangyo1 = new ALNumberField(0L);
        this.zangyo2 = new ALNumberField(0L);
        this.kyushutsu = new ALNumberField(0L);
        this.chikoku = new ALStringField();
        this.sotai = new ALStringField();
    }

    public void setDate(Date date) {
        this.date.setValue(date);
    }

    public ALDateField getDate() {
        return this.date;
    }

    public ALNumberField getKyushutsu() {
        return this.kyushutsu;
    }

    public void setKyushutsu(ALNumberField kyushutsu) {
        this.kyushutsu = kyushutsu;
    }

    public ALNumberField getShugyo() {
        return this.shugyo;
    }

    public ALStringField getShugyoStr() {
        return new ALStringField(this.minuteToHour(this.shugyo.getValue()));
    }

    public void setShugyo(ALNumberField shugyo) {
        this.shugyo = shugyo;
    }

    public ALNumberField getJikannai() {
        return this.jikannai;
    }

    public ALStringField getJikannaiStr() {
        return new ALStringField(this.minuteToHour(this.jikannai.getValue()));
    }

    public ALNumberField getJikannai1() {
        return this.jikannai1;
    }

    public ALStringField getJikannai1Str() {
        return new ALStringField(this.minuteToHour(this.jikannai1.getValue()));
    }

    public ALNumberField getJikannai2() {
        return this.jikannai2;
    }

    public ALStringField getJikannai2Str() {
        return new ALStringField(this.minuteToHour(this.jikannai2.getValue()));
    }

    public ALNumberField getZangyo() {
        return this.zangyo;
    }

    public ALStringField getZangyoStr() {
        return new ALStringField(this.minuteToHour(this.zangyo.getValue()));
    }

    public void setZangyo(ALNumberField zangyo) {
        this.zangyo = zangyo;
    }

    public ALNumberField getZangyo1() {
        return this.zangyo1;
    }

    public ALStringField getZangyo1Str() {
        return new ALStringField(this.minuteToHour(this.zangyo1.getValue()));
    }

    public ALNumberField getZangyo2() {
        return this.zangyo2;
    }

    public ALStringField getZangyo2Str() {
        return new ALStringField(this.minuteToHour(this.zangyo2.getValue()));
    }

    public ALStringField getChikoku() {
        return this.chikoku;
    }

    public ALStringField getSotai() {
        return this.sotai;
    }

    private String minuteToHour(long minute) {
        BigDecimal decimal = new BigDecimal((double)minute / 60.0);
        DecimalFormat dformat = new DecimalFormat("##.#");
        String str = dformat.format(decimal.setScale(1, 3).doubleValue());
        return str;
    }

    public String getDateStr() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5(EE)");
            return sdf.format(this.date.getValue().getDate());
        }
        catch (Exception e) {
            return "";
        }
    }

    public List<TimecardResultData> getList() {
        return this.list;
    }

    public List<TimecardResultData> getViewList() {
        ArrayList<TimecardResultData> viewlist = new ArrayList<TimecardResultData>();
        TimecardResultData rd = null;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            rd = this.list.get(i);
            if ("-1".equals(rd.getWorkFlag().getValue())) continue;
            viewlist.add(rd);
        }
        return viewlist;
    }

    public void addTimecardResultData(TimecardResultData rd) {
        this.list.add(rd);
    }

    public void calc() {
        try {
            EipTTimecardSettings settings = this.loadEipTTimecardSettings();
            Calendar cal = Calendar.getInstance();
            cal.set(1, Integer.parseInt(this.date.getYear()));
            cal.set(2, Integer.parseInt(this.date.getMonth()) - 1);
            cal.set(5, Integer.parseInt(this.date.getDay()));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date startDate = cal.getTime();
            Date endDate = null;
            cal.set(11, settings.getStartHour());
            cal.set(12, settings.getStartMinute());
            Date kinmuStartDate = cal.getTime();
            cal.set(11, settings.getEndHour());
            cal.set(12, settings.getEndMinute());
            Date kinmuEndDate = cal.getTime();
            ArrayList<TimecardResultData> tempList = new ArrayList<TimecardResultData>();
            boolean startflg = false;
            for (TimecardResultData rd : this.list) {
                if ("1".equals(rd.getWorkFlag().getValue())) {
                    startDate = rd.getWorkDate().getValue();
                    if (startflg) {
                        tempList.add(this.createTimecardResultData(startDate, "0"));
                    }
                    tempList.add(rd);
                    startflg = true;
                    continue;
                }
                if (!"0".equals(rd.getWorkFlag().getValue())) continue;
                if (!startflg) {
                    tempList.add(this.createTimecardResultData(startDate, "1"));
                }
                endDate = rd.getWorkDate().getValue();
                if (kinmuStartDate.after(startDate) && kinmuStartDate.before(endDate)) {
                    tempList.add(this.createTimecardResultData(kinmuStartDate, "0"));
                    tempList.add(this.createTimecardResultData(kinmuStartDate, "1"));
                }
                if (kinmuEndDate.after(startDate) && kinmuEndDate.before(endDate)) {
                    tempList.add(this.createTimecardResultData(kinmuEndDate, "0"));
                    tempList.add(this.createTimecardResultData(kinmuEndDate, "1"));
                }
                tempList.add(rd);
                startDate = endDate;
                startflg = false;
            }
            if (startflg) {
                cal.set(5, cal.get(5) + 1);
                cal.set(11, 0);
                cal.set(12, 0);
                endDate = cal.getTime();
                if (kinmuStartDate.after(startDate) && kinmuStartDate.before(endDate)) {
                    tempList.add(this.createTimecardResultData(kinmuStartDate, "0"));
                    tempList.add(this.createTimecardResultData(kinmuStartDate, "1"));
                }
                if (kinmuEndDate.after(startDate) && kinmuEndDate.before(endDate)) {
                    tempList.add(this.createTimecardResultData(kinmuEndDate, "0"));
                    tempList.add(this.createTimecardResultData(kinmuEndDate, "1"));
                }
                TimecardResultData rd = new TimecardResultData();
                rd.initField();
                rd.setWorkDate(endDate);
                rd.setWorkFlag("0");
                tempList.add(rd);
            }
            long shugyo_temp = 0L;
            long jikannai_temp = 0L;
            long zangyo_temp = 0L;
            boolean iszangyo = false;
            for (TimecardResultData rd : tempList) {
                if ("1".equals(rd.getWorkFlag().getValue())) {
                    startDate = rd.getWorkDate().getValue();
                    if (kinmuStartDate.equals(startDate) || kinmuStartDate.before(startDate) && kinmuEndDate.after(startDate)) {
                        iszangyo = false;
                        continue;
                    }
                    iszangyo = true;
                    continue;
                }
                if (!"0".equals(rd.getWorkFlag().getValue())) continue;
                endDate = rd.getWorkDate().getValue();
                long millisecond = endDate.getTime() - startDate.getTime();
                shugyo_temp += millisecond / 1000L / 60L;
                if (iszangyo) {
                    zangyo_temp += millisecond / 1000L / 60L;
                    continue;
                }
                jikannai_temp += millisecond / 1000L / 60L;
            }
            this.jikannai1.setValue(jikannai_temp);
            if (jikannai_temp >= (long)settings.getWorktimeIn().intValue()) {
                this.jikannai.setValue(jikannai_temp - (long)settings.getResttimeIn().intValue());
                this.jikannai2.setValue((long)settings.getResttimeIn().intValue());
            } else {
                this.jikannai.setValue(jikannai_temp);
                this.jikannai2.setValue(0L);
            }
            long nnn = zangyo_temp / (long)settings.getWorktimeOut().intValue();
            this.zangyo.setValue(zangyo_temp - (long)settings.getResttimeOut().intValue() * nnn);
            this.zangyo1.setValue(zangyo_temp);
            this.zangyo2.setValue((long)settings.getResttimeOut().intValue() * nnn);
            this.shugyo.setValue(this.jikannai.getValue() + this.zangyo.getValue());
            if (tempList.size() > 0 && kinmuStartDate.before(((TimecardResultData)tempList.get(0)).getWorkDate().getValue())) {
                this.chikoku.setValue("\u25cb");
            }
            if (tempList.size() > 0 && kinmuEndDate.after(((TimecardResultData)tempList.get(tempList.size() - 1)).getWorkDate().getValue())) {
                this.sotai.setValue("\u25cb");
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private TimecardResultData createTimecardResultData(Date date, String workflag) {
        TimecardResultData rd = new TimecardResultData();
        rd.initField();
        rd.setWorkDate(date);
        rd.setWorkFlag(workflag);
        return rd;
    }

    private EipTTimecardSettings loadEipTTimecardSettings() {
        SelectQuery query = Database.query(EipTTimecardSettings.class);
        return (EipTTimecardSettings)query.fetchSingle();
    }
}

