/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.memo;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.memo.MemoLiteResultData;
import com.aimluck.eip.memo.MemoResultData;
import com.aimluck.eip.memo.util.MemoUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MemoSelectData
extends ALAbstractSelectData<EipTMemo, EipTMemo>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MemoSelectData.class.getName());
    private int memoSum;
    private List<MemoLiteResultData> memoLiteList;
    private ALStringField target_keyword;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        this.target_keyword = new ALStringField();
    }

    public void loadMemoIdList(RunData rundata, Context context) {
        try {
            this.memoLiteList = new ArrayList<MemoLiteResultData>();
            SelectQuery<EipTMemo> query = this.getSelectQuery(rundata, context);
            List list = query.fetchList();
            for (EipTMemo model : list) {
                MemoLiteResultData rd = new MemoLiteResultData();
                rd.initField();
                rd.setMemoId(model.getMemoId().intValue());
                rd.setMemoName(model.getMemoName());
                this.memoLiteList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"memo", (Throwable)ex);
        }
    }

    public ResultList<EipTMemo> selectList(RunData rundata, Context context) {
        try {
            if (MemoUtils.hasResetFlag(rundata, context)) {
                MemoUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
            } else {
                this.target_keyword.setValue(MemoUtils.getTargetKeyword(rundata, context));
            }
            SelectQuery<EipTMemo> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.memoSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"memo", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<EipTMemo> buildSelectQueryForFilter(SelectQuery<EipTMemo> query, RunData rundata, Context context) {
        String search;
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        String string = crt_key = filter_type != null ? map.getValue(filter_type) : null;
        if (filter != null && filter_type != null && !filter.equals("") && crt_key != null) {
            Expression exp = ExpressionFactory.matchDbExp((String)crt_key, (Object)filter);
            query.andQualifier(exp);
            this.current_filter = filter;
            this.current_filter_type = filter_type;
        }
        if ((search = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR)) != null && !search.equals("")) {
            this.current_search = search;
            Expression ex1 = ExpressionFactory.likeExp((String)"memoName", (Object)("%" + search + "%"));
            Expression ex2 = ExpressionFactory.likeExp((String)"note", (Object)("%" + search + "%"));
            SelectQuery q = Database.query(EipTMemo.class);
            q.andQualifier(ex1.orExp(ex2));
            List queryList = q.fetchList();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (EipTMemo item : queryList) {
                resultid.add(item.getMemoId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex = ExpressionFactory.inDbExp((String)"MEMO_ID", resultid);
            query.andQualifier(ex);
        }
        return query;
    }

    private SelectQuery<EipTMemo> getSelectQuery(RunData rundata, Context context) {
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR, (String)this.target_keyword.getValue());
        } else {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR);
        }
        SelectQuery query = Database.query(EipTMemo.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp1);
        return this.buildSelectQueryForFilter((SelectQuery<EipTMemo>)query, rundata, context);
    }

    protected Object getResultData(EipTMemo record) {
        try {
            MemoResultData rd = new MemoResultData();
            rd.initField();
            rd.setMemoId(record.getMemoId().intValue());
            rd.setMemoName(record.getMemoName());
            rd.setNote(record.getNote());
            rd.setUpdateDate(record.getUpdateDate());
            rd.setCreateDate(record.getCreateDate());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"memo", (Throwable)ex);
            return null;
        }
    }

    public EipTMemo selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        EipTMemo memo = MemoUtils.getEipTMemo(rundata, context);
        return memo;
    }

    protected Object getResultDataDetail(EipTMemo record) {
        try {
            MemoResultData rd = new MemoResultData();
            rd.initField();
            rd.setMemoId(record.getMemoId().intValue());
            rd.setMemoName(record.getMemoName());
            rd.setNote(record.getNote());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"memo", (Throwable)ex);
            return null;
        }
    }

    public int getMemoSum() {
        return this.memoSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("memo_name", "memoName");
        map.putValue("update_date", "updateDate");
        map.putValue("create_date", "createDate");
        return map;
    }

    public List<MemoLiteResultData> getMemoLiteList() {
        return this.memoLiteList;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }
}

