/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.memo.util;

import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MemoUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MemoUtils.class.getName());
    public static final String MEMO_PORTLET_NAME = "Memo";
    public static final String TARGET_KEYWORD = "keyword";
    public static final String SESSION_KEYWORD = "memo_keyword";
    public static final String NEW_FLAG = "new_flag";
    private static final String RESET_FLAG = "reset_params";

    private static boolean isMemoIDEmpty(String memoid) {
        return memoid == null || "".equals(memoid) || Integer.valueOf(memoid) == null;
    }

    public static EipTMemo getEipTMemo(RunData rundata, Context context) throws ALPageNotFoundException {
        try {
            EipTMemo memo;
            String memoid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)NEW_FLAG);
            if (MemoUtils.isMemoIDEmpty(memoid) || !"MemoScreen".equals(rundata.getScreenTemplate())) {
                memoid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
                if (MemoUtils.isMemoIDEmpty(memoid) && MemoUtils.isMemoIDEmpty(memoid = rundata.getParameters().getString("entityid"))) {
                    return MemoUtils.getLatestEipTMemo(rundata, context);
                }
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)NEW_FLAG, null);
            }
            if ((memo = MemoUtils.getEipTMemo(rundata, context, Integer.valueOf(memoid))) == null) {
                return MemoUtils.getLatestEipTMemo(rundata, context);
            }
            return memo;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"memo", (Throwable)ex);
            return null;
        }
    }

    public static boolean saveMemoSelection(RunData rundata, String entityid) {
        String portletEntryId = rundata.getParameters().getString("js_peid", null);
        if (portletEntryId == null || "".equals(portletEntryId)) {
            return false;
        }
        String MEMO_IDX = "p1a-memos";
        try {
            Profile profile = ((JetspeedRunData)rundata).getProfile();
            Portlets portlets = profile.getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            PsmlParameter param = null;
            int length = portletList.length;
            block3: for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    boolean hasParam = false;
                    Parameter[] params = entries[j].getParameter();
                    int param_len = params.length;
                    for (int k = 0; k < param_len; ++k) {
                        if (!params[k].getName().equals(MEMO_IDX)) continue;
                        params[k].setValue(entityid);
                        entries[j].setParameter(k, params[k]);
                        hasParam = true;
                    }
                    if (hasParam) continue block3;
                    param = new PsmlParameter();
                    param.setName(MEMO_IDX);
                    param.setValue(entityid);
                    entries[j].addParameter((Parameter)param);
                    continue block3;
                }
            }
            profile.store();
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            logger.error((Object)"[MemoUtils]", (Throwable)e);
        }
        catch (ProfileException e) {
            logger.error((Object)"[MemoUtils]", (Throwable)e);
        }
        return false;
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)SESSION_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)SESSION_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)SESSION_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)SESSION_KEYWORD, (String)"");
    }

    public static EipTMemo getEipTMemo(RunData rundata, Context context, Integer memoid) throws ALPageNotFoundException {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            if (memoid == null) {
                logger.debug((Object)"[MemoUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTMemo.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"MEMO_ID", (Object)memoid);
            exp.andExp(ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata)));
            query.setQualifier(exp);
            List memos = query.fetchList();
            if (memos == null || memos.size() == 0) {
                logger.debug((Object)"[MemoUtils] Not found ID...");
                return null;
            }
            EipTMemo memo = (EipTMemo)memos.get(0);
            if (uid != memo.getOwnerId()) {
                logger.debug((Object)"[MemoUtils] Invalid user access...");
                throw new ALPageNotFoundException();
            }
            return (EipTMemo)memos.get(0);
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"memo", (Throwable)ex);
            return null;
        }
    }

    public static EipTMemo getLatestEipTMemo(RunData rundata, Context context) throws ALPageNotFoundException {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            SelectQuery query = Database.query(EipTMemo.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List memos = query.fetchList();
            if (memos == null || memos.size() == 0) {
                logger.debug((Object)"[MemoUtils] Not found records...");
                return null;
            }
            EipTMemo latest_memo = (EipTMemo)memos.get(0);
            for (EipTMemo memo : memos) {
                if (!memo.getUpdateDate().after(latest_memo.getUpdateDate())) continue;
                if (uid != memo.getOwnerId()) {
                    logger.debug((Object)"[MemoUtils] Invalid user access...");
                    throw new ALPageNotFoundException();
                }
                latest_memo = memo;
            }
            return latest_memo;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"memo", (Throwable)ex);
            return null;
        }
    }
}

