/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import org.apache.torque.adapter.DB;
import org.apache.torque.oid.AutoIncrementIdGenerator;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.oid.SequenceIdGenerator;

public class IDGeneratorFactory {
    public static final String[] ID_GENERATOR_METHODS = new String[]{"native", "autoincrement", "sequence"};

    public static IdGenerator create(DB dbAdapter) {
        String idMethod = dbAdapter.getIDMethodType();
        if ("autoincrement".equals(idMethod)) {
            return new AutoIncrementIdGenerator(dbAdapter);
        }
        if ("sequence".equals(idMethod)) {
            return new SequenceIdGenerator(dbAdapter);
        }
        return null;
    }
}

