/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.eventlog.EventlogResultData;
import com.aimluck.eip.eventlog.util.ALEventlogUtils;
import com.aimluck.eip.eventlog.util.EventlogUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class EventlogSelectData
extends ALAbstractSelectData<EipTEventlog, EipTEventlog>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)EventlogSelectData.class.getName());
    private static final int MAX_SIZE = 50000;
    private int eventlogSum;
    private ALDateTimeField start_date;
    private ALDateTimeField end_date;
    private int start_date_max_day;
    private int end_date_max_day;
    private int view_date_max_year;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort_type;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        if ((sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR)) == null || "".equals(sort_type)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        Calendar cal = Calendar.getInstance();
        this.view_date_max_year = cal.get(1);
        this.start_date = new ALDateTimeField();
        cal = EventlogUtils.getViewCalendar(true, rundata, context);
        this.start_date.setValue(cal.getTime());
        this.start_date_max_day = cal.getActualMaximum(5);
        this.end_date = new ALDateTimeField();
        cal = EventlogUtils.getViewCalendar(false, rundata, context);
        this.end_date.setValue(cal.getTime());
        this.end_date_max_day = cal.getActualMaximum(5);
        super.init(action, rundata, context);
    }

    public ALDateTimeField getStartDate() {
        return this.start_date;
    }

    public int getMaxSize() {
        return 50000;
    }

    public ALDateTimeField getEndDate() {
        return this.end_date;
    }

    public int getStartDateMaxDay() {
        return this.start_date_max_day;
    }

    public int getEndDateMaxDay() {
        return this.end_date_max_day;
    }

    public int getViewDateMaxYear() {
        return this.view_date_max_year;
    }

    public ResultList<EipTEventlog> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTEventlog> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            this.buildSelectQueryForDate(query, rundata, context);
            ResultList list = query.getResultList();
            this.eventlogSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private void buildSelectQueryForDate(SelectQuery<EipTEventlog> query, RunData rundata, Context context) {
        Expression exp1 = ExpressionFactory.greaterOrEqualExp((String)"eventDate", (Object)this.start_date.getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.end_date.getValue());
        cal.set(5, cal.get(5) + 1);
        Expression exp2 = ExpressionFactory.lessExp((String)"eventDate", (Object)cal.getTime());
        query.andQualifier(exp1.andExp(exp2));
    }

    public boolean isOverSize() {
        return this.getCount() > 50000;
    }

    private SelectQuery<EipTEventlog> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTEventlog.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(EipTEventlog record) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5(EE)HH:mm:ss");
            EventlogResultData rd = new EventlogResultData();
            rd.initField();
            rd.setEventlogId(record.getEventlogId().longValue());
            TurbineUser user = record.getTurbineUser();
            rd.setUserFullName(user == null ? "" : new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString());
            if (user != null && user.getLastName().trim().equals("") && user.getFirstName().trim().equals("")) {
                rd.setUserFullName(record.getTurbineUser().getEmail());
            }
            rd.setEventDate(df.format(record.getUpdateDate()));
            rd.setPortletName(ALEventlogUtils.getPortletAliasName((int)record.getPortletType()));
            rd.setEntityId(record.getEntityId().longValue());
            rd.setIpAddr(record.getIpAddr());
            rd.setEventName(ALEventlogUtils.getEventAliasName((int)record.getEventType()));
            rd.setNote(record.getNote());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    public EipTEventlog selectDetail(RunData rundata, Context context) {
        return EventlogUtils.getEipTEventlog(rundata, context);
    }

    protected Object getResultDataDetail(EipTEventlog record) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5(EE)HH:mm:ss");
            EventlogResultData rd = new EventlogResultData();
            rd.initField();
            rd.setEventlogId(record.getEventlogId().longValue());
            String userFullName = ALEipUtils.getUserFullName((int)record.getTurbineUser().getUserId());
            if (userFullName != null && !userFullName.trim().equals("")) {
                rd.setUserFullName(userFullName);
            }
            if (userFullName == null || userFullName.trim().equals("")) {
                rd.setUserFullName(record.getTurbineUser().getEmail());
            }
            rd.setEventDate(df.format(record.getUpdateDate()));
            rd.setPortletName(ALEventlogUtils.getPortletAliasName((int)record.getPortletType()));
            rd.setEntityId(record.getEntityId().longValue());
            rd.setIpAddr(record.getIpAddr());
            rd.setEventName(ALEventlogUtils.getEventAliasName((int)record.getEventType()));
            rd.setNote(record.getNote());
            String dataName = EventlogUtils.getPortletDataName(record.getPortletType(), record.getEntityId());
            if (dataName != null && !"".equals(dataName)) {
                rd.setDataName(dataName);
                rd.setDataNameFlag(true);
            } else {
                String tmp_dataName = record.getNote();
                if (tmp_dataName != null && !"".equals(tmp_dataName)) {
                    rd.setDataName(tmp_dataName);
                    rd.setDataNameFlag(true);
                }
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    public int getEventlogSum() {
        return this.eventlogSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("event_date", "eventDate");
        map.putValue("user_name", "turbineUser.lastNameKana");
        map.putValue("portlet_id", "portletType");
        map.putValue("event_type", "eventType");
        map.putValue("ip_addr", "ipAddr");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

