/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.eventlog.util;

import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class EventlogUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)EventlogUtils.class.getName());
    public static final String VIEW_DATE_YEAR = "view_date_year";
    public static final String VIEW_DATE_MONTH = "view_date_month";
    public static final String VIEW_DATE_DAY = "view_date_day";
    public static final String EVENTLOG_PORTLET_NAME = "Eventlog";

    public static Calendar getViewCalendar(boolean start_end, RunData rundata, Context context) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        if (start_end) {
            cal.set(2, cal.get(2) - 1);
        }
        int[] par = new int[]{1, 2, 5};
        String[] str = new String[]{"_date_year", "_date_month", "_date_day"};
        String head = start_end ? "start" : "end";
        for (int i = 0; i < str.length; ++i) {
            str[i] = head.concat(str[i]);
            EventlogUtils.setCalendar(cal, par[i], str[i], rundata, context);
        }
        return cal;
    }

    private static void setCalendar(Calendar cal, int par, String viewdate, RunData rundata, Context context) {
        String temp = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)viewdate);
        String idParam = rundata.getParameters().getString(viewdate);
        if (idParam != null || temp != null) {
            if (idParam != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)viewdate, (String)idParam);
                int i = Integer.parseInt(idParam);
                if (par == 2) {
                    --i;
                }
                cal.set(par, i);
            } else if (temp != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)viewdate, (String)temp);
                int i = Integer.parseInt(temp);
                if (par == 2) {
                    --i;
                }
                cal.set(par, i);
            }
        }
    }

    public static EipTEventlog getEipTEventlog(RunData rundata, Context context) {
        String logid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (logid == null || Integer.valueOf(logid) == null) {
                logger.debug((Object)"[EventlogUtils] Empty ID...");
                return null;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"EVENTLOG_ID", (Object)logid);
            SelectQuery query = Database.query(EipTEventlog.class, (Expression)exp);
            List logs = query.fetchList();
            if (logs == null || logs.size() == 0) {
                logger.debug((Object)"[EventlogUtils] Not found ID...");
                return null;
            }
            return (EipTEventlog)logs.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    public static String getPortletDataName(int portletType, int entityId) {
        if (portletType == 0) {
            return null;
        }
        if (portletType == 1) {
            return null;
        }
        if (portletType == 2) {
            return null;
        }
        if (portletType == 3) {
            return "nothing";
        }
        if (portletType == 100) {
            return "nothing";
        }
        if (portletType == 110) {
            return EventlogUtils.getBlogEntryName(entityId);
        }
        if (portletType == 111) {
            return EventlogUtils.getBlogEntryThema(entityId);
        }
        if (portletType == 120) {
            return EventlogUtils.getWorkFlowRequestName(entityId);
        }
        if (portletType == 121) {
            return EventlogUtils.getWorkFlowCategoryName(entityId);
        }
        if (portletType == 130) {
            return EventlogUtils.getTodoName(entityId);
        }
        if (portletType == 131) {
            return EventlogUtils.getTodoCategoryName(entityId);
        }
        if (portletType == 150) {
            return EventlogUtils.getTimecardName(entityId);
        }
        if (portletType == 160) {
            return EventlogUtils.getAddressBookName(entityId);
        }
        if (portletType == 161) {
            return EventlogUtils.getAddressBookCompanyName(entityId);
        }
        if (portletType == 162) {
            return EventlogUtils.getAddressBookGroupName(entityId);
        }
        if (portletType == 170) {
            return EventlogUtils.getMemoName(entityId);
        }
        if (portletType == 180) {
            return EventlogUtils.getMsgboardTopicName(entityId);
        }
        if (portletType == 181) {
            return EventlogUtils.getMsgboardCategoryName(entityId);
        }
        if (portletType == 190) {
            return "nothing";
        }
        if (portletType == 200) {
            return "nothing";
        }
        if (portletType == 210) {
            return "nothing";
        }
        if (portletType == 220) {
            return EventlogUtils.getCabinetFileName(entityId);
        }
        if (portletType == 221) {
            return EventlogUtils.getCabinetFolderName(entityId);
        }
        if (portletType == 230) {
            return "nothing";
        }
        if (portletType == 231) {
            return EventlogUtils.getWebMailAccountName(entityId);
        }
        if (portletType == 240) {
            return EventlogUtils.getScheduleName(entityId);
        }
        if (portletType == 250) {
            return "nothing";
        }
        if (portletType == 260) {
            return null;
        }
        if (portletType == 270) {
            return EventlogUtils.getMyGroupName(entityId);
        }
        if (portletType == 280) {
            return "nothing";
        }
        if (portletType == 290) {
            return "nothing";
        }
        if (portletType == 140) {
            return EventlogUtils.getNoteName(entityId);
        }
        if (portletType == 300) {
            return EventlogUtils.getCommonCategoryName(entityId);
        }
        if (portletType == 330) {
            return null;
        }
        return "nothing";
    }

    private static String getAddressBookGroupName(int entityId) {
        try {
            EipMAddressGroup group = (EipMAddressGroup)Database.get(EipMAddressGroup.class, (Object)entityId);
            if (group == null) {
                return null;
            }
            String dataName = group.getGroupName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getAddressBookCompanyName(int entityId) {
        try {
            EipMAddressbookCompany company = (EipMAddressbookCompany)Database.get(EipMAddressbookCompany.class, (Object)entityId);
            if (company == null) {
                return null;
            }
            String dataName = company.getCompanyName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getAddressBookName(int entityId) {
        try {
            EipMAddressbook address = (EipMAddressbook)Database.get(EipMAddressbook.class, (Object)entityId);
            if (address == null) {
                return null;
            }
            String dataName = new StringBuffer().append(address.getLastName()).append(" ").append(address.getLastName()).toString();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getBlogEntryThema(int entityId) {
        try {
            EipTBlogThema thema = (EipTBlogThema)Database.get(EipTBlogThema.class, (Object)entityId);
            if (thema == null) {
                return null;
            }
            String dataName = thema.getThemaName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getTodoName(int entityId) {
        try {
            EipTTodo todo = (EipTTodo)Database.get(EipTTodo.class, (Object)entityId);
            if (todo == null) {
                return null;
            }
            String dataName = todo.getTodoName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getTodoCategoryName(int category_id) {
        try {
            EipTTodoCategory category = (EipTTodoCategory)Database.get(EipTTodoCategory.class, (Object)category_id);
            if (category == null) {
                return null;
            }
            String dataName = category.getCategoryName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getBlogEntryName(int entityId) {
        try {
            EipTBlogEntry blog = (EipTBlogEntry)Database.get(EipTBlogEntry.class, (Object)entityId);
            if (blog == null) {
                return null;
            }
            String dataName = blog.getTitle();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getWorkFlowRequestName(int entityId) {
        try {
            EipTWorkflowRequest request = (EipTWorkflowRequest)Database.get(EipTWorkflowRequest.class, (Object)entityId);
            if (request == null) {
                return null;
            }
            String dataName = request.getEipTWorkflowCategory().getCategoryName() + " " + request.getRequestName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getWorkFlowCategoryName(int category_id) {
        try {
            EipTWorkflowCategory category = (EipTWorkflowCategory)Database.get(EipTWorkflowCategory.class, (Object)category_id);
            if (category == null) {
                return null;
            }
            String dataName = category.getCategoryName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getWebMailAccountName(int entityId) {
        try {
            EipMMailAccount account = (EipMMailAccount)Database.get(EipMMailAccount.class, (Object)entityId);
            if (account == null) {
                return null;
            }
            String dataName = account.getAccountName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getTimecardName(int entityId) {
        try {
            EipTTimecard timecard = (EipTTimecard)Database.get(EipTTimecard.class, (Object)entityId);
            if (timecard == null) {
                return null;
            }
            String dataName = timecard.getReason();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getScheduleName(int entityId) {
        try {
            EipTSchedule schedule = (EipTSchedule)Database.get(EipTSchedule.class, (Object)entityId);
            if (schedule == null) {
                return null;
            }
            String dataName = schedule.getName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getNoteName(int entityId) {
        try {
            EipTNote note = (EipTNote)Database.get(EipTNote.class, (Object)entityId);
            if (note == null) {
                return null;
            }
            String subject = "";
            if (note.getSubjectType().equals("0")) {
                subject = note.getCustomSubject();
            } else if (note.getSubjectType().equals("1")) {
                subject = "\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059";
            } else if (note.getSubjectType().equals("2")) {
                subject = "\u96fb\u8a71\u3092\u3057\u3066\u304f\u3060\u3055\u3044";
            } else if (note.getSubjectType().equals("3")) {
                subject = "\u96fb\u8a71\u304c\u3042\u308a\u307e\u3057\u305f";
            } else if (note.getSubjectType().equals("4")) {
                subject = "\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059";
            }
            String dataName = subject + " (" + note.getClientName() + ")";
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getMyGroupName(int entityId) {
        try {
            TurbineGroup group = (TurbineGroup)Database.get(TurbineGroup.class, (Object)entityId);
            if (group == null) {
                return null;
            }
            String dataName = group.getGroupName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getMsgboardTopicName(int entityId) {
        try {
            EipTMsgboardTopic topic = (EipTMsgboardTopic)Database.get(EipTMsgboardTopic.class, (Object)entityId);
            if (topic == null) {
                return null;
            }
            String dataName = topic.getTopicName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getMsgboardCategoryName(int category_id) {
        try {
            EipTMsgboardCategory category = (EipTMsgboardCategory)Database.get(EipTMsgboardCategory.class, (Object)category_id);
            if (category == null) {
                return null;
            }
            String dataName = category.getCategoryName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getCabinetFileName(int entityId) {
        try {
            EipTCabinetFile file = (EipTCabinetFile)Database.get(EipTCabinetFile.class, (Object)entityId);
            if (file == null) {
                return null;
            }
            String dataName = file.getFileTitle();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getCabinetFolderName(int entityId) {
        try {
            EipTCabinetFolder file = (EipTCabinetFolder)Database.get(EipTCabinetFolder.class, (Object)entityId);
            if (file == null) {
                return null;
            }
            String dataName = file.getFolderName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getCommonCategoryName(int entityId) {
        try {
            EipTCommonCategory category = (EipTCommonCategory)Database.get(EipTCommonCategory.class, (Object)entityId);
            if (category == null) {
                return null;
            }
            String dataName = category.getName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    private static String getMemoName(int memo_id) {
        try {
            EipTMemo memo = (EipTMemo)Database.get(EipTMemo.class, (Object)memo_id);
            if (memo == null) {
                return null;
            }
            String dataName = memo.getMemoName();
            return dataName;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }
}

