/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.wiki;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWiki;
import com.aimluck.eip.cayenne.om.portlet.EipTWikiFile;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.wiki.WikiResultData;
import com.aimluck.eip.wiki.WikiSelectData;
import com.aimluck.eip.wiki.util.WikiFileUtils;
import com.aimluck.eip.wiki.util.WikiUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WikiFormData
extends ALAbstractFormData {
    private ALStringField name;
    private ALNumberField parentId;
    private ALStringField parentName;
    private ALStringField note;
    private Boolean is_child;
    private EipTWiki category;
    private List<WikiResultData> topWikiList;
    private int uid;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WikiFormData.class.getName());
    private final String aclPortletFeature = "";
    private String entityId = null;
    private String mode = null;
    private String update_date = null;
    private List<FileuploadLiteBean> fileuploadList = new ArrayList<FileuploadLiteBean>();
    private String folderName = null;
    private EipTWiki parentWiki = null;
    private String destWikiName = "";

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String _isChild = rundata.getParameters().getString("is_child");
        if (null != _isChild) {
            this.is_child = Boolean.valueOf(_isChild);
        }
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.entityId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        this.mode = rundata.getParameters().getString("mode", "");
        this.folderName = rundata.getParameters().getString("folderName");
        this.update_date = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"update_date");
    }

    public void loadTopWikiList(RunData rundata, Context context) {
        this.topWikiList = WikiUtils.loadTopWikiList(rundata);
    }

    public void initField() {
        this.name = new ALStringField();
        this.name.setFieldName(ALLocalizationUtils.getl10n((String)"WIKI_TITLE"));
        this.name.setTrim(true);
        this.parentId = new ALNumberField();
        this.parentId.setFieldName(ALLocalizationUtils.getl10n((String)"WIKI_PARENT"));
        this.parentId.setValue(0L);
        this.parentName = new ALStringField();
        this.parentName.setFieldName(ALLocalizationUtils.getl10n((String)"WIKI_PARENT"));
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"WIKI_NOTE"));
        this.note.setTrim(false);
    }

    protected void setValidator() {
        this.name.setNotNull(true);
        this.name.limitMaxLength(50);
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
        if (this.is_child != null && this.is_child.booleanValue()) {
            this.parentId.setNotNull(true);
            this.parentId.limitValue(0L, Integer.MAX_VALUE);
        }
    }

    protected boolean validate(List<String> msgList) {
        this.name.validate(msgList);
        this.note.validate(msgList);
        if (this.is_child != null && this.is_child.booleanValue() && this.parentId.validate(msgList) && this.parentId.getValueWithInt() != 0) {
            EipTWiki parentWiki = WikiUtils.getEipTWiki(this.parentId.getValueWithInt());
            if (parentWiki != null) {
                if (parentWiki.getParentId() != 0) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_CONFLICT_PARENT_ERROR"));
                }
            } else {
                msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_CONFLICT_PARENT_ERROR"));
            }
        }
        boolean duplication = false;
        duplication = "update".equals(this.mode) && !StringUtils.isEmpty((String)this.entityId) && StringUtils.isNumeric((String)this.entityId) ? WikiUtils.isTitleDuplicate(this.name.getValue(), Integer.parseInt(this.parentId.toString()), Integer.parseInt(this.entityId)) : WikiUtils.isTitleDuplicate(this.name.getValue(), Integer.parseInt(this.parentId.toString()));
        if (duplication) {
            msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_DUPLICATE_TITLE"));
        }
        if (StringUtils.isNotEmpty((String)this.entityId) && this.entityId.equals(this.parentId.toString())) {
            msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_PARENT_ERROR"));
        }
        if (this.update_date != null && this.entityId != null) {
            EipTWiki eipTWiki = WikiUtils.getEipTWiki(Integer.parseInt(this.entityId));
            if (eipTWiki != null) {
                if (!this.update_date.equals(eipTWiki.getUpdateDate().toString())) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_CONFLICT_ERROR"));
                }
            } else {
                msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_ALREADY_DELETE"));
            }
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWiki wiki = WikiUtils.getEipTWiki(rundata, context);
            this.name.setValue(wiki.getWikiName());
            this.parentId.setValue((long)wiki.getParentId().intValue());
            this.note.setValue(wiki.getNote());
            SelectQuery query = Database.query(EipTWikiFile.class);
            query.andQualifier(ExpressionFactory.matchExp((String)"wikiId", (Object)wiki.getWikiId()));
            List fileList = query.fetchList();
            for (EipTWikiFile file : fileList) {
                FileuploadLiteBean fbean = new FileuploadLiteBean();
                fbean.initField();
                fbean.setFileId(file.getFileId().intValue());
                fbean.setFileName(file.getFileName());
                this.fileuploadList.add(fbean);
            }
            if (wiki.getParentId() != 0) {
                this.setParentWiki(WikiUtils.getEipTWiki(wiki.getParentId()));
                this.is_child = true;
            } else {
                this.is_child = false;
            }
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"update_date", (String)wiki.getUpdateDate().toString());
            if (!this.is_child.booleanValue()) {
                Iterator<WikiResultData> it = this.topWikiList.iterator();
                while (it.hasNext()) {
                    WikiResultData result = it.next();
                    if (!result.getId().toString().equals(String.valueOf(wiki.getWikiId()))) continue;
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"WikiFormData.loadFormData", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWiki wiki = WikiUtils.getEipTWiki(rundata, context);
            if (wiki == null) {
                return false;
            }
            int entityId = wiki.getWikiId();
            if (WikiUtils.getChildCount(entityId) > 0) {
                msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_HAS_CHILDREN"));
                return false;
            }
            String wikiName = wiki.getWikiName();
            WikiFileUtils.deleteFiles(wiki.getWikiId());
            Database.delete((Persistent)wiki);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 360, wikiName);
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"WikiFormData.deleteFormData", t);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWiki wiki = (EipTWiki)Database.create(EipTWiki.class);
            wiki.setWikiName(this.name.getValue());
            if (this.parentId.isNotNullValue()) {
                wiki.setParentId(Integer.valueOf(this.parentId.toString()));
            } else if (null == this.category) {
                wiki.setParentId(Integer.valueOf(0));
            } else {
                wiki.setParentId(this.category.getWikiId());
            }
            wiki.setNote(this.note.getValue());
            TurbineUser turbineUser = ALEipUtils.getTurbineUser((int)this.uid);
            wiki.setCreateUser(turbineUser);
            wiki.setUpdateUser(turbineUser);
            wiki.setCreateDate(Calendar.getInstance().getTime());
            wiki.setUpdateDate(Calendar.getInstance().getTime());
            if (!WikiFileUtils.insertFileDataDelegate(rundata, context, wiki, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            Database.commit();
            ALStorageService.deleteTmpFolder((int)this.uid, (String)this.folderName);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(wiki.getWikiId().intValue(), 360, wiki.getWikiName());
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"WikiFormData.insertFormData", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWiki wiki = WikiUtils.getEipTWiki(rundata, context);
            wiki.setWikiName(this.name.getValue());
            if (this.parentId.isNotNullValue()) {
                int entityId = wiki.getWikiId();
                if (this.parentId.getValue() != 0L && WikiUtils.getChildCount(entityId) > 0) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"WIKI_HAS_CHILDREN_EDIT"));
                    return false;
                }
                wiki.setParentId(Integer.valueOf((int)this.parentId.getValue()));
            }
            wiki.setNote(this.note.getValue());
            TurbineUser turbineUser = ALEipUtils.getTurbineUser((int)this.uid);
            wiki.setUpdateUser(turbineUser);
            wiki.setCreateDate(Calendar.getInstance().getTime());
            wiki.setUpdateDate(Calendar.getInstance().getTime());
            if (!WikiFileUtils.insertFileDataDelegate(rundata, context, wiki, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            Database.commit();
            ALStorageService.deleteTmpFolder((int)this.uid, (String)this.folderName);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(wiki.getWikiId().intValue(), 360, wiki.getWikiName());
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"WikiFormData.updateFormData", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            this.fileuploadList = WikiFileUtils.getFileuploadList(rundata);
        }
        catch (Exception e) {
            logger.error((Object)"WikiFormData.setFormData", (Throwable)e);
        }
        if ("new_form".equals(this.getMode()) && this.isChild()) {
            String filtertype = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)(WikiSelectData.class.getName() + "filtertype"));
            String fileterValue = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)(WikiSelectData.class.getName() + "filter"));
            String wikiId = WikiUtils.getWikiIdFromSession(fileterValue, filtertype);
            if (StringUtils.isNotEmpty((String)wikiId) && StringUtils.isNumeric((String)wikiId)) {
                this.setParentWiki(WikiUtils.getEipTWiki(Integer.parseInt(wikiId)));
            }
        }
        if ("insert".equals(this.getMode())) {
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"update_date");
            this.update_date = null;
        }
        return res;
    }

    public String getAclPortletFeature() {
        return "";
    }

    public boolean isChild() {
        return this.is_child == null ? true : this.is_child != false || this.isChildForm();
    }

    public void setIsChild(boolean isChild) {
        this.is_child = isChild;
    }

    public ALStringField getParentName() {
        return this.parentName;
    }

    public void setNote(String n) {
        this.note.setValue(n);
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getName() {
        return this.name;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setParentWiki(EipTWiki wiki) {
        this.parentWiki = wiki;
    }

    public String getParentIdString() {
        if (null != this.parentWiki && this.parentWiki.getParentId() != null && this.parentWiki.getParentId() != 0) {
            return String.valueOf(this.parentWiki.getParentId());
        }
        return "";
    }

    public String getParentWikiIdString() {
        if (null != this.parentWiki) {
            return String.valueOf(this.parentWiki.getWikiId());
        }
        return "0";
    }

    public String getParentWikiName() {
        if (null == this.parentWiki) {
            return "";
        }
        String name = this.parentWiki.getWikiName();
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        return new ALStringField(name).toString();
    }

    public boolean isChildForm() {
        return null != this.parentWiki;
    }

    public void setDestWikiName(String name) {
        this.destWikiName = name;
    }

    public String getDestWikiName() {
        return new ALStringField(this.destWikiName).toString();
    }

    public String getParentId() {
        return this.parentId.toString();
    }

    public List<WikiResultData> getTopWikiList() {
        return this.topWikiList;
    }
}

