/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.wiki;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWiki;
import com.aimluck.eip.common.ALAbstractMultiFilterSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.wiki.WikiResultData;
import com.aimluck.eip.wiki.util.WikiFileUtils;
import com.aimluck.eip.wiki.util.WikiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.context.Context;

public class WikiSelectData
extends ALAbstractMultiFilterSelectData<EipTWiki, EipTWiki>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WikiSelectData.class.getName());
    private List<WikiResultData> topWikiList;
    private List<ALEipGroup> postList;
    private int table_colum_num = 2;
    private String filterType = "";
    private String postId = "";
    private String postName = "";
    private String categoryId = "";
    private String categoryName = "";
    private ALStringField target_keyword;
    private String baseInternalLink = null;
    private String baseImageLink = null;
    private String baseImageRawLink = null;
    private String entityId = null;
    private String tempNote = null;
    private String tempWikiNote = null;
    private boolean isTop = false;
    private long tempOwnerId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            String sortStr = "update_date";
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)sortStr);
            if ("update_date".equals(sortStr)) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
            }
        }
        this.entityId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        this.target_keyword = new ALStringField();
        super.init(action, rundata, context);
        this.postList = ALEipUtils.getMyGroups((RunData)rundata);
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
            VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
            this.baseInternalLink = jsLink.getPortletById(portlet.getID()).addQueryData("template", "WikiInternalLinkScreen").addQueryData("portletid", portlet.getID()).addQueryData("existWidgets", "marking_widgets_" + portlet.getID()).addQueryData("callback", "aipo.wiki.onLoadWikiDetail").toString();
            String baseLink = jsLink.getPortletById(portlet.getID()).toString();
            this.baseImageLink = baseLink + "/template/WikiFileThumbnailScreen";
            this.baseImageRawLink = baseLink + "/template/FileuploadViewScreen/screen/WikiFileRawScreen";
        }
        catch (TurbineException e) {
            logger.error((Object)"init", (Throwable)e);
        }
    }

    public void loadTopWikiList(RunData rundata, Context context) {
        this.topWikiList = WikiUtils.loadTopWikiList(rundata);
        this.setCategory(rundata, context);
    }

    public boolean validateCategory() {
        if (StringUtils.isEmpty((String)this.categoryId)) {
            return true;
        }
        for (WikiResultData data : this.topWikiList) {
            if (!data.getParentId().toString().equals(this.categoryId)) continue;
            return true;
        }
        return false;
    }

    private void updateCategoryName() {
        this.categoryName = "";
        if (this.topWikiList == null) {
            return;
        }
        for (WikiResultData data : this.topWikiList) {
            if (!data.getId().toString().equals(this.categoryId)) continue;
            this.categoryName = data.getName();
            return;
        }
    }

    private void updatePostName() {
        this.postName = "";
        for (int i = 0; i < this.postList.size(); ++i) {
            String pid = this.postList.get(i).getName().toString();
            if (!pid.equals(this.postId.toString())) continue;
            this.postName = this.postList.get(i).getAliasName().toString();
            return;
        }
        Map map = ALEipManager.getInstance().getPostMap();
        for (Map.Entry item : map.entrySet()) {
            String pid = ((ALEipPost)item.getValue()).getGroupName().toString();
            if (!pid.equals(this.postId.toString())) continue;
            this.postName = ((ALEipPost)item.getValue()).getPostName().toString();
            return;
        }
    }

    public void setCategory(RunData rundata, Context context) {
        String filter = rundata.getParameters().getString("filter", "");
        String filterType = rundata.getParameters().getString("filtertype", "");
        String sesFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String sesFilterType = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        sesFilter = sesFilter == null ? "" : sesFilter;
        String string = sesFilterType = sesFilterType == null ? "" : sesFilterType;
        if (filterType.isEmpty()) {
            filter = sesFilter;
            filterType = sesFilterType;
        }
        if (filterType.equals("category")) {
            filter = "0," + filter;
            filterType = "post,category";
        } else if (!filterType.equals("post,category")) {
            filter = "";
            filterType = "";
        }
        if (StringUtils.isEmpty((String)filter) || StringUtils.isEmpty((String)filterType)) {
            this.filterType = "";
            this.categoryId = "";
            return;
        }
        String[] splited = filter.split(",");
        if (splited.length < 2) {
            this.filterType = "";
            this.categoryId = "";
            return;
        }
        this.categoryId = filter.split(",")[1];
        this.filterType = filterType;
        boolean existCategory = false;
        for (WikiResultData data : this.topWikiList) {
            if (!this.categoryId.equals(data.getId().toString())) continue;
            existCategory = true;
            break;
        }
        if (!existCategory) {
            this.categoryId = "0";
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)(filter.split(",")[0] + "," + this.categoryId));
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"post,category");
        }
    }

    public ResultList<EipTWiki> selectList(RunData rundata, Context context) {
        try {
            if (WikiUtils.hasResetFlag(rundata, context)) {
                WikiUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
            } else {
                this.target_keyword.setValue(WikiUtils.getTargetKeyword(rundata, context));
            }
            SelectQuery<EipTWiki> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.setPageParam(list.getTotalCount());
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"WikiSelectData.selectList", (Throwable)e);
            return null;
        }
    }

    private SelectQuery<EipTWiki> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTWiki.class);
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            String keyword = "%" + this.target_keyword.getValue() + "%";
            Expression exp = ExpressionFactory.likeExp((String)"wikiName", (Object)keyword);
            Expression exp2 = ExpressionFactory.likeExp((String)"note", (Object)keyword);
            query.andQualifier(exp.orExp(exp2));
        }
        return this.buildSelectQueryForFilter((SelectQuery<EipTWiki>)query, rundata, context);
    }

    protected void parseFilterMap(String key, String val) {
        super.parseFilterMap(key, val);
        HashSet unUse = new HashSet();
        for (Map.Entry pair : this.current_filterMap.entrySet()) {
            if (!((List)pair.getValue()).contains("0")) continue;
            unUse.add(pair.getKey());
        }
        for (String unusekey : unUse) {
            this.current_filterMap.remove(unusekey);
        }
    }

    protected SelectQuery<EipTWiki> buildSelectQueryForFilter(SelectQuery<EipTWiki> query, RunData rundata, Context context) {
        String search;
        Expression exp;
        if (this.current_filterMap.containsKey("category")) {
            List categoryIds = (List)this.current_filterMap.get("category");
            this.categoryId = ((String)categoryIds.get(0)).toString();
            if (null == this.topWikiList) {
                this.topWikiList = WikiUtils.loadTopWikiList(rundata);
            }
            boolean existCategory = false;
            if (this.topWikiList != null && this.topWikiList.size() > 0) {
                for (WikiResultData category : this.topWikiList) {
                    if (!this.categoryId.equals(category.getId().toString())) continue;
                    existCategory = true;
                    break;
                }
            }
            if (!existCategory) {
                this.categoryId = "";
                this.current_filterMap.remove("category");
            } else {
                exp = ExpressionFactory.matchExp((String)"parentId", (Object)this.categoryId);
                Expression exp2 = ExpressionFactory.matchDbExp((String)"WIKI_ID", (Object)this.categoryId);
                query.andQualifier(exp.orExp(exp2));
            }
            this.updateCategoryName();
        }
        super.buildSelectQueryForFilter(query, rundata, context);
        if (this.current_filterMap.containsKey("post")) {
            List postIds = (List)this.current_filterMap.get("post");
            HashSet<Integer> userIds = new HashSet<Integer>();
            for (String post : postIds) {
                List userId = ALEipUtils.getUserIds((String)post);
                userIds.addAll(userId);
            }
            if (userIds.isEmpty()) {
                userIds.add(-1);
            }
            exp = ExpressionFactory.inExp((String)"updateUserId", userIds);
            query.andQualifier(exp);
            this.postId = ((String)postIds.get(0)).toString();
            this.updatePostName();
        }
        if ((search = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SEARCH_STR)) != null && !"".equals(search)) {
            this.current_search = search;
            Expression ex1 = ExpressionFactory.likeExp((String)"note", (Object)("%" + search + "%"));
            Expression ex2 = ExpressionFactory.likeExp((String)"wikiName", (Object)("%" + search + "%"));
            SelectQuery q = Database.query(EipTWiki.class);
            q.andQualifier(ex1.orExp(ex2));
            List queryList = q.fetchList();
            ArrayList<Integer> resultid = new ArrayList<Integer>();
            for (EipTWiki item : queryList) {
                resultid.add(item.getWikiId());
            }
            if (resultid.size() == 0) {
                resultid.add(-1);
            }
            Expression ex = ExpressionFactory.inDbExp((String)"WIKI_ID", resultid);
            query.andQualifier(ex);
        }
        return query;
    }

    protected Object getResultData(EipTWiki record) {
        try {
            WikiResultData rd = new WikiResultData();
            rd.initField();
            rd.setId(record.getWikiId().longValue());
            rd.setName(record.getWikiName());
            rd.setParentId(record.getParentId().intValue());
            if (record.getParentId() != 0) {
                rd.setParentName(WikiUtils.getEipTWiki(record.getParentId()).getWikiName());
            }
            rd.setUpdateUser(ALEipUtils.getALEipUser((int)record.getUpdateUserId()).getAliasName().getValue());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            rd.setUpdateUserId(record.getUpdateUserId().intValue());
            return rd;
        }
        catch (Exception e) {
            logger.error((Object)"WikiSelectData.getResultData", (Throwable)e);
            return null;
        }
    }

    public EipTWiki selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTWiki wiki = WikiUtils.getEipTWiki(rundata, context);
        return wiki;
    }

    protected Object getResultDataDetail(EipTWiki record) {
        try {
            String updatedUserName;
            WikiResultData rd = new WikiResultData();
            rd.initField();
            String link = this.baseInternalLink + "&name=${title}&parentId=" + String.valueOf(record.getParentId() == 0 ? record.getWikiId() : record.getParentId());
            rd.initalizeWikiModel(this.baseImageLink, link);
            ALEipUser createdUser = ALEipUtils.getALEipUser((int)record.getCreateUserId());
            String createdUserName = createdUser.getAliasName().getValue();
            rd.setCreateUser(createdUserName);
            if (record.getCreateUserId().equals(record.getUpdateUserId())) {
                updatedUserName = createdUserName;
            } else {
                ALEipUser updatedUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
                updatedUserName = updatedUser.getAliasName().getValue();
            }
            rd.setUpdateUser(updatedUserName);
            rd.setId(record.getWikiId().longValue());
            rd.setName(record.getWikiName());
            rd.setNote(record.getNote());
            rd.setOwnerId(record.getCreateUserId().intValue());
            rd.setCreateUser(ALEipUtils.getALEipUser((int)record.getCreateUserId()).getAliasName().getValue());
            rd.setUpdateUser(ALEipUtils.getALEipUser((int)record.getUpdateUserId()).getAliasName().getValue());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            rd.setBaseInternalLink(this.baseImageLink);
            rd.setBaseImageRawLink(this.baseImageRawLink);
            rd.setAttachmentFiles(WikiFileUtils.getAttachmentFiles(record.getWikiId()));
            rd.setParentId(record.getParentId().intValue());
            if (record.getParentId() != 0) {
                EipTWiki parentWiki = WikiUtils.getEipTWiki(record.getParentId());
                rd.setParentName(parentWiki.getWikiName());
            }
            this.tempOwnerId = rd.getOwnerId().getValue();
            return rd;
        }
        catch (Exception e) {
            logger.error((Object)"WikiSelectData.getResultDataDetail", (Throwable)e);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("wiki_name", "wikiName");
        map.putValue("parent_name", "parentId");
        map.putValue("update_user", "updateUserId");
        map.putValue("update_date", "updateDate");
        return map;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public List<WikiResultData> getTopWikiList() {
        return this.topWikiList;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }

    public List<ALEipGroup> getPostList() {
        return this.postList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public void setTableColumNum(int table_colum_num) {
        this.table_colum_num = table_colum_num;
    }

    public int getTableColumNum() {
        return this.table_colum_num;
    }

    public String getPostName() {
        return this.postName;
    }

    public void setFiltersFromPSML(VelocityPortlet portlet, Context context, RunData rundata) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)portlet.getPortletConfig().getInitParameter("p12f-filters"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)portlet.getPortletConfig().getInitParameter("p12g-filtertypes"));
    }

    public void doViewDetailOne(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 2);
            action.setMode("detail");
            String sesFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            String sesFilterType = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
            String wikiId = WikiUtils.getWikiIdFromSession(sesFilter, sesFilterType);
            EipTWiki obj = null;
            String entityId = rundata.getParameters().getString("entityId", "");
            if (!StringUtils.isEmpty((String)entityId)) {
                try {
                    EipTWiki eipTWiki = WikiUtils.getEipTWiki(Integer.parseInt(entityId));
                    if (eipTWiki != null) {
                        obj = eipTWiki;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"doViewDetailOne", (Throwable)e);
                }
            } else if (WikiUtils.existWiki(wikiId, this.topWikiList)) {
                obj = WikiUtils.getEipTWiki(Integer.parseInt(wikiId));
            }
            if (obj == null) {
                obj = WikiUtils.getEipTWikiOne();
            }
            if (obj != null) {
                this.data = this.getResultDataDetail(obj);
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            if (null != this.data) {
                Integer categoryId = 0;
                categoryId = obj.getParentId() == 0 ? obj.getWikiId() : obj.getParentId();
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"category");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)String.valueOf(categoryId));
                rundata.getParameters().setString("filtertype", "category");
                rundata.getParameters().setString("filter", String.valueOf(categoryId));
                this.setCategory(rundata, context);
                this.parseFilterMap(rundata, context);
            }
        }
        catch (ALPageNotFoundException ignore) {
        }
        catch (ALDBErrorException e) {
            logger.error((Object)"doViewDetailOne", (Throwable)e);
        }
        catch (ALPermissionException e) {
            logger.error((Object)"doViewDetailOne", (Throwable)e);
        }
    }

    public void setIsTop(boolean isTop) {
        this.isTop = isTop;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setTempNote(String tn, RunData rundata, Context context) {
        WikiResultData result = new WikiResultData();
        result.initField();
        result.setNote(tn);
        this.tempNote = tn;
        if (this.entityId != null) {
            result.setId(Long.parseLong(this.entityId));
            result.setOwnerId(this.tempOwnerId);
            result.setBaseImageRawLink(this.baseImageRawLink);
            result.setBaseInternalLink(this.baseImageLink);
            List<FileuploadBean> tempFileuploadList = WikiFileUtils.getAttachmentFiles(Integer.parseInt(this.entityId));
            result.setAttachmentFiles(tempFileuploadList);
        }
        this.tempWikiNote = result.getNote();
    }

    public String getTempNote() {
        return this.tempNote;
    }

    public String getTempWikiNote() {
        return this.tempWikiNote;
    }
}

