/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.TagStack;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WPBlockQuote
extends WPTag {
    private String contents = "";
    private Map<String, String> fAttributes = null;

    public WPBlockQuote() {
        super("{quote}");
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        buf.append("\n<blockquote");
        HTMLTag.appendEscapedAttributes(buf, this.fAttributes);
        buf.append(">");
        String rawWikiText = Utils.ltrimNewline((String)this.contents);
        AbstractParser parser = wikiModel.createNewInstance(rawWikiText);
        TagStack fStack = parser.parseRecursiveInternal(wikiModel, true, false);
        converter.nodesToText(fStack.getNodeList(), buf, wikiModel);
        buf.append("</blockquote>");
    }

    public Object clone() {
        WPBlockQuote tt = (WPBlockQuote)((Object)super.clone());
        tt.fAttributes = this.fAttributes == null ? null : new HashMap<String, String>(this.fAttributes);
        return tt;
    }

    public boolean isReduceTokenStack() {
        return true;
    }

    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }
}

