/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.webmacro.TurbineWebMacro;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.webmacro.servlet.WebContext;

public class WebMacroSiteScreen
extends TemplateScreen {
    protected void doBuildTemplate(RunData data, WebContext context) throws Exception {
    }

    protected void doBuildTemplate(RunData data) throws Exception {
        this.doBuildTemplate(data, WebMacroSiteScreen.getContext(data));
    }

    public ConcreteElement buildTemplate(RunData data) throws Exception {
        WebContext context = WebMacroSiteScreen.getContext(data);
        String templateName = data.getTemplateInfo().getScreenTemplate();
        if (templateName.length() > 0 && templateName.charAt(0) != '/') {
            templateName = '/' + templateName;
        }
        StringElement output = new StringElement();
        output.setFilterState(false);
        String screenData = null;
        try {
            screenData = this.buildWMTemplate(context, "screens" + templateName);
        }
        catch (Exception e) {
            context.put((Object)"processingException", (Object)e.toString());
            context.put((Object)"stackTrace", (Object)StringUtils.stackTrace(e));
            templateName = TurbineResources.getString("template.error", "/error.wm");
            if (templateName.length() > 0 && templateName.charAt(0) != '/') {
                templateName = '/' + templateName;
            }
            screenData = this.buildWMTemplate(context, "screens" + templateName);
        }
        output.addElement(screenData);
        return output;
    }

    public static WebContext getContext(RunData data) {
        WebContext wc = (WebContext)data.getTemplateInfo().getTemplateContext("WEBMACRO_CONTEXT");
        if (wc == null) {
            wc = TurbineWebMacro.getContext(data);
            data.getTemplateInfo().setTemplateContext("WEBMACRO_CONTEXT", wc);
        }
        return wc;
    }

    protected String buildWMTemplate(WebContext context, String templateFile) throws Exception {
        return TurbineWebMacro.handleRequest(context, templateFile);
    }
}

