/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.turbine.om.security.SecurityObject;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ObjectUtils;

public class TurbineUser
extends SecurityObject
implements User {
    private Date createDate = new Date();
    private Date lastAccessDate = null;
    private Hashtable permStorage = null;
    private Hashtable tempStorage = new Hashtable(10);

    public TurbineUser() {
        this.permStorage = new Hashtable(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    public Date getLastLogin() {
        return (Date)this.getPerm("LAST_LOGIN");
    }

    public String getPassword() {
        return (String)this.getPerm("PASSWORD_VALUE");
    }

    public Object getPerm(String name) {
        return this.permStorage.get(name);
    }

    public Object getPerm(String name, Object def) {
        try {
            Object val = this.permStorage.get(name);
            return val == null ? def : val;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Hashtable getPermStorage() {
        if (this.permStorage == null) {
            this.permStorage = new Hashtable();
        }
        return this.permStorage;
    }

    public Object getTemp(String name) {
        return this.tempStorage.get(name);
    }

    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.tempStorage.get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    public String getUserName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("LOGIN_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }

    public String getFirstName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("FIRST_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }

    public String getLastName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("LAST_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }

    public boolean hasLoggedIn() {
        Boolean loggedIn = this.getHasLoggedIn();
        return loggedIn != null && loggedIn != false;
    }

    public String getEmail() {
        return (String)this.getPerm("EMAIL");
    }

    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    public Object removeTemp(String name) {
        return this.tempStorage.remove(name);
    }

    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", new Integer(cnt));
    }

    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", new Integer(cnt));
    }

    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    public void setLastLogin(Date date) {
        this.setPerm("LAST_LOGIN", date);
    }

    public void setPassword(String password) {
        this.setPerm("PASSWORD_VALUE", password);
    }

    public void setPerm(String name, Object value) {
        ObjectUtils.safeAddToHashtable(this.getPermStorage(), name, value);
    }

    public void setPermStorage(Hashtable stuff) {
        this.permStorage = stuff;
    }

    public Hashtable getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable();
        }
        return this.tempStorage;
    }

    public void setTempStorage(Hashtable storage) {
        this.tempStorage = storage;
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }

    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    public void setTemp(String name, Object value) {
        ObjectUtils.safeAddToHashtable(this.tempStorage, name, value);
    }

    public void setUserName(String username) {
        this.setPerm("LOGIN_NAME", username);
    }

    public void setFirstName(String firstName) {
        this.setPerm("FIRST_NAME", firstName);
    }

    public void setLastName(String lastName) {
        this.setPerm("LAST_NAME", lastName);
    }

    public void setEmail(String address) {
        this.setPerm("EMAIL", address);
    }

    public boolean isConfirmed() {
        String value = this.getConfirmed();
        return value != null && value.equals("CONFIRMED");
    }

    public void setConfirmed(String value) {
        String val = "";
        if (value != null) {
            val = value;
        }
        this.setPerm("CONFIRM_VALUE", val);
    }

    public String getConfirmed() {
        return (String)this.getPerm("CONFIRM_VALUE");
    }

    public void updateLastLogin() throws Exception {
        this.setPerm("LAST_LOGIN", new Date());
    }

    public void valueBound(HttpSessionBindingEvent hsbe) {
    }

    public void valueUnbound(HttpSessionBindingEvent hsbe) {
        try {
            if (this.hasLoggedIn()) {
                TurbineSecurity.saveUser(this);
            }
        }
        catch (Exception e) {
            Log.error("TurbineUser.valueUnbobund(): " + e.getMessage(), e);
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(ostr, true));
            String stackTrace = ostr.toString();
            System.out.println(stackTrace);
        }
    }

    public void save() throws Exception {
        if (TurbineSecurity.accountExists(this)) {
            TurbineSecurity.saveUser(this);
        } else {
            TurbineSecurity.addUser(this, this.getPassword());
        }
    }

    public void save(Connection conn) throws Exception {
        throw new Exception("not implemented");
    }

    public void save(String dbname) throws Exception {
        throw new Exception("not implemented");
    }
}

