/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker.util.python;

import java.io.File;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.python.core.Py;
import org.python.util.PythonInterpreter;

public abstract class PythonBaseFactory
implements AssemblerFactory {
    static /* synthetic */ Class class$org$apache$turbine$modules$Assembler;

    public Assembler getAssembler(String subDirectory, String name) throws Exception {
        Assembler assembler = null;
        String fName = null;
        String confName = null;
        Log.info("Screen name for JPython " + name);
        try {
            String path = TurbineResources.getString("services.AssemblerBrokerService.python.path") + "/";
            confName = path + "conf.py";
            fName = path + subDirectory + "/" + name.toLowerCase() + ".py";
        }
        catch (Exception e) {
            throw new Exception("Python path not found - check your Properties");
        }
        File f = new File(fName);
        if (f.exists()) {
            try {
                PythonInterpreter interp = new PythonInterpreter();
                Py.getSystemState().setClassLoader(this.getClass().getClassLoader());
                interp.exec("import sys");
                interp.execfile(confName);
                interp.execfile(fName);
                try {
                    interp.exec("scr = " + name + "()");
                }
                catch (Throwable e) {
                    throw new Exception("\nCannot create an instance of the python class.\nYou probably gave your class the wrong name.\nYour class should have the same name as your filename.\nFilenames should be all lowercase and classnames should start with a capital.\nExpected class name: " + name + "\n");
                }
                assembler = (Assembler)interp.get("scr", class$org$apache$turbine$modules$Assembler == null ? (class$org$apache$turbine$modules$Assembler = PythonBaseFactory.class$("org.apache.turbine.modules.Assembler")) : class$org$apache$turbine$modules$Assembler);
            }
            catch (Exception e) {
                Log.error("PYTHON SCRIPT SCREEN LOADER ERROR:");
                Log.error(e.toString());
                throw e;
            }
        }
        return assembler;
    }

    public abstract Assembler getAssembler(String var1) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

